/*
 * Decompiled with CFR 0.152.
 */
package com.agrota.logic.service.impl;

import com.agrota.logic.data.Producto;
import com.agrota.logic.service.MetodosAsincronosService;
import com.agrota.utils.UtilLhia;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriUtils;

@Service
public class MetodosAsincronosServiceImpl
implements MetodosAsincronosService {
    private static final Logger log = LoggerFactory.getLogger(MetodosAsincronosServiceImpl.class);
    private final RestTemplate restTemplate = new RestTemplate();
    UtilLhia util = new UtilLhia();

    @Async
    public CompletableFuture<String> obtenerLlegadaProducto(String codigo, Date fecha_actual) {
        String url;
        try {
            String encodedPath = UriUtils.encodePathSegment((String)codigo, (String)"UTF-8");
            String baseUrl = "https://felizia-api.lhia.ai/api/productospvp/byCodeTransito/{CodigoVentaProducto}";
            url = UriComponentsBuilder.fromUriString((String)baseUrl).buildAndExpand(new Object[]{encodedPath}).toUriString();
        }
        catch (Exception e) {
            throw new RuntimeException("Error al codificar el par\u00e1metro de la URL", e);
        }
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        try {
            StringBuilder productos = new StringBuilder();
            for (Producto p : (List)response.getBody()) {
                if (p.getFechaLlegada().contains("S\"N") || !this.util.stringToDate(p.getFechaLlegada()).after(fecha_actual)) continue;
                productos.append("el producto con el codigo de venta: " + p.getCodigoVentaProducto() + " , con la descripcion: " + p.getDescripcionProducto() + " , con la marca: " + p.getMarca() + " , con la linea: " + p.getLinea() + " , con la categoria: " + p.getCategoria() + " , con la descripcion: " + p.getDescripcionProducto() + " , con el tipo de producto: " + p.getTipoProducto() + " , con la descripcion: " + p.getDescripcionProducto() + " , con el stock o existencia la cantidad de: " + p.getExistencia() + " , en la bodega: " + p.getNombreBodega() + " , su fecha de llagada es el: " + p.getFechaLlegada() + " , y la cantidad a llegar es: " + p.getCantidadCompraDetalle() + "\n\n");
            }
            return CompletableFuture.completedFuture(productos.toString());
        }
        catch (Exception e) {
            throw new RuntimeException("Error al codificar el par\u00e1metro de la URL", e);
        }
    }

    @Async
    public CompletableFuture<String> obtenerProductoPorCodigo(String codigo) {
        String url;
        try {
            String encodedPath = UriUtils.encodePathSegment((String)codigo, (String)"UTF-8");
            String baseUrl = "https://felizia-api.lhia.ai/api/productospvp/byCode/{CodigoVentaProducto}";
            url = UriComponentsBuilder.fromUriString((String)baseUrl).buildAndExpand(new Object[]{encodedPath}).toUriString();
        }
        catch (Exception e) {
            throw new RuntimeException("Error al codificar el par\u00e1metro de la URL", e);
        }
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        try {
            StringBuilder productos = new StringBuilder();
            for (Producto p : (List)response.getBody()) {
                if (p.getExistencia().equals("0")) continue;
                productos.append("el producto con el codigo de venta: " + p.getCodigoVentaProducto() + " , con la descripcion: " + p.getDescripcionProducto() + " , con la marca: " + p.getMarca() + " , con la linea: " + p.getLinea() + " , con la categoria: " + p.getCategoria() + " , con el stock o existencia la cantidad de: " + p.getExistencia() + " , con el tipo de producto: " + p.getTipoProducto() + " , en la bodega: " + p.getNombreBodega() + "\n\n");
            }
            return CompletableFuture.completedFuture(productos.toString());
        }
        catch (Exception e) {
            throw new RuntimeException("Error al codificar el par\u00e1metro de la URL", e);
        }
    }

    @Async
    public CompletableFuture<String> obtenerPrecioProductoPorCodigo(String codigo) {
        String url;
        try {
            String encodedPath = UriUtils.encodePathSegment((String)codigo, (String)"UTF-8");
            String baseUrl = "https://felizia-api.lhia.ai/api/productospvp/byCode/{CodigoVentaProducto}";
            url = UriComponentsBuilder.fromUriString((String)baseUrl).buildAndExpand(new Object[]{encodedPath}).toUriString();
        }
        catch (Exception e) {
            throw new RuntimeException("Error al codificar el par\u00e1metro de la URL", e);
        }
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, null, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
        try {
            StringBuilder productos = new StringBuilder();
            for (Producto p : (List)response.getBody()) {
                if (p.getExistencia().equals("0")) continue;
                productos.append("el producto con el codigo de venta: " + p.getCodigoVentaProducto() + " , con la descripcion: " + p.getDescripcionProducto() + " , con la marca: " + p.getMarca() + " , con la linea: " + p.getLinea() + " , con la categoria: " + p.getCategoria() + " , con el stock o existencia la cantidad de: " + p.getExistencia() + " , con el tipo de producto: " + p.getTipoProducto() + " , en la bodega: " + p.getNombreBodega() + " , el precio es: " + p.getPvp() + " , el producto " + (p.getPvp().equals("1") ? "si paga iva" : "no paga iva") + "\n\n");
            }
            return CompletableFuture.completedFuture(productos.toString());
        }
        catch (Exception e) {
            throw new RuntimeException("Error al codificar el par\u00e1metro de la URL", e);
        }
    }
}

