/*
 * Decompiled with CFR 0.152.
 */
package com.agrota.logic.service.impl;

import com.agrota.feignClient.models.ProcesoDTO;
import com.agrota.logic.data.CalificacionesUsuarios;
import com.agrota.logic.model.Calificacion;
import com.agrota.logic.model.Conversacion;
import com.agrota.logic.repository.CalificacionesDAO;
import com.agrota.logic.repository.ConversacionDAO;
import com.agrota.logic.service.AuthenticationService;
import com.agrota.logic.service.GovernanzaService;
import com.agrota.logic.service.LhiaTrainService;
import com.agrota.utils.UtilLhia;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class GovernanzaServiceImpl
implements GovernanzaService {
    private static final Logger log = LoggerFactory.getLogger(GovernanzaServiceImpl.class);
    private final ConversacionDAO conversacionDAO;
    private final CalificacionesDAO calificacionDAO;
    private final LhiaTrainService lhiaTrainService;
    private final AuthenticationService authService;

    public ResponseEntity<?> guardarCalificacion(String usuario, String calificacion, String pregunta, String respuesta, String respuestaEsperada) {
        Optional idConversacion = this.conversacionDAO.findIdConversationByUser(usuario);
        if (idConversacion.isPresent()) {
            Calificacion calificacionModel = new Calificacion();
            calificacionModel.setId_conversacion(new Conversacion((Long)idConversacion.get()));
            calificacionModel.setCalificacion(calificacion);
            calificacionModel.setFecha(UtilLhia.fechaEcuador());
            calificacionModel.setPregunta(pregunta.isEmpty() ? "respuesta pregunta anterior" : pregunta);
            calificacionModel.setRespuesta(respuesta);
            calificacionModel.setCalificacion_actualizada(calificacion);
            if (calificacion.toUpperCase().contains("BUENA")) {
                calificacionModel.setEnviado(Boolean.valueOf(true));
                calificacionModel.setRespuesta_esperada("");
                this.sendQualifyToLhiaTrain(pregunta, respuesta, null, true);
            } else {
                calificacionModel.setEnviado(Boolean.valueOf(false));
                calificacionModel.setRespuesta_esperada(respuestaEsperada);
            }
            return ResponseEntity.ok((Object)((Calificacion)this.calificacionDAO.save((Object)calificacionModel)));
        }
        return ResponseEntity.badRequest().build();
    }

    public List<CalificacionesUsuarios> obtenerCalificacionesRespuestasMalas(Date fecha1, Date fecha2) {
        return this.calificacionDAO.listadoCalificacionRespuestasMalas(fecha1, fecha2);
    }

    public ResponseEntity<Calificacion> actualizarEnviadoCalificacionesMalas(Long id, String nueva_respuesta_esperada) {
        Calificacion c = (Calificacion)this.calificacionDAO.findById((Object)id).get();
        c.setEnviado(Boolean.valueOf(true));
        if (!nueva_respuesta_esperada.isEmpty()) {
            c.setRespuesta_esperada(nueva_respuesta_esperada);
        }
        Calificacion c_new = (Calificacion)this.calificacionDAO.save((Object)c);
        this.sendQualifyToLhiaTrain(c.getPregunta(), c.getRespuesta(), c.getRespuesta_esperada(), false);
        return ResponseEntity.ok((Object)c_new);
    }

    public void sendQualifyToLhiaTrain(String pregunta, String respuesta, String respuestaEsperada, boolean esCorrecto) {
        try {
            String email = this.authService.getMyParameter("email");
            ProcesoDTO proceso = new ProcesoDTO();
            proceso.setCorreo(email);
            proceso.setSatisfactorio(Boolean.valueOf(esCorrecto));
            proceso.setPreguntaRealizada(pregunta);
            proceso.setRespuestaLhia(respuesta);
            proceso.setRespuestaEsperada(respuestaEsperada);
            this.lhiaTrainService.crearNuevoProcesoBotpress(proceso);
        }
        catch (Exception e) {
            log.error("error: ", (Throwable)e);
        }
    }

    public GovernanzaServiceImpl(ConversacionDAO conversacionDAO, CalificacionesDAO calificacionDAO, LhiaTrainService lhiaTrainService, AuthenticationService authService) {
        this.conversacionDAO = conversacionDAO;
        this.calificacionDAO = calificacionDAO;
        this.lhiaTrainService = lhiaTrainService;
        this.authService = authService;
    }
}

