/*
 * Decompiled with CFR 0.152.
 */
package com.agrota.logic.service.impl;

import com.agrota.logic.model.CaracteristicasQuimicos;
import com.agrota.logic.model.Documento;
import com.agrota.logic.model.Informacion;
import com.agrota.logic.repository.CaracteristicasQuimicosDAO;
import com.agrota.logic.repository.DocumentoDAO;
import com.agrota.logic.repository.InformacionDAO;
import com.agrota.logic.service.EntrenamientoService;
import com.agrota.utils.UtilLhia;
import jakarta.transaction.Transactional;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EntrenamientoImp
implements EntrenamientoService {
    @Autowired
    InformacionDAO informacionDAO;
    @Autowired
    CaracteristicasQuimicosDAO caracteristicasQuimicosDAO;
    @Autowired
    DocumentoDAO documentoDAO;
    UtilLhia util = new UtilLhia();

    public List<Informacion> obtenerEntrenamientos() {
        List inf = this.informacionDAO.obtenerEntrenamientos();
        return inf;
    }

    @Transactional
    public Informacion actualizarEntrenamiento(Long id) {
        this.informacionDAO.setAllEntrenadoFalse();
        int updatedRows = this.informacionDAO.setEntrenadoTrue(id);
        if (updatedRows > 0) {
            return (Informacion)this.informacionDAO.findById((Object)id).orElseThrow(() -> new RuntimeException("No se encontr\u00f3 el entrenamiento actualizado"));
        }
        throw new RuntimeException("Error al actualizar el entrenamiento");
    }

    public void saveFromExcelInformacionQuimicos(InputStream inputStream) throws Exception {
        XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
        Sheet sheet = workbook.getSheetAt(0);
        Documento d = (Documento)this.documentoDAO.findById((Object)22L).get();
        Informacion informacion_new = new Informacion();
        informacion_new.setDocumento(d);
        EntrenamientoImp entrenamientoImp = this;
        informacion_new.setFecha(entrenamientoImp.util.fechaEcuador());
        informacion_new.setEntrenado(Boolean.valueOf(false));
        Informacion inf = (Informacion)this.informacionDAO.save((Object)informacion_new);
        ArrayList<CaracteristicasQuimicos> quimicos = new ArrayList<CaracteristicasQuimicos>();
        for (int i = 1; i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            CaracteristicasQuimicos quimico = new CaracteristicasQuimicos();
            quimico.setCodigoProducto(row.getCell(0).getStringCellValue());
            quimico.setDescripcion(row.getCell(1).getStringCellValue());
            quimico.setCategoria(row.getCell(2).getStringCellValue());
            quimico.setLinea(row.getCell(3).getStringCellValue());
            quimico.setGrupo(row.getCell(4).getStringCellValue());
            quimico.setMarca(row.getCell(5).getStringCellValue());
            quimico.setKiloLitros(Double.valueOf(row.getCell(6).getNumericCellValue()));
            quimico.setSubMarca(row.getCell(7).getStringCellValue());
            quimico.setTipoMarca(row.getCell(8).getStringCellValue());
            quimico.setCodigoVenta(row.getCell(9).getStringCellValue());
            quimico.setPrecioIva(Double.valueOf(row.getCell(10).getNumericCellValue()));
            quimico.setEstado(row.getCell(11).getStringCellValue());
            quimico.setInformacion(inf);
            quimicos.add(quimico);
        }
        this.caracteristicasQuimicosDAO.saveAll(quimicos);
        workbook.close();
    }
}

