/*
 * Decompiled with CFR 0.152.
 */
package com.agrota.logic.service.impl;

import com.agrota.logic.data.TDispositivos;
import com.agrota.logic.dto.DispositivoDTO;
import com.agrota.logic.model.RespSimple;
import com.agrota.logic.model.TDispositivoSesion;
import com.agrota.logic.model.ViewAccesosDispositivos;
import com.agrota.logic.repository.DispositivoSesionDAO;
import com.agrota.logic.repository.DispositivosDAO;
import com.agrota.logic.service.DispositivoService;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class DispositivoServiceImpl
implements DispositivoService {
    private final DispositivosDAO dispositivosDAO;
    private final DispositivoSesionDAO dispositivoSesionDAO;

    public Long validarDispositivo(String imei, String dispositivo, String identificador, String usuario) {
        TDispositivoSesion session = new TDispositivoSesion(identificador, imei, dispositivo, usuario);
        this.dispositivoSesionDAO.save((Object)session);
        return this.dispositivosDAO.validarDispositivo(imei);
    }

    public TDispositivos activoDesactivo(String identificador) {
        TDispositivos dispositivos;
        dispositivos.setActivo(Boolean.valueOf((dispositivos = this.dispositivosDAO.findByIdentificador(identificador)).getActivo() == false));
        dispositivos.setUpdatedAt(LocalDateTime.now());
        return (TDispositivos)this.dispositivosDAO.save((Object)dispositivos);
    }

    public boolean existByIdentificador(String identificador) {
        return this.dispositivosDAO.existsByIdentificador(identificador);
    }

    public boolean existByIdentificadorandestadoDesactivado(String identificador) {
        return this.dispositivosDAO.existsByIdentificadorAndActivo(identificador, false);
    }

    public TDispositivos aceptarAcceso(DispositivoDTO accesosDispositivos) {
        if (this.existByIdentificadorandestadoDesactivado(accesosDispositivos.getIdentificador())) {
            return this.activoDesactivo(accesosDispositivos.getIdentificador());
        }
        if (this.existByIdentificador(accesosDispositivos.getIdentificador())) {
            throw new IllegalArgumentException("El dispositivo ya existe");
        }
        TDispositivos dispositivoActivo = new TDispositivos();
        dispositivoActivo.setIdentificador(accesosDispositivos.getIdentificador());
        dispositivoActivo.setCreatedAt(LocalDateTime.now());
        dispositivoActivo.setUpdatedAt(LocalDateTime.now());
        dispositivoActivo.setDescripcion(accesosDispositivos.getUsuario());
        dispositivoActivo.setActivo(Boolean.valueOf(true));
        return (TDispositivos)this.dispositivosDAO.save((Object)dispositivoActivo);
    }

    public Page<TDispositivos> listadodeDispositivosactivos(int page, int size) {
        PageRequest pageable = PageRequest.of((int)page, (int)size);
        return this.dispositivosDAO.listadodeDispositivosactivos((Pageable)pageable);
    }

    public Page<TDispositivos> obtenerDispositivosPorEstado(int page, int size, Boolean activo) {
        PageRequest pageable = PageRequest.of((int)page, (int)size);
        return this.dispositivosDAO.findByActivo((Pageable)pageable, activo);
    }

    public Page<ViewAccesosDispositivos> listadodeAccesos(LocalDateTime fecha1, LocalDateTime fecha2, int page, int size) {
        PageRequest pageable = PageRequest.of((int)page, (int)size);
        return this.dispositivoSesionDAO.listadodeAccesos(fecha1, fecha2, (Pageable)pageable);
    }

    public List<TDispositivos> findByUsuario(String usuario) {
        return this.dispositivosDAO.findByDescripcion(usuario);
    }

    public ResponseEntity<RespSimple> guardarSesionporId(TDispositivos dispositivos) {
        return null;
    }

    public ResponseEntity<RespSimple> saveByImei(String imei) {
        return null;
    }

    public DispositivoServiceImpl(DispositivosDAO dispositivosDAO, DispositivoSesionDAO dispositivoSesionDAO) {
        this.dispositivosDAO = dispositivosDAO;
        this.dispositivoSesionDAO = dispositivoSesionDAO;
    }
}

