/*
 * Decompiled with CFR 0.152.
 */
package com.agrota.logic.service.impl;

import com.agrota.logic.dto.ConversacionDetalleDTO;
import com.agrota.logic.model.Actividad;
import com.agrota.logic.model.Carpeta;
import com.agrota.logic.model.Conversacion;
import com.agrota.logic.model.ConversacionDetalle;
import com.agrota.logic.model.Documento;
import com.agrota.logic.model.Usuarios;
import com.agrota.logic.repository.ActividadDAO;
import com.agrota.logic.repository.CarpetaDAO;
import com.agrota.logic.repository.ConversacionDAO;
import com.agrota.logic.repository.ConversacionDetalleDAO;
import com.agrota.logic.repository.DocumentoDAO;
import com.agrota.logic.service.ConversacionService;
import com.agrota.utils.UtilLhia;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConversacionServiceImpl
implements ConversacionService {
    @Autowired
    private ConversacionDAO conversacionDAO;
    @Autowired
    private ConversacionDetalleDAO conversacionDetalleDAO;
    @Autowired
    private DocumentoDAO documentoDAO;
    @Autowired
    private CarpetaDAO carpetaDAO;
    @Autowired
    private ActividadDAO actividadDAO;

    public void guardarConversacion(String identificador, Usuarios usuario, String rol, String mensaje, int prompts, String pregunta, String textSystem, String carpeta) {
        if (this.conversacionDAO.existsByIdentificador(identificador)) {
            if (!rol.equals("system")) {
                ConversacionDetalle conversacion_detalle = new ConversacionDetalle();
                conversacion_detalle.setRol(rol);
                conversacion_detalle.setMensaje(mensaje);
                conversacion_detalle.setScore(0.0);
                conversacion_detalle.setTokens((long)prompts);
                conversacion_detalle.setConversacion((Conversacion)this.conversacionDAO.findByIdentificador(identificador).get());
                conversacion_detalle.setFecha(UtilLhia.fechaEcuador());
                conversacion_detalle.setPregunta(pregunta);
                conversacion_detalle.setCarpeta(this.carpetaDAO.findByNombre(carpeta));
                this.conversacionDetalleDAO.save((Object)conversacion_detalle);
            }
        } else {
            Conversacion nueva_conversacion = new Conversacion();
            ConversacionDetalle conversacion_detalle = new ConversacionDetalle();
            nueva_conversacion.setUsuarios(usuario);
            nueva_conversacion.setIdentificador(identificador);
            nueva_conversacion.setFecha(UtilLhia.fechaEcuador());
            Conversacion aux = (Conversacion)this.conversacionDAO.save((Object)nueva_conversacion);
            conversacion_detalle.setRol(rol);
            conversacion_detalle.setScore(0.0);
            conversacion_detalle.setSystem(textSystem);
            conversacion_detalle.setTokens((long)prompts);
            conversacion_detalle.setConversacion(aux);
            conversacion_detalle.setFecha(UtilLhia.fechaEcuador());
            conversacion_detalle.setPregunta(pregunta);
            conversacion_detalle.setCarpeta(this.carpetaDAO.findByNombre(carpeta));
            this.conversacionDetalleDAO.save((Object)conversacion_detalle);
        }
    }

    public void guardarConversacionCliente(String identificador, Usuarios usuario, String rol, String mensaje, int prompts, String pregunta, String textSystem, String carpeta) {
        if (this.conversacionDAO.existsByIdentificador(identificador)) {
            if (!rol.equals("system")) {
                ConversacionDetalle conversacion_detalle = new ConversacionDetalle();
                conversacion_detalle.setRol(rol);
                conversacion_detalle.setMensaje(mensaje);
                conversacion_detalle.setScore(0.0);
                conversacion_detalle.setTokens((long)prompts);
                conversacion_detalle.setConversacion((Conversacion)this.conversacionDAO.findByIdentificador(identificador).get());
                conversacion_detalle.setFecha(UtilLhia.fechaEcuador());
                conversacion_detalle.setPregunta(pregunta);
                conversacion_detalle.setCarpeta(this.carpetaDAO.findByNombre(carpeta));
                this.conversacionDetalleDAO.save((Object)conversacion_detalle);
            }
        } else {
            Conversacion nueva_conversacion = new Conversacion();
            ConversacionDetalle conversacion_detalle = new ConversacionDetalle();
            nueva_conversacion.setUsuarios(usuario);
            nueva_conversacion.setIdentificador(identificador);
            nueva_conversacion.setFecha(UtilLhia.fechaEcuador());
            Conversacion aux = (Conversacion)this.conversacionDAO.save((Object)nueva_conversacion);
            conversacion_detalle.setRol(rol);
            conversacion_detalle.setScore(0.0);
            conversacion_detalle.setMensaje(mensaje);
            conversacion_detalle.setSystem(textSystem);
            conversacion_detalle.setTokens((long)prompts);
            conversacion_detalle.setConversacion(aux);
            conversacion_detalle.setFecha(UtilLhia.fechaEcuador());
            conversacion_detalle.setPregunta(pregunta);
            conversacion_detalle.setCarpeta(this.carpetaDAO.findByNombre(carpeta));
            this.conversacionDetalleDAO.save((Object)conversacion_detalle);
        }
    }

    public List<ConversacionDetalleDTO> obtenerUltimas3Conversaciones(String usuario, String carpeta) {
        String identificador_antiguo = ((Conversacion)this.conversacionDAO.obtenerUltimaConversacionCliente(usuario, carpeta).get(0)).getIdentificador();
        List lista = this.conversacionDetalleDAO.obtenerUltimas3Conversacion(usuario, carpeta, identificador_antiguo);
        Collections.reverse(lista);
        return lista;
    }

    public void guardarActividad(String pregunta, String respuesta, String nombre_documento, String division, String identificador) {
        if (this.conversacionDAO.existsByIdentificador(identificador)) {
            Documento documento = this.documentoDAO.buscarPorNombre(nombre_documento);
            Carpeta carpeta = documento != null ? (Carpeta)this.carpetaDAO.findById((Object)documento.getCarpeta().getId_carpeta()).get() : this.carpetaDAO.findByNombre(division);
            Actividad actividad = new Actividad();
            actividad.setTexto_pregunta(pregunta);
            actividad.setTexto_respuesta(respuesta);
            actividad.setFecha(UtilLhia.fechaEcuador());
            actividad.setCarpetas(carpeta);
            actividad.setId_conversacion((Conversacion)this.conversacionDAO.findByIdentificador(identificador).get());
            this.actividadDAO.save((Object)actividad);
        }
    }

    public Conversacion obtenerUltimaConversacion(String usuario) {
        if (!this.conversacionDAO.obtenerUltimaConversacion(usuario).isEmpty()) {
            return (Conversacion)this.conversacionDAO.obtenerUltimaConversacion(usuario).get(0);
        }
        return null;
    }

    public Conversacion obtenerUltimaConversacionCliente(String usuario, String nombre_carpeta) {
        if (!this.conversacionDAO.obtenerUltimaConversacionCliente(usuario, nombre_carpeta).isEmpty()) {
            return (Conversacion)this.conversacionDAO.obtenerUltimaConversacionCliente(usuario, nombre_carpeta).get(0);
        }
        return null;
    }
}

