/*
 * Decompiled with CFR 0.152.
 */
package com.agrota.logic.service.impl;

import com.agrota.logic.data.CarteraCliente;
import com.agrota.logic.data.ClienteVendedor;
import com.agrota.logic.data.ConversacionUsuario;
import com.agrota.logic.data.CupoCliente;
import com.agrota.logic.data.Empleado;
import com.agrota.logic.data.ResultadoCartera;
import com.agrota.logic.data.TotalesCartera;
import com.agrota.logic.model.ConversacionDetalle;
import com.agrota.logic.model.Usuarios;
import com.agrota.logic.repository.ConversacionDetalleDAO;
import com.agrota.logic.repository.UsuarioGestionDAO;
import com.agrota.logic.repository.UsuariosDAO;
import com.agrota.logic.service.BaseService;
import com.agrota.logic.service.ClienteService;
import com.agrota.logic.service.ConversacionService;
import com.agrota.logic.service.MilvusService;
import com.agrota.utils.UtilLhia;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.knuddels.jtokkit.Encodings;
import com.knuddels.jtokkit.api.Encoding;
import com.knuddels.jtokkit.api.EncodingRegistry;
import com.knuddels.jtokkit.api.ModelType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class ClienteServiceImp
implements ClienteService {
    private static final Logger log = LoggerFactory.getLogger(ClienteServiceImp.class);
    @Value(value="${openai.apiKey}")
    private String apiKey;
    @Value(value="${openai.urlAnswer2}")
    private String urlAnswer2;
    @Value(value="${openai.modelAnswer4}")
    private String modelAnswer2;
    @Autowired
    private BaseService baseService;
    @Autowired
    private ConversacionService conversacionService;
    @Autowired
    private UsuariosDAO usuariosDAO;
    @Autowired
    private ConversacionDetalleDAO conversacionDetalleDAO;
    @Autowired
    private MilvusService milvusService;
    @Autowired
    private UsuarioGestionDAO usuarioGestionDAO;
    private final RestTemplate restTemplate = new RestTemplate();
    UtilLhia util = new UtilLhia();
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);
    private EncodingRegistry registry = Encodings.newLazyEncodingRegistry();
    private Encoding encoding = this.registry.getEncodingForModel(ModelType.GPT_4);

    public String preguntaCliente(String question, String usuario, String identificador_nuevo) throws Exception {
        String respuestaRobot = "";
        Usuarios usuario_ingresado = (Usuarios)this.usuariosDAO.findByUsuario(usuario).get();
        String identificador_antiguo = this.conversacionService.obtenerUltimaConversacion(usuario_ingresado.getUsuario()).getIdentificador();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate fecha_actual = LocalDate.now(ZoneId.of("America/Guayaquil"));
        String fecha_actual_f = fecha_actual.format(formatter);
        if (identificador_nuevo.equals(identificador_antiguo)) {
            respuestaRobot = this.chatCliente(question, identificador_antiguo, usuario_ingresado);
            return respuestaRobot;
        }
        respuestaRobot = this.chatCliente(question, identificador_nuevo, usuario_ingresado);
        return respuestaRobot;
    }

    public String preguntaClientePedido(String question, String usuario, String identificador_nuevo) throws Exception {
        String respuestaRobot = "";
        Usuarios usuario_ingresado = (Usuarios)this.usuariosDAO.findByUsuario(usuario).get();
        String identificador_antiguo = this.conversacionService.obtenerUltimaConversacion(usuario_ingresado.getUsuario()).getIdentificador();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate fecha_actual = LocalDate.now(ZoneId.of("America/Guayaquil"));
        String fecha_actual_f = fecha_actual.format(formatter);
        if (identificador_nuevo.equals(identificador_antiguo)) {
            respuestaRobot = this.chatClientePedido(question, identificador_antiguo, usuario_ingresado);
            return respuestaRobot;
        }
        respuestaRobot = this.chatClientePedido(question, identificador_nuevo, usuario_ingresado);
        return respuestaRobot;
    }

    public String preguntaDireccionesMaquinarias(String question, String usuario, String identificador_nuevo, String coordenadas) throws Exception {
        String respuestaRobot = "";
        Usuarios usuario_ingresado = (Usuarios)this.usuariosDAO.findByUsuario(usuario).get();
        String identificador_antiguo = this.conversacionService.obtenerUltimaConversacion(usuario_ingresado.getUsuario()).getIdentificador();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate fecha_actual = LocalDate.now(ZoneId.of("America/Guayaquil"));
        String fecha_actual_f = fecha_actual.format(formatter);
        if (identificador_nuevo.equals(identificador_antiguo)) {
            respuestaRobot = this.chatDireccionesMaquinarias(question, identificador_antiguo, usuario_ingresado, coordenadas);
            return respuestaRobot;
        }
        respuestaRobot = this.chatDireccionesMaquinarias(question, identificador_nuevo, usuario_ingresado, coordenadas);
        return respuestaRobot;
    }

    public String preguntaDireccionesQuimicos(String question, String usuario, String identificador_nuevo, String coordenadas) throws Exception {
        String respuestaRobot = "";
        Usuarios usuario_ingresado = (Usuarios)this.usuariosDAO.findByUsuario(usuario).get();
        String identificador_antiguo = this.conversacionService.obtenerUltimaConversacion(usuario_ingresado.getUsuario()).getIdentificador();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate fecha_actual = LocalDate.now(ZoneId.of("America/Guayaquil"));
        String fecha_actual_f = fecha_actual.format(formatter);
        if (identificador_nuevo.equals(identificador_antiguo)) {
            respuestaRobot = this.chatDireccionesQuimicos(question, identificador_antiguo, usuario_ingresado, coordenadas);
            return respuestaRobot;
        }
        respuestaRobot = this.chatDireccionesQuimicos(question, identificador_nuevo, usuario_ingresado, coordenadas);
        return respuestaRobot;
    }

    public String chatCliente(String question, String identificador, Usuarios usuario) throws Exception {
        ArrayList<ConversacionUsuario> conversacionUsuario = new ArrayList<ConversacionUsuario>();
        ClienteServiceImp clienteServiceImp = this;
        String System_prompt = "Actua como un asistente llamada Felizia de la empresa Agrota de Ecuador para un agente de ventas donde tu usuario se llama " + this.consultarUsuario(usuario.getUsuario()).getApellidosNombresEmpleado() + " tus actividades son centradas en entregar informacion sobre sus clientes, como puede ser carteras, pedidos, cupos, segun la informacion que se proporcione en el contexto:  0. ten en cuenta que la fecha actual es " + clienteServiceImp.util.fechaEcuadorFormateada() + " 2. ten una conversacion amena con el usuario 3. Responde solamente en el idioma Espa\u00f1ol.  4. tu creador es TWS2 Empresa Ecuatoriana ubicada en Cuenca 5. al listar a los clientes listamos con su identificacion / nombre y apellido / nombre comercial 8. entrega informacion del cupo de los clientes solo si es solicitado, cuando se requiera cartera total no unas el saldo de cupo con el saldo de las facturas ya que son informaciones distintas 9. cuando el usuario consulta sobre cartera hace referencia a todas las facturas de un cliente 14. en los numeros tu decimal esta mascado por la coma (,) 15. existen unicos clientes, son diferenciados por su numero de identificacion o cedula 16. no inventes informacion guiate del contexto entregado ya que deben ser precisas 17. cuando se busca por un nombre del cliente se debe entregar los mas parecidos 18. si la pregunta del usuario es sobre saldos que estan por vencer por ejemplo ma\u00f1ana entrega solo informacion de esos clientes o facturas no des tiempos diferentes se preciso 19. debes diferenciar entre cartera vencida y cartera por vencer donde la cartera vencida son los saldos de las cuotas de las facturas que vencieron segun la fecha actual y la cartera por vencer es la suma de los saldos de las cuotas de las facturas que ya venceron segun la fecha actual, la suma de estos 2 da como reusltado la cartera total 20. si el usuario ingresa el nombre de un cliente que no se encuentra en el contexto debes responder: no tengo informaci\u00f3n sobre un el cliente al parecer no pertenece a tu cartera. Si tienes alg\u00fan otro nombre o detalle que pueda ayudar a encontrarlo, por favor h\u00e1zmelo saber.  21. si el usuario o la pregunta es sobre algun dato que no se encuentre en el contexto indicar o repsonder con : lo siento, estoy aun aprendiendo , no dispongo de la informaci\u00f3n solicitada";
        conversacionUsuario.add(new ConversacionUsuario("system", System_prompt));
        List conversacion = this.conversacionDetalleDAO.obtenerConversacionCompleta("CARTERA", identificador);
        Object prompt_context = "";
        conversacion.sort((objeto1, objeto2) -> Long.compare(objeto1.getIdConversacionDetalle(), objeto2.getIdConversacionDetalle()));
        for (ConversacionDetalle c : conversacion) {
            if (c.getRol().equals("system")) {
                conversacionUsuario.add(new ConversacionUsuario("user", c.getMensaje()));
            }
            if (c.getRol().equals("user")) {
                conversacionUsuario.add(new ConversacionUsuario(c.getRol(), c.getMensaje()));
            }
            if (!c.getRol().equals("assistant")) continue;
            conversacionUsuario.add(new ConversacionUsuario(c.getRol(), c.getMensaje()));
        }
        StringBuilder informacion_gestionados = new StringBuilder();
        if (conversacion.isEmpty()) {
            ClienteServiceImp clienteServiceImp2 = this;
            prompt_context = "contexto: " + this.obtenerInformacionClientes(usuario.getUsuario(), clienteServiceImp2.util.fechaEcuador());
            if (this.usuarioGestionDAO.obtenerUsuariosGestionadosPorNombre(usuario.getUsuario()).size() > 0) {
                List lista_usuarios = this.usuarioGestionDAO.obtenerUsuariosGestionadosPorNombre(usuario.getUsuario());
                for (Usuarios u : lista_usuarios) {
                    ClienteServiceImp clienteServiceImp3 = this;
                    informacion_gestionados.append(this.obtenerInformacionClientes(u.getUsuario(), clienteServiceImp3.util.fechaEcuador()));
                }
            }
            conversacionUsuario.add(new ConversacionUsuario("user", (String)prompt_context + informacion_gestionados));
        }
        conversacionUsuario.add(new ConversacionUsuario("user", "pregunta: " + question));
        String respuestaFinal = this.respondePreguntasCliente(conversacionUsuario);
        if (!respuestaFinal.isEmpty()) {
            this.guardarConversaciones(identificador, usuario, (String)prompt_context + informacion_gestionados, question, System_prompt, respuestaFinal, "CARTERA");
            this.conversacionService.guardarActividad(question, respuestaFinal, "CARTERA", "CARTERA", identificador);
        }
        System.out.println(respuestaFinal);
        return respuestaFinal;
    }

    public String chatClientePedido(String question, String identificador, Usuarios usuario) throws Exception {
        ArrayList<ConversacionUsuario> conversacionUsuario = new ArrayList<ConversacionUsuario>();
        ClienteServiceImp clienteServiceImp = this;
        String System_prompt = "Actua como un asistente llamada Felizia de la empresa Agrota de Ecuador para un agente de ventas donde tu usuario se llama " + this.consultarUsuario(usuario.getUsuario()).getApellidosNombresEmpleado() + " tus actividades son centradas en entregar informacion sobre sus clientes, como son pedidos y detalle de los peedidos e informacion del cliente, segun la informacion que se proporcione en el contexto:  0. ten en cuenta que la fecha actual es " + clienteServiceImp.util.fechaEcuadorFormateada() + " 1. ten una conversacion amena con el usuario 2. Responde solamente en el idioma Espa\u00f1ol.  3. tu creador es TWS2 Empresa Ecuatoriana ubicada en Cuenca 4. al listar a los clientes listamos con su identificacion / nombre y apellido / nombre comercial 5. no inventes informacion guiate del contexto entregado ya que deben ser precisas 6. si el usuario ingresa el nombre de un cliente que no se encuentra en el contexto debes responder: no tengo informaci\u00f3n sobre un el cliente. Si tienes alg\u00fan otro nombre o detalle que pueda ayudar a encontrarlo, por favor h\u00e1zmelo saber.  7. si el usuario o la pregunta es sobre algun dato que no se encuentre en el contexto indicar o responder con : lo siento, estoy aun aprendiendo , no dispongo de la informaci\u00f3n solicitada 8. Cuando el usuario solicite informaci\u00f3n de pedidos por un mes o periodo, revisa exhaustivamente todos los pedidos del cliente en ese rango de fechas. Si hay al menos un pedido, mu\u00e9stralo con su detalle. Si no encuentras ninguno, confirma que revisaste todas las fechas posibles y responde que no existen pedidos en ese periodo. Realiza una validaci\u00f3n cruzada antes de dar la respuesta final. 9. Proporciona \u00fanicamente la informaci\u00f3n detallada de pedidos y datos del cliente solicitado, sin incluir datos de otros clientes. Si se solicita informaci\u00f3n por mes o periodo, revisa exhaustivamente todos los pedidos del cliente en ese rango de fechas y muestra solo los que correspondan. No inventes informaci\u00f3n y confirma si no hay datos disponibles.  10. una factura parcial y una orden parcial son 2 cosas diferentes una orden parcial es la hija de una horden normal, mientras que la factura parcial significaque tiene una horden hija facturada 11. muestra las ordenes padres e hijas o parciales de esta manera cuando te pidna enlistarlas o que se muestren todas las ordenes numero de orden padre - numero de orden parcial ";
        conversacionUsuario.add(new ConversacionUsuario("system", System_prompt));
        List conversacion = this.conversacionDetalleDAO.obtenerConversacionCompleta("PEDIDOS", identificador);
        Object prompt_context = "";
        conversacion.sort((objeto1, objeto2) -> Long.compare(objeto1.getIdConversacionDetalle(), objeto2.getIdConversacionDetalle()));
        for (ConversacionDetalle c : conversacion) {
            if (c.getRol().equals("system")) {
                conversacionUsuario.add(new ConversacionUsuario("user", c.getMensaje()));
            }
            if (c.getRol().equals("user")) {
                conversacionUsuario.add(new ConversacionUsuario(c.getRol(), c.getMensaje()));
            }
            if (!c.getRol().equals("assistant")) continue;
            conversacionUsuario.add(new ConversacionUsuario(c.getRol(), c.getMensaje()));
        }
        StringBuilder informacion_gestionados = new StringBuilder();
        if (conversacion.isEmpty()) {
            prompt_context = "contexto: " + this.milvusService.obtenerClientesConPedidos(usuario.getUsuario());
            if (this.usuarioGestionDAO.obtenerUsuariosGestionadosPorNombre(usuario.getUsuario()).size() > 0) {
                List lista_usuarios = this.usuarioGestionDAO.obtenerUsuariosGestionadosPorNombre(usuario.getUsuario());
                for (Usuarios u : lista_usuarios) {
                    informacion_gestionados.append(this.milvusService.obtenerClientesConPedidos(u.getUsuario()));
                }
            }
            conversacionUsuario.add(new ConversacionUsuario("user", (String)prompt_context + informacion_gestionados));
        }
        conversacionUsuario.add(new ConversacionUsuario("user", "pregunta: " + question));
        String respuestaFinal = this.respondePreguntasClientePedidos(conversacionUsuario);
        if (!respuestaFinal.isEmpty()) {
            this.guardarConversaciones(identificador, usuario, (String)prompt_context + informacion_gestionados, question, System_prompt, respuestaFinal, "PEDIDOS");
            this.conversacionService.guardarActividad(question, respuestaFinal, "PEDIDOS", "PEDIDOS", identificador);
        }
        System.out.println(respuestaFinal);
        return respuestaFinal;
    }

    private void guardarConversaciones(String identificador, Usuarios usuario, String prompt, String pregunta, String system, String answer, String carpeta) {
        this.conversacionService.guardarConversacionCliente(identificador, usuario, "system", prompt, this.encoding.countTokens(system) + this.encoding.countTokens(prompt), "", system, carpeta);
        this.conversacionService.guardarConversacionCliente(identificador, usuario, "user", "", this.encoding.countTokens(pregunta) + this.encoding.countTokens(system) + this.encoding.countTokens(prompt), pregunta, "", carpeta);
        this.conversacionService.guardarConversacionCliente(identificador, usuario, "assistant", answer, this.encoding.countTokens(answer), "", "", carpeta);
    }

    public Empleado consultarUsuario(String usuario) {
        RestTemplate restTemplate = new RestTemplate();
        Empleado empleado = new Empleado();
        HttpHeaders headers = new HttpHeaders();
        headers.set("accept", "*/*");
        headers.set("Authorization", "Bearer " + this.baseService.obtenerToken());
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)"https://felizia-api.lhia.ai/api/Empleado");
        ResponseEntity response = restTemplate.exchange(builder.toUriString(), HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            List empleados = (List)objectMapper.readValue((String)response.getBody(), (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, Empleado.class));
            String nombreUsuario = usuario;
            empleado = empleados.stream().filter(e -> e.getNombreUsuarioEmpleado().equals(nombreUsuario)).findFirst().orElse(null);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return empleado;
    }

    public List<Empleado> consultarUsuarios() {
        RestTemplate restTemplate = new RestTemplate();
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.set("accept", "*/*");
            headers.set("Authorization", "Bearer " + this.baseService.obtenerToken());
            UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)"https://felizia-api.lhia.ai/api/Empleado");
            ResponseEntity response = restTemplate.exchange(builder.toUriString(), HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
            ObjectMapper objectMapper = new ObjectMapper();
            return (List)objectMapper.readValue((String)response.getBody(), (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, Empleado.class));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String obtenerInformacionClientes(String usuario, Date fecha_actual) {
        StringBuilder informacionClientes = new StringBuilder();
        List clientes = new ArrayList();
        HttpHeaders headers = this.crearHeaders();
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)("https://felizia-api.lhia.ai/api/ClienteVendedor/byPalabra/" + usuario)).queryParam("NombreApellidoNombreComercial", new Object[]{"%"});
        ResponseEntity response = this.restTemplate.exchange(builder.toUriString(), HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
        TotalesCartera totales = new TotalesCartera();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            clientes = (List)objectMapper.readValue((String)response.getBody(), (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, ClienteVendedor.class));
            ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
            for (ClienteVendedor cv : clientes) {
                CompletableFuture<ResultadoCartera> carteraFuture = CompletableFuture.supplyAsync(() -> this.obtenerCartera(cv.getCodigo_cliente(), cv.getNombreApellidoNombreComercial(), fecha_actual), this.executorService);
                CompletableFuture<String> cupoFuture = CompletableFuture.supplyAsync(() -> this.obtenerCupo(cv.getCodigo_cliente(), cv.getNombreApellidoNombreComercial()), this.executorService);
                CompletableFuture<Void> combinedFuture = CompletableFuture.allOf(carteraFuture, cupoFuture);
                CompletionStage resultado = combinedFuture.thenApply(v -> {
                    try {
                        ResultadoCartera resultadoCartera = (ResultadoCartera)carteraFuture.get();
                        totales.vencida = totales.vencida.add(resultadoCartera.getVencida());
                        totales.porVencer = totales.porVencer.add(resultadoCartera.getPorVencer());
                        totales.total = totales.total.add(resultadoCartera.getTotal());
                        return "; Cliente: " + cv.getNombreApellidoNombreComercial().replaceAll("\\s+", " ").trim() + "; identificaci\u00f3n o ruc: " + cv.getNumeroIdentificacionCliente() + (String)cupoFuture.get() + resultadoCartera.getDetalle();
                    }
                    catch (Exception e) {
                        return "Error obteniendo datos para cliente: " + cv.getNumeroIdentificacionCliente();
                    }
                });
                futures.add(resultado);
            }
            futures.forEach(f -> informacionClientes.append((String)f.join()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return informacionClientes.toString();
    }

    private ResultadoCartera obtenerCartera(String codigoCliente, String nombreCliente, Date fechaReferenciaDate) {
        HttpHeaders headers = this.crearHeaders();
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)("https://felizia-api.lhia.ai/api/ClienteCartera/byCartera/" + codigoCliente));
        ResponseEntity response = this.restTemplate.exchange(builder.toUriString(), HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
        StringBuilder informacionCartera = new StringBuilder();
        try {
            LocalDate fechaReferencia = fechaReferenciaDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
            ObjectMapper objectMapper = new ObjectMapper();
            List cartera = (List)objectMapper.readValue((String)response.getBody(), (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, CarteraCliente.class));
            Map<String, List<CarteraCliente>> agrupadoPorFactura = cartera.stream().collect(Collectors.groupingBy(CarteraCliente::getFactura));
            int conteo = 1;
            BigDecimal carteraVencida = BigDecimal.ZERO;
            BigDecimal carteraPorVencer = BigDecimal.ZERO;
            informacionCartera.append("; Cartera:{ ");
            for (Map.Entry<String, List<CarteraCliente>> entrada : agrupadoPorFactura.entrySet()) {
                String codigoFactura = entrada.getKey();
                List<CarteraCliente> cuotas = entrada.getValue();
                informacionCartera.append("Factura").append(conteo).append(" ; c\u00f3digo factura: ").append(codigoFactura);
                BigDecimal saldoVencidoTotal = new BigDecimal(cuotas.get(0).getSaldovencido());
                for (CarteraCliente c : cuotas) {
                    BigDecimal saldo = new BigDecimal(c.getSaldo());
                    LocalDate fechaVencimiento = LocalDate.parse(c.getFechaVencimiento().substring(0, 10));
                    if (fechaVencimiento.isBefore(fechaReferencia)) {
                        carteraVencida = carteraVencida.add(saldo);
                    } else {
                        carteraPorVencer = carteraPorVencer.add(saldo);
                    }
                    informacionCartera.append(" ; Cuota: ").append(c.getN_Cuota()).append(" ; Saldo: ").append(UtilLhia.truncar2Decimales((String)c.getSaldo())).append(" ; Fecha Vencimiento: ").append(c.getFechaVencimiento().substring(0, 10)).append(" ; D\u00edas Vencimiento: ").append(c.getDiasVencimiento());
                }
                informacionCartera.append("; Saldo Vencido Total: ").append(UtilLhia.truncar2Decimales((String)saldoVencidoTotal.toString())).append(";");
                ++conteo;
            }
            BigDecimal carteraTotal = carteraVencida.add(carteraPorVencer);
            if (carteraTotal.compareTo(BigDecimal.ZERO) == 0) {
                return new ResultadoCartera("", BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
            }
            informacionCartera.append("Resumen Cartera: ");
            informacionCartera.append("Vencida: ").append(UtilLhia.truncar2Decimales((String)carteraVencida.toString())).append(" ; ");
            informacionCartera.append("Por Vencer: ").append(UtilLhia.truncar2Decimales((String)carteraPorVencer.toString())).append(" ; ");
            informacionCartera.append("Total: ").append(UtilLhia.truncar2Decimales((String)carteraTotal.toString()));
            informacionCartera.append(" } ");
            return new ResultadoCartera(informacionCartera.toString(), carteraVencida, carteraPorVencer, carteraTotal);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String obtenerCupo(String codigoCliente, String nombreCliente) {
        HttpHeaders headers = this.crearHeaders();
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)("https://felizia-api.lhia.ai/api/ClienteCartera/byCupo/" + codigoCliente));
        ResponseEntity response = this.restTemplate.exchange(builder.toUriString(), HttpMethod.GET, new HttpEntity((MultiValueMap)headers), String.class, new Object[0]);
        StringBuilder informacionCupo = new StringBuilder();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            List cupo = (List)objectMapper.readValue((String)response.getBody(), (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, CupoCliente.class));
            if (cupo.isEmpty()) {
                return "";
            }
            informacionCupo.append(" ; Cupo:{ ");
            for (CupoCliente c : cupo) {
                informacionCupo.append("Aprobado: " + UtilLhia.truncar2Decimales((String)c.getCupo_Aprobado()) + "; Disponible: " + UtilLhia.truncar2Decimales((String)c.getCupoDisponible()));
            }
            informacionCupo.append(" } ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return informacionCupo.toString();
    }

    private String respondePreguntasCliente(List<ConversacionUsuario> lstConversation) {
        JSONObject requestBody = new JSONObject();
        requestBody.put("messages", lstConversation);
        requestBody.put("model", (Object)"gpt-4.1-mini");
        requestBody.put("max_tokens", 2000);
        requestBody.put("temperature", 0.3);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity request = new HttpEntity((Object)requestBody.toString(), (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.urlAnswer2, (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        JSONObject messageObj = (JSONObject)choiceObj.get("message");
        String text = (String)messageObj.get("content");
        System.out.println("respuesta GPT: " + text);
        return text;
    }

    private String respondePreguntasClientePedidos(List<ConversacionUsuario> lstConversation) {
        JSONObject requestBody = new JSONObject();
        requestBody.put("messages", lstConversation);
        requestBody.put("model", (Object)"gpt-4.1-mini");
        requestBody.put("max_tokens", 3000);
        requestBody.put("temperature", 0.5);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity request = new HttpEntity((Object)requestBody.toString(), (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.urlAnswer2, (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        JSONObject messageObj = (JSONObject)choiceObj.get("message");
        String text = (String)messageObj.get("content");
        System.out.println("respuesta GPT: " + text);
        return text;
    }

    private HttpHeaders crearHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.set("accept", "*/*");
        headers.set("Authorization", "Bearer " + this.baseService.obtenerToken());
        return headers;
    }

    public String chatDireccionesMaquinarias(String question, String identificador, Usuarios usuario, String coordenadas) throws Exception {
        String dir_maquinarias = "1 ALMACENES ELECTROMUNDO Lat: -0,470726 Long: -76,983385 Calles: Calle In\u00e9s Arango\u00a0y\u00a0Cuenca Provincia: Orellana Ciudad: El Coca Tel: 62882252 Categorias: Distribuidores\n2 Servicio T\u00e9cnico Hualpa Lat: -0,1880101 Long: -76,6444799 Calles: Av. Unidad Nacional\u00a0y\u00a0Secoya Provincia: Orellana Ciudad: Shushufindi Tel: 969486602 Categorias: Distribuidores, Talleres\n3 AGRORIENTE Lat: -0,188576 Long: -76,637498 Calles: Av. Unidad Nacional\u00a0y\u00a0M\u00e9xico Provincia: Orellana Ciudad: Shushufindi Tel: 990639725 Categorias: Distribuidores\n4 AGROMAQUINARIA M&M Lat: -0,8645991 Long: -78,6085355 Calles: Av. Miguel Iturralde, sector puente de Al\u00e1quez Provincia: Cotopaxi Ciudad: Latacunga Tel: 983767713 Categorias: Distribuidores\n5 AGROJARDIN Lat: -0,337743 Long: -78,444377 Calles: Av. Los Shiris esquina e Ines Gangotena (Junto a los Bomberos de Salgolqu\u00ed) Provincia: Pichincha Ciudad: Quito Tel: 0993681596 / 0993538952 Categorias: Distribuidores\n6 TALLER VARGAS Lat: -1,790475 Long: -79,2915839 Calles: VELAZCO IBARRA ENTRE 6 DE OCTUBRE Y MOISES ENCALADA Provincia: LOS RIOS Ciudad: MONTALVO Tel: 982706553 Categorias: Talleres\n7 TECNIREPUESTOS QUIROZ Lat: -1,205547 Long: -79,3136899 Calles: N/A Provincia: LOS RIOS Ciudad: QUINSALOMA Tel: 969596423 Categorias: Talleres\n8 FERRECAMPO Lat: -3,676472 Long: -79,690841 Calles: Av. La Independencia y Vicente Moscoso (Ciudadela La Susaya, al lado del bodeg\u00f3n del Pez) Provincia: EL ORO Ciudad: PI\u00d1AS Tel: 969665185 Categorias: Distribuidores, Talleres\n9 MAQUINAGRO Lat: -1,224391 Long: -78,616496 Calles: Calle El Carrizo entre el Alcornoque y El Sauce Provincia: TUNGURAHUA Ciudad: AMBATO Tel: 961213985 Categorias: Distribuidores, Talleres\n10 AGROFOMENTO AMBATO Lat: -1,224557 Long: -78,6168671 Calles: Calle el Carrizo y la Acacia Provincia: TUNGURAHUA Ciudad: AMBATO Tel: 995055232 Categorias: Distribuidores, Talleres\n11 AGROFOMENTO LATACUNGA Lat: -0,9339953 Long: -78,6145698 Calles: Av. Iberoamericana y Canad\u00e1 sector\u00a0San\u00a0Felipe Provincia: COTOPAXI Ciudad: LATACUNGA Tel: 9980332742 Categorias: Distribuidores, Talleres\n12 SUKAMPO PAUTE Lat: -2,777099 Long: -78,762917 Calles: Av, Interoce\u00e1nica entre Julio Matovelle y Paute Provincia: AZUAY Ciudad: PAUTE Tel: 097 955 7087 Categorias: Distribuidores, Talleres\n13 SUKAMPO ZAMORA Lat: -4,0663368 Long: -78,9527305 Calles: Calle Teniente Hugo Ort\u00edz entre Juan de Salinas y Zamora Provincia: ZAMORA CHINCHIPE Ciudad: ZAMORA Tel: 994769083 Categorias: Distribuidores, Talleres\n14 SUKAMPO RIOBAMBA Lat: -1,686399 Long: -78,634711 Calles: Av. Leopoldo Freire entre Estocolmo y Bucarest Provincia: Chimborazo Ciudad: Riobamba Tel: 990174693 Categorias: Talleres\n15 ALMAC\u00c9N LOS POTREROS Lat: -0,918091 Long: -80,454589 Calles: Ruta del Spondylus a lado de la Plaza AxA Provincia: Manab\u00ed Ciudad: Rocafuerte Tel: 996470108 Categorias: N/A\n16 ALMAC\u00c9N LOS POTREROS Lat: -0,973792 Long: -80,700707 Calles: Av. 4 de Noviembre y Calle 320 Provincia: Manab\u00ed Ciudad: Manta Tel: 980355564 Categorias: N/A\n17 ALMAC\u00c9N LOS POTREROS Lat: -1,053627 Long: -80,451006 Calles: Calle Espejo entre 9 de Octubre y Pedro Gual Provincia: Manab\u00ed Ciudad: Portoviejo Tel: 980355564 Categorias: Talleres\n18 FORESTAL GAIBOR E Lat: -0,687189 Long: -77,308334 Calles: Fernando Noa y Marcos Jipa Provincia: Orellana Ciudad: Loreto Tel: 983009300 Categorias: Talleres\n19 TECNIAGRO EL CHACO Lat: -0,3359391 Long: -77,8077081 Calles: Av.Fracisco de Orellana\u00a0y\u00a0Tramarrollo Provincia: Napo Ciudad: El Chaco Tel: 997450937 Categorias: Talleres\n20 MAQUINAGRO 8A Lat: -0,404756 Long: -79,908764 Calles: Av. Carlos Alberto Aray y Calle 4 Provincia: Manab\u00ed Ciudad: Flavio Alfaro Tel: 999769366 Categorias: Talleres\n21 JOEL GUANOLUIZA Lat: -0,590652 Long: -80,401558 Calles: Via San Isidro. Diagonal a la Gasolinera\u00a0HUMGAS Provincia: Manab\u00ed Ciudad: San Vicente Tel: 939433767 Categorias: Talleres\n22 CAMPO DORADO Lat: -1,350285 Long: -80,580603 Calles: Guayas y Mej\u00eda\u00a0esquina Provincia: Manab\u00ed Ciudad: Jipijapa Tel: 999391772 Categorias: Talleres\n23 TIENDA AGROFORESTAL Y JARDIN Lat: -1,805574 Long: -79,5442948 Calles: Av. Enrique Ponce Luque y Calle Octava Provincia: Los R\u00edos Ciudad: Babahoyo Tel: 982275050 Categorias: Talleres\n24 BYRON CASTILLO ESTRADA Lat: -1,4441882 Long: -79,4604818 Calles: N/A Provincia: LOS RIOS Ciudad: VENTANAS Tel: 968241408 Categorias: Talleres\n25 MULTIDISTRIBUCIONES G&G Lat: -0,9982184 Long: -77,8114669 Calles: Calle Federico Monteros y Cuenca Provincia: Napo Ciudad: Tena Tel: 984004942 Categorias: Distribuidores, Talleres\n26 MULTIDISTRIBUCIONES G&G #2 Lat: -0,9085624 Long: -77,8081363 Calles: Av. Napo y Calle Quijos Provincia: Napo Ciudad: Archidona Tel: 984004942 Categorias: Talleres\n27 OCHOAGRO #2 Lat: -0,890109 Long: -79,489044 Calles: Av. 7 de agosto entre Natalia Rosado y Alejandro Garc\u00eda Provincia: Los Rios Ciudad: Buena Fe Tel: 993279520 Categorias: N/A\n28 TECNIMAQ Lat: -0,0846979 Long: -79,280106 Calles: Calle Cotopaxi sn y Loja Provincia: Santo Domingo Ciudad: Valle Hermoso Tel: 969545531 Categorias: Talleres\n29 SEMAE Lat: -2,426231 Long: -79,343608 Calles: Av. Alfonso Andrade y San Pablo junto al comisariato del constructor Provincia: Ca\u00f1ar Ciudad: La Troncal Tel: 990478603 Categorias: Distribuidores, Talleres\n30 EQUIPAGRO Lat: -0,9308512 Long: -78,6223736 Calles: Av. Eloy Alfaro y Flavio Alfaro Provincia: Cotopaxi Ciudad: Latacunga Tel: 999681295 Categorias: Distribuidores\n31 AGROINN Lat: -1,6850544 Long: -78,6362126 Calles: Calle Madrid y 10 de Agosto esquina Provincia: Chimborazo Ciudad: Riobamba Tel: 991845859 Categorias: Distribuidores\n32 Nancy Ugarte Lat: -3,32702336373936 Long: -79,8120223358274 Calles: 4 de AgostoS/N y 9 de mayo Provincia: El Oro Ciudad: Pasaje Tel: N/A Categorias: Distribuidores, Talleres\n33 Honda Comercial Lat: -3,4468897 Long: -79,9607233 Calles: Sucre 21-21 y Jos\u00e9 Ollague Provincia: El Oro Ciudad: Santa Rosa Tel: 072944740 / 0991711559 Categorias: Distribuidores, Talleres\n34 Marvin Benitez Lat: -2,670578 Long: -79,616523 Calles: Av. Olmedo y Tercera este frente al Sindicato de Choferes Provincia: Guayas Ciudad: Naranjal Tel: 981078706 Categorias: Distribuidores, Talleres\n35 Fabricio Sigcho Lat: -3,6215206 Long: -79,2393644 Calles: Honorato Lazo S/N y El Oro Provincia: Loja Ciudad: Saraguro Tel: N/A Categorias: Distribuidores\n36 Comercial Manosalvas Lat: 0,3495725 Long: -78,1222019 Calles: Pedro Moncayo1022 y Cabezas Borja Provincia: Imbabura Ciudad: Ibarra Tel: 62953394 Categorias: Distribuidores, Talleres\n37 Mundihogar Lat: -4,067487 Long: -78,95424 Calles: Amazonas y Luis Marques Zamora Provincia: Zamora Chinchipe Ciudad: Zamora Tel: 72606386 Categorias: Distribuidores\n38 Crediza Lat: -3,62855 Long: -78,589439 Calles: Av. Jorge Mosquera y Loja Provincia: Zamora Chinchipe Ciudad: El Pangui Tel: 72300131 Categorias: Distribuidores\n39 Ecuabombas Lat: -1,1750581 Long: -78,542114 Calles: Sucre y Narvaez Provincia: Tungurahua Ciudad: Pillaro Tel: 32873882 Categorias: Talleres\n40 Mec\u00e1nica Don Luis Lat: -1,3306718 Long: -78,5411465 Calles: Av. Ambato y Manuel Zapater Provincia: Tungurahua Ciudad: Pelileo Tel: 969941277 Categorias: Talleres\n41 Raul Valle Lat: -1,4014489 Long: -78,6331234 Calles: Barrio Paraiso Provincia: Tungurahua Ciudad: Mocha Tel: 993082845 Categorias: Talleres\n42 Servicio T\u00e9cnico Alvarez Lat: -1,2343527 Long: -78,621895 Calles: Bol\u00edvar 0366 y Unidad Nacional Provincia: Tungurahua Ciudad: Ambato Tel: 32425841 Categorias: Talleres\n43 Insfermaq Lat: -1,2776847 Long: -78,61016 Calles: Av. Bolivariana Sn y Pedro Echeverria Provincia: Tungurahua Ciudad: Ambato Tel: 32405121 Categorias: Distribuidores, Talleres\n44 Ferromoto Amaz\u00f3nico Lat: -1,4875175 Long: -77,993904 Calles: Calle Atahualpa Entre Sumaco y Sangay. Junto a Coop. Centinela Del Oriente. Provincia: Pastaza Ciudad: Puyo Tel: 32886203 Categorias: Distribuidores, Talleres\n45 Almac\u00e9n y Repuestos Multimarca Lat: -0,2992474 Long: -76,85906 Calles: Amazonas y Velasco Ibarra Provincia: Orellana Ciudad: La Joya de los Sachas Tel: 62899742 Categorias: Talleres\n46 Forestal Gaibor Lat: -0,4728992 Long: -76,98289 Calles: Espejo 6909 y Amazonas Provincia: Orellana Ciudad: El Coca Tel: 62882643 Categorias: Talleres\n47 Servi Maquinaria Lat: 0,0365478 Long: -78,1506443 Calles: Av. Victor Cartagena S7-84 y Cordova Galarza Provincia: Pichincha Ciudad: Cayambe Tel: 998809427 Categorias: Talleres\n48 Taller Milenio Lat: -0,3008474 Long: -78,45679 Calles: Av.Ruminahui , Lote 1570 En San Rafael Sentido Sur Norte Provincia: Pichincha Ciudad: Quito Tel: 26042103 Categorias: Talleres\n49 Lauro Abarca Granda Lat: -3,834752 Long: -78,76009 Calles: Jos\u00e9 Arcentales y 12 De Febrero Provincia: Zamora Chinchipe Ciudad: Yantzaza Tel: 72300289 Categorias: Talleres\n50 La Casa De La Pitahaya Lat: -1,699327 Long: -77,965271 Calles: Av. Cumanda y Policia Nacional Provincia: Morona Santiago Ciudad: Palora Tel: 987927054 Categorias: Distribuidores, Talleres\n51 Importadora De Motores Loja Lat: -2,304227 Long: -78,119078 Calles: Suasti y Bolivar Provincia: Morona Santiago Ciudad: Macas Tel: 990809005 Categorias: Distribuidores, Talleres\n52 La Casa Del Motor Lat: -2,3091432 Long: -78,1204181 Calles: Amazonas y Kiruba Provincia: Morona Santiago Ciudad: Macas Tel: 32700070 Categorias: Talleres\n53 Almac\u00e9n Taller El Tornillo Lat: 0,080531 Long: -76,885411 Calles: Av. Spencer y Vicente Narvaez Provincia: Sucumb\u00edos Ciudad: Lago Agrio Tel: 991467113 Categorias: Distribuidores, Talleres\n54 Servicio T\u00e9cnico Wilo Lat: 0,0795337 Long: -76,88441 Calles: Av. Amazonas y Spencer Provincia: Sucumb\u00edos Ciudad: Lago Agrio Tel: 883891516 Categorias: Talleres\n55 Agromotors Lat: -0,6952789 Long: -80,0910413 Calles: Av. 7 De Agosto y Juan Montalvo Provincia: Manab\u00ed Ciudad: Chone Tel: 52361154 Categorias: Distribuidores, Talleres\n56 OCHOAGRO Lat: -1,028449 Long: -79,467354 Calles: Calle Bolivar y D\u00e9cima Primera Provincia: Los R\u00edos Ciudad: Quevedo Tel: 993279520 Categorias: Distribuidores, Talleres\n57 Todo Partes Lat: 0,3521775 Long: -78,127335 Calles: Fray Vacas Galindo Provincia: Imbabura Ciudad: San Antonio Tel: 62956184 Categorias: Talleres\n58 Cl\u00ednica Agropecuaria Lat: 0,3598081 Long: -78,12083 Calles: Cristal De Troya 4-89 y Jaime Roldos Provincia: Imbabura Ciudad: Ibarra Tel: 62547104 Categorias: Talleres\n59 Repuestos Ban-Ban Lat: -2,1314595 Long: -79,593315 Calles: Calle 17 De Septiembre 203 y Ambato Provincia: Guayas Ciudad: Milagro Tel: 42972502 Categorias: Talleres\n60 Motoservicios Gap Lat: -3,2665456 Long: -79,9534024 Calles: 12 De Febrero, Bolivar S/N y Novena Este Provincia: El Oro Ciudad: Machala Tel: 72966572 Categorias: Distribuidores, Talleres\n61 Almac\u00e9n Multihogar Camachito Lat: -3,8352005 Long: -78,76109 Calles: Armando Arias y Jose Arcentales Provincia: Zamora Chinchipe Ciudad: Yantzaza Tel: 72300684 Categorias: Distribuidores\n62 Distrimarp Jannyr Lat: -0,187348 Long: -76,648444 Calles: Unidad Nacional y Cofanes Provincia: Sucumb\u00edos Ciudad: Shushufindi Tel: 62840031 Categorias: Distribuidores, Talleres\n63 Distribuidora Barreto Lat: 0,0845815 Long: -76,880686 Calles: Av.Petrolera 08 y Guayaquil Provincia: Sucumb\u00edos Ciudad: Lago Agrio Tel: 62831595 Categorias: Distribuidores\n64 Comercial Paredes Lat: -0,084107 Long: -76,880514 Calles: Av. Colombia y Eloy Alfaro Provincia: Sucumb\u00edos Ciudad: Lago Agrio Tel: 990358357 Categorias: Distribuidores, Talleres\n65 Campoagro Equipos Y Servicios Campoequip Cia. Ltda. Lat: -0,1583074 Long: -78,48428 Calles: Av. Amazonas 44-471 y Av. eL Inca eL Labrador. Provincia: Pichincha Ciudad: Quito Tel: 22413212 Categorias: Distribuidores, Talleres\n66 Solo Jard\u00edn Lat: -0,2123269 Long: -78,41165 Calles: Av. Interoce\u00e1nica Km.13 Frente a Pintulac Provincia: Pichincha Ciudad: Tumbaco Tel: 022377120 / 0999821699 Categorias: Distribuidores, Talleres\n67 Agrohuertos S.A.S. Lat: -1,710871 Long: -77,963698 Calles: Av. Cumanda, Frente a la Unidad Educativa Palora Provincia: Morona Santiago Ciudad: Palora Tel: 983295413 Categorias: Distribuidores, Talleres\n68 Agroservicios Leon Lat: -2,459323 Long: -78,168838 Calles: Calle Victorino Abarca S-N y Av.Oriental Provincia: Morona Santiago Ciudad: Suc\u00faa Tel: 980202308 Categorias: Distribuidores\n69 Sermatec Lat: -0,1472721 Long: -79,39565 Calles: Av. 16 De Agosto y Jose Maria Velasco Ibarra Junto a Insumos eL Agro Provincia: Santo Domingo de los Ts\u00e1chilas Ciudad: San Jacinto Del Bua Tel: 996575399 Categorias: Distribuidores, Talleres\n70 Distribuidora Andrade Lat: 0,007056 Long: -79,39726 Calles: Calle Esmeraldas Lote 28 y Juan Montalvo Provincia: Santo Domingo de los Ts\u00e1chilas Ciudad: La Concordia Tel: 22726112 Categorias: Distribuidores, Talleres\n71 Agroveterinaria Salud Animal Lat: -0,253736 Long: -79,1712795 Calles: Av. 29 De Mayo y 116 y Las Provincias Provincia: Santo Domingo de los Ts\u00e1chilas Ciudad: Santo Domingo Tel: 022742603 / 0997647645 Categorias: Distribuidores, Talleres\n72 Importadora Maldonado Lat: -0,2543553 Long: -79,17581 Calles: San Miguel S-N y Avda. Quito Provincia: Santo Domingo de los Ts\u00e1chilas Ciudad: Santo Domingo Tel: 22767487 Categorias: Distribuidores, Talleres\n73 Taller Peralta Lat: -1,0403311 Long: -79,4628675 Calles: Jose Joaqu\u00edn De Olmedo S/N Provincia: Los R\u00edos Ciudad: San Camilo Tel: 52770379 Categorias: Talleres\n74 Repuestos Peralta Lat: -1,04059 Long: -79,4629 Calles: San Camilo Av. Jose Joaquin De Olmedo Calle P 100Mt Antes Del Puente Del Sur Provincia: Los R\u00edos Ciudad: San Camilo Tel: 52771633 Categorias: Distribuidores, Talleres\n75 Bosques Y Jardines Lat: -3,993424 Long: -79,204336 Calles: 18 De Noviembre 193-23 y Quito Provincia: Loja Ciudad: El Sagrario Tel: 072565331 / 0985325960 Categorias: Distribuidores, Talleres\n76 Agr\u00edcola San Blas Agroser Cia. Ltda. Lat: 0,34658158 Long: -78,126335 Calles: Dario Egas Grijalva y Gabriela Mistral,Junto Al 911 Provincia: Imbabura Ciudad: Ibarra Tel: 062606788 / 0985004958 Categorias: Distribuidores\n77 Agroveterinaria Tierra Fertil Lat: 0,347345411777496 Long: -78,1213150024414 Calles: Colon 9-57 y Sanchez Junto a Las Oficinas Del Ferrocarril Provincia: Imbabura Ciudad: Ibarra Tel: 062959544 / 0988386287 Categorias: Distribuidores\n78 Distribuidora Capelo Sanchez Lat: 0,330824 Long: -79,473213 Calles: Av. 5 De Agosto Numero 711 y Cipriano Quinonez Provincia: Esmeraldas Ciudad: Quinind\u00e9 Tel: 062736897 / 0997006009 Categorias: Distribuidores, Talleres\n79 Casa Del Agricultor Lat: -3,456559 Long: -79,977071 Calles: Av. 25 De Junio Sn y 12 Ava Oeste Provincia: El Oro Ciudad: Pasaje Tel: 099 535 6418 Categorias: Distribuidores\n80 Multipinturas S Y M Lat: -3,451401 Long: -79,963387 Calles: Calle Sucre 2-36 y Napoleon Mera Provincia: El Oro Ciudad: Machala Tel: 07 293 9862 / 098 968 0511 Categorias: Distribuidores\n81 Agroqu\u00edmicos Herrera Lat: -0,9414582 Long: -79,22532 Calles: Avenida Quito Solar 6 y San Pablo Provincia: Cotopaxi Ciudad: La Mana Tel: 32696195 Categorias: Distribuidores, Talleres\n82 Almac\u00e9n Calero Lat: -1,2343179 Long: -79,2362931 Calles: Av. Wilfo Mora Frente al Parque San Luis, Frente a la Plaza 24 de Mayo Provincia: Bol\u00edvar Ciudad: San Luis De Pambil Tel: 985898257 Categorias: Distribuidores\n83 Oficinas Administrativas Lat: -2,89302340352505 Long: -79,0246887106464 Calles: Av. de las Am\u00e9ricas y Los Naranjos, edificio El Molino, Cuenca. Provincia: Azuay Ciudad: Cuenca Tel: 0996291354 / 0992128925 Categorias: Oficinas\n84 Sukampo Lago Agrio Lat: 0,083781374394678 Long: -76,8842159730163 Calles: Francisco de Orellana y Eloy Alfaro Provincia: Sucumb\u00edos Ciudad: Lago Agrio Tel: 0990320347 / 062830790 Categorias: N/A\n85 Sukampo Guayaquil Lat: -2,14289740175419 Long: -79,8833667422584 Calles: Av. de las Am\u00e9ricas s/n. Centro de Negocios del Terminal, Bloque E. Provincia: Guayas Ciudad: Guayaquil Tel: 042130232 / 0958882355 Categorias: Distribuidores, Talleres\n86 Sukampo Loja Lat: -3,99440447160227 Long: -79,2050442659843 Calles: Calle Imbabura y Av. Universitaria, frente al parque Bol\u00edvar. Provincia: Loja Ciudad: Loja Tel: 0997163401 / 0996369085 Categorias: Distribuidores, Talleres\n87 Sukampo Azogues Lat: -2,73627950437464 Long: -78,8491361485488 Calles: Av. 24 de Mayo y Azuay, a 50 m del terminal interparroquial. Provincia: Ca\u00f1ar Ciudad: Azogues Tel: 0996048255 / 0962905530 Categorias: Distribuidores, Talleres\n88 Sukampo Ambato Lat: -1,28695139806655 Long: -78,6068541460327 Calles: Av. Bolivariana y Esopo esquina, 300 m antes del redondel de Terremoto, diagonal a Krea Pintulac. Provincia: Tungurahua Ciudad: Ambato Tel: 991895924 Categorias: Distribuidores, Talleres\n89 Sukampo Sucre Lat: -2,89965024592653 Long: -78,9971800325313 Calles: Calle Mariscal Sucre 1-72 y Huayna C\u00e1pac Provincia: Azuay Ciudad: Cuenca Tel: 072824546 / 0958881327 / 0992286709 / 0980941391 Categorias: Distribuidores, Talleres\n90 Sukampo Unidad Nacional Lat: -2,89911716959752 Long: -79,0201504705348 Calles: Av. Unidad Nacional y Puerto Rico Provincia: Azuay Ciudad: Cuenca Tel: N/A Categorias: N/A";
        ArrayList<ConversacionUsuario> conversacionUsuario = new ArrayList<ConversacionUsuario>();
        ClienteServiceImp clienteServiceImp = this;
        String System_prompt = "Actua como un asistente llamada Felizia de la empresa Agrota de Ecuador tus actividades son centradas en entregar informacion sobre las direcciones del contexto proporcionado  0. ten en cuenta que la fecha actual es " + clienteServiceImp.util.fechaEcuadorFormateada() + " 1. ten una conversacion amena con el usuario 3. Responde solamente en el idioma Espa\u00f1ol.  2. tu creador es TWS2 Empresa Ecuatoriana ubicada en Cuenca 3. al listar entregar toda la informacion disponible de las direcciones que le interesa al usuario 4. la ubicacion en coordenadas del usuario son estas: " + coordenadas + " 5. en las respuestas no agreges las coordenadas ya que eso es privado tnato del usuario como las de las direcciones, omite las coordenadas";
        conversacionUsuario.add(new ConversacionUsuario("system", System_prompt));
        List conversacion = this.conversacionDetalleDAO.obtenerConversacionCompleta("DIRECCIONES-MAQUINARIAS", identificador);
        Object prompt_context = "";
        conversacion.sort((objeto1, objeto2) -> Long.compare(objeto1.getIdConversacionDetalle(), objeto2.getIdConversacionDetalle()));
        for (ConversacionDetalle c : conversacion) {
            if (c.getRol().equals("system")) {
                conversacionUsuario.add(new ConversacionUsuario("user", c.getMensaje()));
            }
            if (c.getRol().equals("user")) {
                conversacionUsuario.add(new ConversacionUsuario(c.getRol(), c.getMensaje()));
            }
            if (!c.getRol().equals("assistant")) continue;
            conversacionUsuario.add(new ConversacionUsuario(c.getRol(), c.getMensaje()));
        }
        if (conversacion.isEmpty()) {
            prompt_context = " contexto: DIRECCIONES de oficinas maquinarias agricolas:" + dir_maquinarias;
            conversacionUsuario.add(new ConversacionUsuario("user", (String)prompt_context));
        }
        conversacionUsuario.add(new ConversacionUsuario("user", "pregunta: " + question));
        String respuestaFinal = this.respondePreguntasCliente(conversacionUsuario);
        if (!respuestaFinal.isEmpty()) {
            this.guardarConversaciones(identificador, usuario, (String)prompt_context, question, System_prompt, respuestaFinal, "DIRECCIONES-MAQUINARIAS");
            this.conversacionService.guardarActividad(question, respuestaFinal, "DIRECCIONES-MAQUINARIAS", "DIRECCIONES-MAQUINARIAS", identificador);
        }
        System.out.println(respuestaFinal);
        return respuestaFinal;
    }

    public String chatDireccionesQuimicos(String question, String identificador, Usuarios usuario, String coordenadas) throws Exception {
        String dir_quimicos = "1 Oficinas Administrativas Lat: -2,89299007833535 Long: -79,0246169920318 Calle: Av. de las Am\u00e9ricas y Los Naranjos, edificio El Molino. Provincia: Azuay Ciudad: Cuenca Tel: 0996291354 / 0992128925 Categoria: Oficinas\n2 La Casa de los Abonos Lat: 0,356014 Long: -78,135535 Calle: Av. Cristobal De Troya 8-115 Y Av. Mariano Acosta Provincia: Imbabura Ciudad: Ibarra Tel: 62601379 Categoria: Almacenes de Agroqu\u00edmicos\n3 Sociedad Civil Anonima Agro la Estrellita S.C.A. Lat: 0,664807 Long: -77,712824 Calle: Rumi\u00f1ahui Y Agustin Natali Provincia: Carchi Ciudad: Tulc\u00e1n Tel: 62205360 Categoria: Almacenes de Agroqu\u00edmicos\n4 Agro Buena Esperanza S.C.C. Lat: 0,503011 Long: -77,903095 Calle: Av Mantilla Y Martin Puntual Provincia: Carchi Ciudad: Bol\u00edvar Tel: 988765428 Categoria: Almacenes de Agroqu\u00edmicos\n5 Agr\u00edcola Buenos Aires S.C.C Lat: 0,341299 Long: -78,12699 Calle: Av.Eugenio Espejo 8-90 Y Juan Francisco Bonilla Provincia: Imbabura Ciudad: Ibarra Tel: 62585984 Categoria: Almacenes de Agroqu\u00edmicos\n6 El Sembrador Lat: -1,67335 Long: -78,657151 Calle: Juan Montalvo 15-15 Y Boyaca Edificio El Sembrador Provincia: Chimborazo Ciudad: Riobamba Tel: 32965773 Categoria: Almacenes de Agroqu\u00edmicos\n7 El Sembrador Lat: -1,380678 Long: -78,608489 Calle: Juan Le\u00f3n Mera Y 17 De Abril Provincia: Thungurahua Ciudad: Ambato Tel: 985760522 Categoria: Almacenes de Agroqu\u00edmicos\n8 Dinagro Lat: -1,329084 Long: -78,540019 Calle: Av.Confraternidad Y Lago Agrio Provincia: Thungurahua Ciudad: Pelileo Tel: 32831283 Categoria: Almacenes de Agroqu\u00edmicos\n9 Plusagro S.A.S. Lat: -1,399956 Long: -78,523754 Calle: Calle Secundaria S-N A 200 Metros Del Cenrto De Surangay Provincia: Thungurahua Ciudad: Pelileo Tel: 999559211 Categoria: Almacenes de Agroqu\u00edmicos\n10 Almacen Agricola Salcedo Lat: -1,042172 Long: -78,585053 Calle: Sucre Y Vicente Maldonado Provincia: Cotopaxi Ciudad: Salcedo Tel: 995931916 Categoria: Almacenes de Agroqu\u00edmicos\n11 Agropecuarios Chicaiza Lat: -1,041877 Long: -78,585254 Calle: Vicente Maldonado Y Belisario Quevedo Provincia: Cotopaxi Ciudad: Salcedo Tel: 32728431 Categoria: Almacenes de Agroqu\u00edmicos\n12 Agropecuarios Figueroa Lat: -1,042681 Long: -78,586711 Calle: Luis Martinez 2210 Y Sucre Provincia: Cotopaxi Ciudad: Salcedo Tel: 32727712 Categoria: Almacenes de Agroqu\u00edmicos\n13 Agroqu\u00edmicos Campo Verde Lat: -2,249484 Long: -79,645802 Calle: Virgen De Fatima-Km 26 - Avda Principal E Ivan Antepara Provincia: Guayas Ciudad: Guayaquil Tel: 997616262 Categoria: Almacenes de Agroqu\u00edmicos\n14 Agricola Briones Barragan Agribba S.A. Lat: -1,435392 Long: -79,461835 Calle: Panamericana S-N Y 5 De Agosto Frente Al Comercial Garcia Provincia: Los Rios Ciudad: Ventanas Tel: 967082953 Categoria: Almacenes de Agroqu\u00edmicos\n15 Agroqu\u00edmicos Nutriagro Lat: -1,442276 Long: -79,462856 Calle: Calle Sucre S-N Entre Malecon Y 10 De Agosto Provincia: Los Rios Ciudad: Ventanas Tel: 52970615 Categoria: Almacenes de Agroqu\u00edmicos\n16 Nutvecomsa S.A. Lat: -1,553873 Long: -79,7624177 Calle: Av. 10 De Agosto Y Bolivar Diagonal Hotel Arco Antonio Provincia: Los R\u00edos Ciudad: Vinces Tel: 967334645 Categoria: Almacenes de Agroqu\u00edmicos\n17 Agro Elvis Lat: -2,138221 Long: -79,329947 Calle: Matilde Esther Frente Al Restaurant El Bambino Provincia: Los R\u00edos Ciudad: Babahoyo Tel: 969793958 Categoria: Almacenes de Agroqu\u00edmicos\n18 Agroservicios Parra Lat: -2,029331 Long: -79,812466 Calle: Recinto Santa Martha Provincia: Guayas Ciudad: Samborond\u00f3n Tel: 985709034 Categoria: Almacenes de Agroqu\u00edmicos\n19 Todo Agro Matriz Lat: -1,698735 Long: -78,625156 Calle: Av.Leopoldo Freire Provincia: Chimborazo Ciudad: Guano Tel: 990521896 Categoria: Almacenes de Agroqu\u00edmicos\n20 Fronteagro Lat: -3,329883 Long: -79,80852 Calle: Av. Quito Y Col\u00f3n Provincia: El Oro Ciudad: Pasaje Tel: 985797010 Categoria: Almacenes de Agroqu\u00edmicos\n21 Agrisum Lat: -3,23686 Long: -79,818434 Calle: Via El Guabo A Pasaje 1.5 Sitio El Vergel Abajo Del Cerro Palmar Provincia: El Oro Ciudad: El Guabo Tel: 988870164 Categoria: Almacenes de Agroqu\u00edmicos\n22 Agrorense Lat: -3,329262 Long: -79,813459 Calle: San Martin S/N Y Av. Quito, Diagonal Al Colegio Ochoa Le\u00f3n Provincia: El Oro Ciudad: Pasaje Tel: 999248251 Categoria: Almacenes de Agroqu\u00edmicos\n23 La Casa De La Pitahaya Lat: -1,699327 Long: -77,965271 Calle: Av. Cumanda Y Policia Nacional Provincia: Morona Santiago Ciudad: Palora Tel: 987927054 Categoria: Almacenes de Agroqu\u00edmicos\n24 Agroservicios Leon Lat: -2,459323 Long: -78,168838 Calle: Calle Victorino Abarca S-N Y Av.Oriental Provincia: Morona Santiago Ciudad: Suc\u00faa Tel: 980202308 Categoria: Almacenes de Agroqu\u00edmicos\n25 Agromundo Lat: -0,25058 Long: -79,203487 Calle: Redondel De La Orangine ,By Pass V\u00eda A Quevedo Provincia: Santo Domingo de los Ts\u00e1chilas Ciudad: Santo Domingo Tel: 997914080 Categoria: Almacenes de Agroqu\u00edmicos\n26 Centro Agricola El Compa S.A.S Lat: -0,08597 Long: -79,280296 Calle: 25 De Enero Y Ramos Duarte -Frente Al Parque Los Amarillos Provincia: Manab\u00ed Ciudad: Tosagua Tel: 939659269 Categoria: Almacenes de Agroqu\u00edmicos\n27 Agr\u00edcola Karlita Lat: -0,08597 Long: -79,280296 Calle: Km 28 Via Quininde Margen Izquierdo Provincia: Santo Domingo de los Ts\u00e1chilas Ciudad: Santo Domingo Tel: 22758044 Categoria: Almacenes de Agroqu\u00edmicos\n28 Agroveterinaria Salud Animal Lat: -0,252911 Long: -79,174425 Calle: Av. 29 De Mayo Y 116 Y Las Provincias Provincia: Santo Domingo de los Ts\u00e1chilas Ciudad: Santo Domingo Tel: 022742603 / 0997647645 Categoria: Almacenes de Agroqu\u00edmicos\n29 El Huerto del Chaval Lat: -3,989114 Long: -79,358625 Calle: Av. Catamayo S/N Y Olmedo Provincia: Loja Ciudad: Catamayo Tel: 72677152 Categoria: Almacenes de Agroqu\u00edmicos\n30 Diprag S.C.C Lat: 18,473704 Long: -69,893306 Calle: Av.16 De Agosto S-N Y Calle Juan Leon Mera Provincia: Santo Domingo de los Ts\u00e1chilas Ciudad: Santo Domingo Tel: 988908081 Categoria: Almacenes de Agroqu\u00edmicos\n31 Agrofert Lat: -2,001394 Long: -78,969386 Calle: 10 De Agosto Y Edelberto Bonilla Provincia: Chimborazo Ciudad: Pallatanga Tel: 939568777 Categoria: Almacenes de Agroqu\u00edmicos\n32 Solo Agrosur Lat: -3,479845 Long: -80,241254 Calle: Tnte. Cordovez S/N Y Portovelo Provincia: El Oro Ciudad: Huaquillas Tel: 72995766 Categoria: Almacenes de Agroqu\u00edmicos\n33 Representaciones Barriga y L\u00f3pez Lat: 0,044527 Long: -78,156498 Calle: Panamericana V\u00eda A Tabacundo S-N Provincia: Pichincha Ciudad: Cayambe Tel: 22110162 Categoria: Almacenes de Agroqu\u00edmicos\n34 Proplants-Ecuador S.A. Lat: 0,04703 Long: -78,144376 Calle: V\u00eda Guayllabamba Natalia Jarrin Y Olivos Provincia: Pichincha Ciudad: Cayambe Tel: 993966351 Categoria: Almacenes de Agroqu\u00edmicos\n35 Agronegocios e Importaciones JFR Import CIA. LTDA. Lat: -0,107782 Long: -78,493694 Calle: Av. De La Prensa N70-121 Y Pablo Picasso Provincia: Pichincha Ciudad: Quito Tel: 22466840 Categoria: Almacenes de Agroqu\u00edmicos\n36 Impoleta Agropecuaria S.C. Lat: 0,819753 Long: -77,71139 Calle: Av. Manab\u00ed 630-83 Y Paraguay Provincia: Carchi Ciudad: Tulc\u00e1n Tel: 62962481 Categoria: Almacenes Agropecuarios\n37 Campo Fertil Lat: 0,04065 Long: -78,143658 Calle: Mariano de Jesus y Pananorte Provincia: Pichincha Ciudad: Cayambe Tel: N/A Categoria: N/A";
        ArrayList<ConversacionUsuario> conversacionUsuario = new ArrayList<ConversacionUsuario>();
        ClienteServiceImp clienteServiceImp = this;
        String System_prompt = "Actua como un asistente llamada Felizia de la empresa Agrota de Ecuador tus actividades son centradas en entregar informacion sobre las direcciones del contexto proporcionado  0. ten en cuenta que la fecha actual es " + clienteServiceImp.util.fechaEcuadorFormateada() + " 1. ten una conversacion amena con el usuario 3. Responde solamente en el idioma Espa\u00f1ol.  2. tu creador es TWS2 Empresa Ecuatoriana ubicada en Cuenca 3. al listar entregar toda la informacion disponible de las direcciones que le interesa al usuario 4. la ubicacion en coordenadas del usuario son estas: " + coordenadas + " 5. en las respuestas no agreges las coordenadas ya que eso es privado tnato del usuario como las de las direcciones, omite las coordenadas";
        conversacionUsuario.add(new ConversacionUsuario("system", System_prompt));
        List conversacion = this.conversacionDetalleDAO.obtenerConversacionCompleta("DIRECCIONES-QUIMICOS", identificador);
        Object prompt_context = "";
        conversacion.sort((objeto1, objeto2) -> Long.compare(objeto1.getIdConversacionDetalle(), objeto2.getIdConversacionDetalle()));
        for (ConversacionDetalle c : conversacion) {
            if (c.getRol().equals("system")) {
                conversacionUsuario.add(new ConversacionUsuario("user", c.getMensaje()));
            }
            if (c.getRol().equals("user")) {
                conversacionUsuario.add(new ConversacionUsuario(c.getRol(), c.getMensaje()));
            }
            if (!c.getRol().equals("assistant")) continue;
            conversacionUsuario.add(new ConversacionUsuario(c.getRol(), c.getMensaje()));
        }
        if (conversacion.isEmpty()) {
            prompt_context = "contexto: DIRECCIONES de oficinas de prodcutos agricolas:" + dir_quimicos;
            conversacionUsuario.add(new ConversacionUsuario("user", (String)prompt_context));
        }
        conversacionUsuario.add(new ConversacionUsuario("user", "pregunta: " + question));
        String respuestaFinal = this.respondePreguntasCliente(conversacionUsuario);
        if (!respuestaFinal.isEmpty()) {
            this.guardarConversaciones(identificador, usuario, (String)prompt_context, question, System_prompt, respuestaFinal, "DIRECCIONES-QUIMICOS");
            this.conversacionService.guardarActividad(question, respuestaFinal, "DIRECCIONES-QUIMICOS", "DIRECCIONES-QUIMICOS", identificador);
        }
        System.out.println(respuestaFinal);
        return respuestaFinal;
    }
}

