/*
 * Decompiled with CFR 0.152.
 */
package com.agrota.logic.service.impl;

import com.agrota.logic.data.ConversacionUsuario;
import com.agrota.logic.data.RespuestaCodigos;
import com.agrota.logic.data.RespuestaVector;
import com.agrota.logic.model.Actividad;
import com.agrota.logic.model.CaracteristicasQuimicos;
import com.agrota.logic.model.ConversacionDetalle;
import com.agrota.logic.model.Documento;
import com.agrota.logic.model.Informacion;
import com.agrota.logic.model.SeccionDocumento;
import com.agrota.logic.model.Usuarios;
import com.agrota.logic.repository.ActividadDAO;
import com.agrota.logic.repository.CaracteristicasQuimicosDAO;
import com.agrota.logic.repository.ConversacionDAO;
import com.agrota.logic.repository.ConversacionDetalleDAO;
import com.agrota.logic.repository.DocumentoDAO;
import com.agrota.logic.repository.InformacionDAO;
import com.agrota.logic.repository.SeccionDocumentoDAO;
import com.agrota.logic.repository.UsuariosDAO;
import com.agrota.logic.service.BaseService;
import com.agrota.logic.service.ConversacionService;
import com.agrota.logic.service.MetodosAsincronosService;
import com.agrota.logic.service.SeccionDocumentoService;
import com.agrota.logic.service.impl.ConversacionServiceAsync;
import com.agrota.utils.UtilLhia;
import com.knuddels.jtokkit.Encodings;
import com.knuddels.jtokkit.api.Encoding;
import com.knuddels.jtokkit.api.EncodingRegistry;
import com.knuddels.jtokkit.api.ModelType;
import java.io.InputStream;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class BaseServiceImpl
implements BaseService {
    private Logger log = Logger.getLogger(BaseServiceImpl.class.getName());
    @Autowired
    private ConversacionServiceAsync conversacionServiceAsycn;
    UtilLhia util = new UtilLhia();
    String iniTextoNew;
    @Autowired
    private InformacionDAO informacionDAO;
    @Autowired
    private CaracteristicasQuimicosDAO caracteristicasQuimicosDAO;
    @Autowired
    private SeccionDocumentoDAO seccionDocumentoDAO;
    @Autowired
    private SeccionDocumentoService seccionDocumentoService;
    @Autowired
    private ConversacionDetalleDAO conversacionDetalleDAO;
    @Autowired
    private ConversacionService conversacionService;
    @Autowired
    private UsuariosDAO usuariosDAO;
    @Autowired
    private ConversacionDAO conversacionDAO;
    @Autowired
    private DocumentoDAO documentoDAO;
    @Autowired
    private ActividadDAO actividadDAO;
    @Autowired
    private MetodosAsincronosService metodosAsincronosService;
    @Value(value="${openai.apiKey}")
    private String apiKey;
    @Value(value="${openai.url}")
    private String url;
    @Value(value="${openai.urlAnswer2}")
    private String urlAnswer2;
    @Value(value="${openai.modelAnswer2}")
    private String modelAnswer2;
    @Value(value="${openai.urlAnswer3}")
    private String urlAnswer3;
    @Value(value="${openai.modelAnswer3}")
    private String modelAnswer3;
    @Value(value="${back.python.path}")
    private String pythonUrl;
    private final RestTemplate restTemplate = new RestTemplate();
    private EncodingRegistry registry = Encodings.newLazyEncodingRegistry();
    private Encoding encoding = this.registry.getEncodingForModel(ModelType.CUSHMAN_CODEX);
    private String textSystem = "";

    public String preguntaMilvus(String question, String tipo, String usuario, String identificador_nuevo) throws Exception {
        String respuestaRobot = "";
        this.log.info("empieza a cargar" + LocalDateTime.now());
        Usuarios usuario_ingresado = (Usuarios)this.usuariosDAO.findByUsuario(usuario).get();
        String identificador_antiguo = this.conversacionService.obtenerUltimaConversacion(usuario_ingresado.getUsuario()) != null ? this.conversacionService.obtenerUltimaConversacion(usuario_ingresado.getUsuario()).getIdentificador() : "";
        this.log.info(identificador_antiguo);
        if (identificador_nuevo.equals(identificador_antiguo)) {
            respuestaRobot = this.consultaMilvus(question, identificador_antiguo, tipo, usuario_ingresado);
            return respuestaRobot;
        }
        respuestaRobot = this.consultaMilvus(question, identificador_nuevo, tipo, usuario_ingresado);
        return respuestaRobot;
    }

    public String obtenerClientes(String usuario) {
        String url = "https://agrota-datos.lhia.ai/api/v1/allApis/empleado";
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"usuario", (Object)usuario);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity requestEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)requestEntity, String.class, new Object[0]);
        return (String)response.getBody();
    }

    public String obtenerToken() {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.set("accept", "*/*");
        headers.set("Content-Type", "application/json");
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("usuario", "LihaMind");
        body.put("clave", "@FelizIA@2024**");
        HttpEntity requestEntity = new HttpEntity(body, (MultiValueMap)headers);
        try {
            ResponseEntity response = restTemplate.exchange("https://felizia-api.lhia.ai/api/Autenticacion/Validar", HttpMethod.POST, requestEntity, Map.class, new Object[0]);
            if (response.getBody() != null && ((Map)response.getBody()).containsKey("token")) {
                return (String)((Map)response.getBody()).get("token");
            }
            System.out.println("La respuesta no contiene un token.");
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String respondePreguntas(String prompt, Double temp) {
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", this.modelAnswer3);
        requestBody.put("prompt", prompt);
        requestBody.put("max_tokens", 250);
        requestBody.put("temperature", temp);
        requestBody.put("stop", "[\" user:\", \" assistant:\"]");
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.urlAnswer3, (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        String text = (String)choiceObj.get("text");
        return text.replaceAll("Assistant:", "").replaceAll("assistant:", "").replaceAll("RESPUESTA:", "");
    }

    public void generateNumTokens() {
        List listaConversacionDetalle = this.conversacionDetalleDAO.findAll();
        for (ConversacionDetalle conversacionDetalle : listaConversacionDetalle) {
            if (!conversacionDetalle.getRol().equals("user") && !conversacionDetalle.getRol().equals("assistant")) continue;
            conversacionDetalle.setTokens((long)this.encoding.countTokens(conversacionDetalle.getMensaje()));
            this.conversacionDetalleDAO.save((Object)conversacionDetalle);
        }
    }

    private String respondePreguntasV2(List<ConversacionUsuario> lstConversation) {
        JSONObject requestBody = new JSONObject();
        requestBody.put("messages", lstConversation);
        requestBody.put("model", (Object)this.modelAnswer3);
        requestBody.put("max_tokens", 1000);
        requestBody.put("temperature", 0.3);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity request = new HttpEntity((Object)requestBody.toString(), (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.urlAnswer2, (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        JSONObject messageObj = (JSONObject)choiceObj.get("message");
        String text = (String)messageObj.get("content");
        System.out.println("respuesta GPT: " + text);
        return text;
    }

    private String respondePreguntasV3(String pregunta, Double temp) {
        ArrayList<ConversacionUsuario> conversacionUsuario = new ArrayList<ConversacionUsuario>();
        conversacionUsuario.add(new ConversacionUsuario("user", pregunta));
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("model", this.modelAnswer3);
        requestBody.put("messages", conversacionUsuario);
        requestBody.put("max_tokens", 200);
        requestBody.put("temperature", temp);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("Authorization", "Bearer " + this.apiKey);
        HttpEntity request = new HttpEntity(requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.urlAnswer2, (Object)request, Map.class, new Object[0]);
        JSONObject responseJson = new JSONObject((Map)response.getBody());
        JSONArray embeddingArray = responseJson.getJSONArray("choices");
        JSONObject choiceObj = (JSONObject)embeddingArray.get(0);
        JSONObject messageObj = (JSONObject)choiceObj.get("message");
        String text = (String)messageObj.get("content");
        return text;
    }

    public int obtenerTokens(LocalDateTime fecha1, LocalDateTime fecha2) {
        if (this.conversacionDetalleDAO.obtenerTokens(fecha1, fecha2) != null) {
            return Integer.valueOf(this.conversacionDetalleDAO.obtenerTokens(fecha1, fecha2));
        }
        return 0;
    }

    public ResponseEntity<String> respondePreguntasMilvus(String pregunta) {
        String jsonBody = "{\"message\": \"" + pregunta + "\"}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity((Object)jsonBody, (MultiValueMap)headers);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = restTemplate.postForEntity(this.pythonUrl + "/chat-agrota", (Object)request, String.class, new Object[0]);
        return response;
    }

    public ResponseEntity<RespuestaVector> respondePreguntasMilvusMaquinaria(String pregunta) {
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        requestBody.add((Object)"pregunta", (Object)pregunta);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.pythonUrl + "/pregunta_milvus_maquinaria", (Object)request, RespuestaVector.class, new Object[0]);
        return response;
    }

    public ResponseEntity<RespuestaVector> respondePreguntasMilvusQuimicos(String pregunta) {
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        requestBody.add((Object)"pregunta", (Object)pregunta);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.pythonUrl + "/pregunta_milvus_quimicos", (Object)request, RespuestaVector.class, new Object[0]);
        return response;
    }

    public ResponseEntity<RespuestaVector> respondePreguntasMilvusQuimicosAdicional(String pregunta) {
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        requestBody.add((Object)"pregunta", (Object)pregunta);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.pythonUrl + "/pregunta_milvus_quimicos_adicional", (Object)request, RespuestaVector.class, new Object[0]);
        return response;
    }

    public String ConsultarApiInfoInventario(String pregunta, String tipo) throws Exception {
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        requestBody.add((Object)"pregunta", (Object)pregunta);
        requestBody.add((Object)"tipo", (Object)tipo);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.pythonUrl + "/pregunta_milvus_inventario", (Object)request, RespuestaCodigos.class, new Object[0]);
        StringBuilder result = new StringBuilder();
        if (response.getBody() != null && ((RespuestaCodigos)response.getBody()).getContenido() != null) {
            List<CompletableFuture> futureList = ((RespuestaCodigos)response.getBody()).getContenido().stream().map(codigo -> this.metodosAsincronosService.obtenerProductoPorCodigo(codigo.trim())).collect(Collectors.toList());
            CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).join();
            List contenido = futureList.stream().map(CompletableFuture::join).collect(Collectors.toList());
            for (String palabras : contenido) {
                result.append(palabras);
            }
            return "Stock cantidad o existencia actual en bodegas: \n" + result.toString().trim();
        }
        return "";
    }

    public String ConsultarApiInfoPrecioInventario(String pregunta, String tipo) throws Exception {
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        requestBody.add((Object)"pregunta", (Object)pregunta);
        requestBody.add((Object)"tipo", (Object)tipo);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.pythonUrl + "/pregunta_milvus_inventario", (Object)request, RespuestaCodigos.class, new Object[0]);
        StringBuilder result = new StringBuilder();
        if (response.getBody() != null && ((RespuestaCodigos)response.getBody()).getContenido() != null) {
            List<CompletableFuture> futureList = ((RespuestaCodigos)response.getBody()).getContenido().stream().map(codigo -> this.metodosAsincronosService.obtenerPrecioProductoPorCodigo(codigo.trim())).collect(Collectors.toList());
            CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).join();
            List contenido = futureList.stream().map(CompletableFuture::join).collect(Collectors.toList());
            for (String palabras : contenido) {
                result.append(palabras);
            }
            return "Stock cantidad o existencia actual en bodegas: \n" + result.toString().trim();
        }
        return "";
    }

    public String ConsultarApiInfoInventarioQuimicosAdicional(String pregunta, String tipo) throws Exception {
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        requestBody.add((Object)"pregunta", (Object)pregunta);
        requestBody.add((Object)"tipo", (Object)tipo);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.pythonUrl + "/pregunta_milvus_inventario_adicional", (Object)request, RespuestaCodigos.class, new Object[0]);
        StringBuilder result = new StringBuilder();
        if (response.getBody() != null && ((RespuestaCodigos)response.getBody()).getContenido() != null) {
            List<CompletableFuture> futureList = ((RespuestaCodigos)response.getBody()).getContenido().stream().map(codigo -> this.metodosAsincronosService.obtenerProductoPorCodigo(codigo.trim())).collect(Collectors.toList());
            CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).join();
            List contenido = futureList.stream().map(CompletableFuture::join).collect(Collectors.toList());
            for (String palabras : contenido) {
                result.append(palabras);
            }
            return "Stock cantidad o existencia actual en bodegas: \n" + result.toString().trim();
        }
        return "";
    }

    public String ConsultarApiInfoLlegada(String pregunta, String tipo, Date fecha_actual) throws Exception {
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        requestBody.add((Object)"pregunta", (Object)pregunta);
        requestBody.add((Object)"tipo", (Object)tipo);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.pythonUrl + "/pregunta_milvus_inventario", (Object)request, RespuestaCodigos.class, new Object[0]);
        StringBuilder result = new StringBuilder();
        if (response.getBody() != null && ((RespuestaCodigos)response.getBody()).getContenido() != null) {
            List<CompletableFuture> futureList = ((RespuestaCodigos)response.getBody()).getContenido().stream().map(codigo -> this.metodosAsincronosService.obtenerLlegadaProducto(codigo.trim(), fecha_actual)).collect(Collectors.toList());
            CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).join();
            List contenido = futureList.stream().map(CompletableFuture::join).collect(Collectors.toList());
            for (String palabras : contenido) {
                result.append(palabras);
            }
            return "fechas de llegada: " + result.toString().trim();
        }
        return "";
    }

    public String ConsultarApiInfoLlegadaQuimicosAdicional(String pregunta, String tipo, Date fecha_actual) throws Exception {
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        requestBody.add((Object)"pregunta", (Object)pregunta);
        requestBody.add((Object)"tipo", (Object)tipo);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.pythonUrl + "/pregunta_milvus_inventario_adicional", (Object)request, RespuestaCodigos.class, new Object[0]);
        StringBuilder result = new StringBuilder();
        if (response.getBody() != null && ((RespuestaCodigos)response.getBody()).getContenido() != null) {
            List<CompletableFuture> futureList = ((RespuestaCodigos)response.getBody()).getContenido().stream().map(codigo -> this.metodosAsincronosService.obtenerLlegadaProducto(codigo.trim(), fecha_actual)).collect(Collectors.toList());
            CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).join();
            List contenido = futureList.stream().map(CompletableFuture::join).collect(Collectors.toList());
            for (String palabras : contenido) {
                result.append(palabras);
            }
            return "fechas de llegada: " + result.toString().trim();
        }
        return "";
    }

    public String ConsultarInfoQuimicos(String pregunta, String tipo) throws Exception {
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        requestBody.add((Object)"pregunta", (Object)pregunta);
        requestBody.add((Object)"tipo", (Object)tipo);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(this.pythonUrl + "/pregunta_milvus_inventario_adicional", (Object)request, RespuestaCodigos.class, new Object[0]);
        if (response.getBody() == null || ((RespuestaCodigos)response.getBody()).getContenido() == null) {
            return "";
        }
        ExecutorService executor = Executors.newFixedThreadPool(10);
        String[] codigos = ((RespuestaCodigos)response.getBody()).getContenido().toArray(new String[0]);
        CompletableFuture[] futures = (CompletableFuture[])Arrays.stream(codigos).map(codigo -> CompletableFuture.supplyAsync(() -> this.procesarCodigo(codigo), executor)).toArray(CompletableFuture[]::new);
        String result = (String)((CompletableFuture)CompletableFuture.allOf(futures).thenApply(v -> Arrays.stream(futures).map(CompletableFuture::join).reduce("", String::concat))).join();
        executor.shutdown();
        System.out.println("informacion adicional: " + result.trim());
        return "informacion adicional: " + result.trim();
    }

    private String procesarCodigo(String codigo) {
        StringBuilder result = new StringBuilder();
        List quimicos = this.caracteristicasQuimicosDAO.findByCodigo_venta(codigo);
        if (quimicos != null) {
            for (CaracteristicasQuimicos quimico : quimicos) {
                List grupos = this.caracteristicasQuimicosDAO.findByGrupo(quimico.getGrupo());
                result.append("El producto: ").append(quimico.getDescripcion()).append(" pertenece al grupo ").append(quimico.getGrupo()).append(":\n");
                grupos.forEach(grupo -> {
                    try {
                        result.append((String)(grupo.getTipoMarca().equals("Padre") ? "la materia prima del producto es:\n" : "el concepto o caracter\u00edsticas del producto " + quimico.getDescripcion() + " es similar para los siguientes productos, ya que comparten la misma materia prima:\n"));
                        BaseServiceImpl baseServiceImpl = this;
                        result.append("descripcion: ").append(grupo.getDescripcion()).append("\n").append("categoria: ").append(grupo.getCategoria()).append("\n").append("linea: ").append(grupo.getLinea()).append("\n").append("grupo: ").append(grupo.getGrupo()).append("\n").append("codigo venta: ").append(grupo.getCodigoVenta()).append("\n").append("estado: ").append(grupo.getEstado()).append("\n").append("informacion sobre stock de " + grupo.getDescripcion() + ": " + this.ConsultarApiInfoInventarioQuimicosAdicional(grupo.getDescripcion().toLowerCase(), "QUIMICOS")).append("informacion sobre fecha de llegada " + grupo.getDescripcion() + ": " + this.ConsultarApiInfoLlegadaQuimicosAdicional(grupo.getDescripcion().toLowerCase(), "QUIMICOS", baseServiceImpl.util.fechaEcuador()));
                        CompletableFuture<String> conceptoFuture = CompletableFuture.supplyAsync(() -> {
                            ResponseEntity response = this.respondePreguntasMilvusQuimicosAdicional(this.util.quitarTildes(grupo.getDescripcion().toLowerCase()));
                            if (response.getBody() != null) {
                                return ((RespuestaVector)response.getBody()).getContenido();
                            }
                            return "";
                        });
                        String concepto = conceptoFuture.get();
                        result.append("concepto: ").append(concepto).append("\n");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        result.append("concepto: Error al obtener el concepto\n");
                    }
                });
            }
        }
        return result.toString();
    }

    private void guardarConversaciones(String identificador, Usuarios usuario, String prompt, String pregunta, String system, String answer, String carpeta) {
        this.conversacionService.guardarConversacion(identificador, usuario, "system", "", this.encoding.countTokens(system), "", system, carpeta);
        this.conversacionService.guardarConversacion(identificador, usuario, "user", prompt, this.encoding.countTokens(prompt), pregunta, "", carpeta);
        this.conversacionService.guardarConversacion(identificador, usuario, "assistant", answer, this.encoding.countTokens(answer), "", "", carpeta);
    }

    public String obtenerProductoPorPalabra(String palabra) {
        String url = "https://felizia-api.tws2.io/api/productospvp/byPalabra/" + palabra;
        return (String)this.restTemplate.getForObject(url, String.class, new Object[0]);
    }

    public String obtenerProductoPorPalabraQuimico(String palabra) {
        String url = "https://felizia-api.tws2.io/api/productospvp/byPalabra/" + palabra;
        return (String)this.restTemplate.getForObject(url, String.class, new Object[0]);
    }

    public String consultaMilvus(String question, String identificador, String tipo, Usuarios usuario) throws Exception {
        String promptCompleto;
        String documentoInformacion;
        StringBuilder resultadoBusqueda;
        String precio;
        String inventario;
        String llegada;
        RespuestaVector respuestaVector;
        String division;
        ArrayList<ConversacionUsuario> conversacionUsuario = new ArrayList<ConversacionUsuario>();
        this.log.info(identificador);
        if (!this.conversacionDAO.existsByIdentificador(identificador) || identificador.equals("Identificador no encontrado")) {
            identificador = UUID.randomUUID().toString();
        }
        BaseServiceImpl baseServiceImpl = this;
        this.iniTextoNew = "Debes realizar lo siguientes: 0. La fecha actual En Ecuador donde funcionas es " + baseServiceImpl.util.fechaEcuador() + " 1. Te llamas FelizIA y debes actuar como un asistente virtual para un agente de ventas de la empresa Agrota que se dedica a la venta de productos agr\u00edcolas. 2. No puedes buscar en internet.  3. No digas que eres creado por OpenAI.  5. ten una conversacion amena con el usuario 6. Responde solamente en el idioma Espa\u00f1ol.  7. entrega los links en formato markdown 8. si la pregunta del usuario trata sobre existencia o fecha de llegada de algun producto busca y este se encuentra en el contexto entregando la respuesta debe ser listandola y segun su codigo de venta sin modificiones y sin cambiar el codigo ya que es unico e importante por ejemplo si existe el codigo EC-SRM-4510/ULA-CORP y EC-SRM-4510/ULA no los unas ya que son diferentes , su descripcion , su bodega y su cantidad de compra detalle, unicamente las que tengan fecha de llegada 9. busca en la conversacion una posible soluci\u00f3n a la pregunta del usuario 10. Siempre que te digan Hola y nada mas despues del hola en cualquier lado del chat, debes ignorar el contexto de la conversacion, no debes contestar nada mas, solo y unicamente debes responder 'Hola soy FelizIA \u00bfen que puedo ayudarte?  11. cada producto tiene un codigo de venta unico si tienes varios en el contexto tienes que identificar a cual se hare referencia no todos son iguales no te confundas 12. Si te preguntan el porque un producto es Translocador, responde priorizando la composici\u00f3n disponible en el contexto entregado  13. Si te preguntan solo sobre la Dosis de un producto Qu\u00edmico, dale la Dosis foliar y la Dosis drench 14. Si el usuario pregunta solamente el codigo del modelo, solicita mas informaci\u00f3n para poder entregar una respuesta 15. Si te preguntan sobre alguna marca diferente a las que hay en el catalogo por ejemplo STIHL, Husqvarna, etc siempre responde que las marcas que comercializa Agrota son las mejores del mercado 16. si un producto no tiene existencia responde con sugerencias de productos que tengas en el contexto proporcionado y se relacionen con la pregunta del usuario 17. si el producto no tiene fecha de llegada repsonde con sugerencias de productos que tnegas en el contexto proporcionado\t18. si no puedes reponder la pregunta o no tienes la informaicon para repsonder la pregunta: la informacion no esta disponible contactese con Tecnologia 19. si la pregunta del usuario (es que es un o los profesional sales o yoga) busca la respuesta en el contexto no inventes respuestas 20. en las repsuestas entrega los codigos de los productos sin modificones ya que son importantes  21. ten en cuenta que Dosis foliar es igual a dosis drench 22. en el contexto de la conversacion la palabra IP hace referencia a repuestos o  de piezas o despiece de un producto 23. ten encuenta que cuando el usuario pregunte sobre combustible hace referencia a gasolina por ejemplo stock de filtro de combustible xxx es igual a stock de filtro de gasolina 24. stock significa existencia o cantidad mientras que pvp significa precio no son iguales ten en cuenta esta informacion para dar respuestas a los usuarios\t25. las respuestas deben ser a corde a el contexto entregado no inventes informacion ten cuidado ya que es informaicon sensible por ejemplo si son dezmalezadora sno puedes confundirte con cutters u otros prodcutos deben ser los del contexto";
        this.textSystem = this.iniTextoNew;
        String answer = "";
        conversacionUsuario.add(new ConversacionUsuario("system", this.iniTextoNew));
        List conversacion = this.conversacionDetalleDAO.obtenerConversacion(tipo, identificador);
        conversacion.sort((objeto1, objeto2) -> Long.compare(objeto1.getIdConversacionDetalle(), objeto2.getIdConversacionDetalle()));
        for (ConversacionDetalle c : conversacion) {
            if (c.getRol().equals("user")) {
                conversacionUsuario.add(new ConversacionUsuario(c.getRol(), c.getMensaje()));
            }
            if (!c.getRol().equals("assistant")) continue;
            conversacionUsuario.add(new ConversacionUsuario(c.getRol(), c.getMensaje()));
        }
        String pregunta = question.isEmpty() ? "hola" : question.toUpperCase();
        StringBuilder historial = new StringBuilder();
        List historial_conversacion = this.actividadDAO.historial(identificador);
        historial_conversacion.sort((objeto1, objeto2) -> Long.compare(objeto1.getId_actividad(), objeto2.getId_actividad()));
        int conteo_pregunta = 1;
        for (Actividad registro : historial_conversacion) {
            historial.append("pregunta " + conteo_pregunta++ + " : " + registro.getTexto_pregunta() + "\n\n");
        }
        System.out.println("********historial*********");
        System.out.println(historial);
        System.out.println("********historial*********");
        String pregunta_reformulada = pregunta.toLowerCase().trim().equals("hola") ? "HOLA" : this.respondePreguntasV3("historial de preguntas del usuario: " + historial + "\n\nnueva pregunta del usuario: " + pregunta + "Dado un historial de preguntas y una nueva pregunta del usuario reformula una nueva pregunta siguiedo el contexto del historial de preguntas y cambia de contexto cuando la nueva pregunta del usuario tiene una idea nueva, procura no editar gramaticlamente la nueva pregunta del usuario la pregunta generada tiene que ir en torno a la idea de esteindicaciones para reformulacion de la nueva pregunta:1. si la nueva pregunta del usuario es 'hola', devuelve como nueva pregunta la palabra 'hola'2. devuelve solamente la pregunta reformulada o generada3. si la nueva pregunta del usuario es sobre 'profesional sales' o 'yoga' o 'letal' o 'paraguas' o 'zeol' o 'docus' este es un producto asi que no cambies sus palabras no lo traduzcas4. las preguntas que el usuario realiza es sobre productos agr\u00edcolas pero no agreges esto en la nueva pregunta generada5. cambiar la palabra combustible por gasolina o combustible6. no infieras nombres para codigos si en el historial de conversacion no lo agregan ya que se trata de prodcutos agricolas", Double.valueOf(0.3)).replaceAll("\n", "");
        System.out.println(pregunta_reformulada);
        System.out.println("********idea*********");
        String promptPrincipal = "pregunta del usuario: '" + pregunta_reformulada + "?' omite en la respuesta de donde se obtuvo la informacion, y entregalo solo si la pregunta te lo pide- si la pregunta del usuario trata sobre fecha de llegada de algun producto busca en el contexto entregando la respuesta listandola y segun su codigo de venta sin modificiones y sin cambiar el codigo ya que es unico e importante por ejemplo si existe el codigo EC-SRM-4510/ULA-CORP y EC-SRM-4510/ULA no los unas ya que son diferentes, su descripcion, su bodega y su cantidad de compra detalle.- si la pregunta del usuario trata sobre stock o existencia entregar en la repsuesta el codigo de venta, la descripcion, la marca, la linea, la categoria, el tipo de producto,  el stock o cantidad disponible, la bodega, adicionalmente no unas codigos ya que son diferentes.- si la pregunta trata del color o caracteristicas fisica responde con el link del producto en markdown";
        Object prompt = "";
        double scoreFinal = 0.0;
        if (tipo.equals("MAQUINARIAS")) {
            division = "MAQUINARIA";
            respuestaVector = (RespuestaVector)this.respondePreguntasMilvusMaquinaria(this.util.quitarTildes(pregunta_reformulada.toLowerCase())).getBody();
            if (respuestaVector != null && !respuestaVector.getContenido().isEmpty()) {
                String string;
                if (!this.transicion(pregunta_reformulada, " fecha de llegada, llegada, cuando llega un producto, transito de producto, transito").toLowerCase().contains("tr")) {
                    string = "";
                } else {
                    BaseServiceImpl baseServiceImpl2 = this;
                    string = this.ConsultarApiInfoLlegada(pregunta_reformulada.toUpperCase(), division, baseServiceImpl2.util.fechaEcuador());
                }
                llegada = string;
                inventario = !this.transicion(pregunta_reformulada, " stock o cantidad o existencia en cantidad, cantidad de un producto, stock de prodcuto, stock ").toLowerCase().contains("tr") ? "" : this.ConsultarApiInfoInventario(pregunta_reformulada.toUpperCase(), division);
                precio = !this.transicion(pregunta_reformulada, "precio, cuanto cuesta ").toLowerCase().contains("tr") ? "" : this.ConsultarApiInfoPrecioInventario(pregunta_reformulada.toUpperCase(), division);
                resultadoBusqueda = new StringBuilder();
                documentoInformacion = "Informaci\u00f3n obtenida de " + respuestaVector.getDocumento();
                resultadoBusqueda.append(documentoInformacion + " es el siguiente:\n");
                prompt = "contexto entregado: " + resultadoBusqueda + respuestaVector.getContenido() + "\n\n" + inventario + llegada + precio + "\n";
                promptCompleto = ((String)prompt).concat(promptPrincipal);
                System.out.println(promptCompleto);
                conversacionUsuario.add(new ConversacionUsuario("user", promptCompleto));
                answer = this.respondePreguntasV2(conversacionUsuario);
                if (!answer.isEmpty()) {
                    this.guardarConversaciones(identificador, usuario, promptCompleto, pregunta_reformulada, this.iniTextoNew, answer, tipo);
                    this.conversacionService.guardarActividad(pregunta_reformulada, answer, respuestaVector.getDocumento(), "MAQUINARIAS", identificador);
                }
            } else {
                conversacionUsuario.add(new ConversacionUsuario("user", promptPrincipal + " "));
                answer = this.respondePreguntasV2(conversacionUsuario);
                if (!answer.isEmpty()) {
                    this.guardarConversaciones(identificador, usuario, promptPrincipal, pregunta_reformulada, this.iniTextoNew, answer, tipo);
                    this.conversacionService.guardarActividad(pregunta_reformulada, answer, "ADICIONAL", "MAQUINARIAS", identificador);
                }
            }
            this.log.info("Finalizado " + Instant.now());
        }
        if (tipo.equals("QU\u00cdMICOS")) {
            division = "QUIMICOS";
            respuestaVector = (RespuestaVector)this.respondePreguntasMilvusQuimicos(this.util.quitarTildes(pregunta_reformulada.toLowerCase())).getBody();
            if (respuestaVector != null && !respuestaVector.getContenido().isEmpty()) {
                String string;
                if (!this.transicion(pregunta_reformulada, " fecha de llegada, llegada, cuando llega un producto, transito de producto").toLowerCase().contains("tr")) {
                    string = "";
                } else {
                    BaseServiceImpl baseServiceImpl3 = this;
                    string = this.ConsultarApiInfoLlegada(pregunta_reformulada.toUpperCase(), division, baseServiceImpl3.util.fechaEcuador());
                }
                llegada = string;
                inventario = !this.transicion(pregunta_reformulada, " stock o cantidad o existencia en cantidad, cantidad de un producto, stock de prodcuto, stock ").toLowerCase().contains("tr") ? "" : this.ConsultarApiInfoInventario(pregunta_reformulada.toUpperCase(), division);
                precio = !this.transicion(pregunta_reformulada, "precio, costo, cuanto cuesta ").toLowerCase().contains("tr") ? "" : this.ConsultarApiInfoPrecioInventario(pregunta_reformulada.toUpperCase(), division);
                resultadoBusqueda = new StringBuilder();
                documentoInformacion = "Informaci\u00f3n obtenida de " + respuestaVector.getDocumento();
                resultadoBusqueda.append(documentoInformacion + " es el siguiente:\n");
                prompt = "contexto entregado: " + resultadoBusqueda + respuestaVector.getContenido() + "\n\n" + inventario + llegada + precio + "\n";
                promptCompleto = ((String)prompt).concat(promptPrincipal);
                System.out.println(promptCompleto);
                conversacionUsuario.add(new ConversacionUsuario("user", promptCompleto));
                answer = this.respondePreguntasV2(conversacionUsuario);
                if (!answer.isEmpty()) {
                    this.guardarConversaciones(identificador, usuario, promptCompleto, pregunta_reformulada, this.iniTextoNew, answer, tipo);
                    this.conversacionService.guardarActividad(pregunta_reformulada, answer, respuestaVector.getDocumento(), "QU\u00cdMICOS", identificador);
                }
            } else {
                conversacionUsuario.add(new ConversacionUsuario("user", promptPrincipal + " "));
                answer = this.respondePreguntasV2(conversacionUsuario);
                if (!answer.isEmpty()) {
                    this.guardarConversaciones(identificador, usuario, promptPrincipal, pregunta_reformulada, this.iniTextoNew, answer, tipo);
                    this.conversacionService.guardarActividad(pregunta_reformulada, answer, "ADICIONAL", "QU\u00cdMICOS", identificador);
                }
            }
            this.log.info("Finalizado " + Instant.now());
        }
        return answer;
    }

    public String transicion(String pregunta, String objetivo) {
        String consulta = this.respondePreguntasV3("Eval\u00faa si la siguiente frase o pregunta: '" + pregunta + "' tiene sinonimo de las palabras o contiene las siguientes palabras: " + objetivo + " si es asi responde con 'true' caso contrario responde con 'false'.", Double.valueOf(0.1));
        System.out.println(consulta);
        return consulta;
    }

    public void saveFromExcelPiezas(InputStream inputStream) throws Exception {
        XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
        Sheet sheet = workbook.getSheetAt(0);
        Documento inf = (Documento)this.documentoDAO.findById((Object)23L).get();
        ArrayList<SeccionDocumento> seccion = new ArrayList<SeccionDocumento>();
        for (int i = 1; i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            SeccionDocumento documento = new SeccionDocumento();
            documento.setTexto(row.getCell(0).getStringCellValue());
            documento.setEmbedding("");
            documento.setGenerado(Long.valueOf(0L));
            documento.setScore(0.0);
            documento.setDocumento(inf);
            seccion.add(documento);
        }
        this.seccionDocumentoDAO.saveAll(seccion);
        workbook.close();
    }

    public void saveFromExcel(InputStream inputStream) throws Exception {
        XSSFWorkbook workbook = new XSSFWorkbook(inputStream);
        Sheet sheet = workbook.getSheetAt(0);
        Informacion inf = (Informacion)this.informacionDAO.findById((Object)1L).get();
        ArrayList<CaracteristicasQuimicos> quimicos = new ArrayList<CaracteristicasQuimicos>();
        for (int i = 1; i <= sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            CaracteristicasQuimicos quimico = new CaracteristicasQuimicos();
            quimico.setCodigoProducto(row.getCell(0).getStringCellValue());
            quimico.setDescripcion(row.getCell(1).getStringCellValue());
            quimico.setCategoria(row.getCell(2).getStringCellValue());
            quimico.setLinea(row.getCell(3).getStringCellValue());
            quimico.setGrupo(row.getCell(4).getStringCellValue());
            quimico.setMarca(row.getCell(5).getStringCellValue());
            quimico.setKiloLitros(Double.valueOf(row.getCell(6).getNumericCellValue()));
            quimico.setSubMarca(row.getCell(7).getStringCellValue());
            quimico.setTipoMarca(row.getCell(8).getStringCellValue());
            quimico.setCodigoVenta(row.getCell(9).getStringCellValue());
            quimico.setPrecioIva(Double.valueOf(row.getCell(10).getNumericCellValue()));
            quimico.setEstado(row.getCell(11).getStringCellValue());
            quimico.setInformacion(inf);
            quimicos.add(quimico);
        }
        this.caracteristicasQuimicosDAO.saveAll(quimicos);
        workbook.close();
    }
}

