/*
 * Decompiled with CFR 0.152.
 */
package com.agrota.logic.service.impl;

import com.agrota.logic.model.Role;
import com.agrota.logic.model.Usuarios;
import com.agrota.logic.repository.RolesDAO;
import com.agrota.logic.repository.UsuariosDAO;
import com.agrota.logic.service.AuthenticationService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.stereotype.Service;

@Service
public class AutenticationServiceImpl
implements AuthenticationService {
    @Autowired
    UsuariosDAO usuariosDAO;
    @Autowired
    RolesDAO rolesDAO;

    public String getMyParameter(String param) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof JwtAuthenticationToken) {
            Jwt jwt = (Jwt)((JwtAuthenticationToken)authentication).getToken();
            String stringParam = (String)jwt.getClaim(param);
            return stringParam;
        }
        return null;
    }

    public Boolean hasRole(String role) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication instanceof JwtAuthenticationToken) {
            List accountRoles;
            Map account;
            List roles;
            Jwt jwt = (Jwt)((JwtAuthenticationToken)authentication).getToken();
            Map realmAccess = (Map)jwt.getClaim("realm_access");
            if (realmAccess != null && (roles = (List)realmAccess.get("roles")) != null && roles.contains(role)) {
                return true;
            }
            Map resourceAccess = (Map)jwt.getClaim("resource_access");
            if (resourceAccess != null && (account = (Map)resourceAccess.get("account")) != null && (accountRoles = (List)account.get("roles")) != null && accountRoles.contains(role)) {
                return true;
            }
        }
        return false;
    }

    public Usuarios crearUsuario(String nombre_usuario, String rol_usuario) {
        Role rol = (Role)this.rolesDAO.findByDescripcion(rol_usuario).get();
        Usuarios usuario = new Usuarios(null, nombre_usuario, rol);
        return (Usuarios)this.usuariosDAO.save((Object)usuario);
    }
}

