/*
 * Decompiled with CFR 0.152.
 */
package com.agrota.logic.service.impl;

import com.agrota.logic.data.ActualizacionConsumo;
import com.agrota.logic.data.CalificacionConsumo;
import com.agrota.logic.data.Gobernanza;
import com.agrota.logic.data.RolesPreguntas;
import com.agrota.logic.data.TemasConsumo;
import com.agrota.logic.data.UsuariosConsumo;
import com.agrota.logic.model.Actividad;
import com.agrota.logic.repository.ActividadDAO;
import com.agrota.logic.repository.ActualizacionesDAO;
import com.agrota.logic.repository.CalificacionesDAO;
import com.agrota.logic.repository.ConversacionDAO;
import com.agrota.logic.repository.RolesDAO;
import com.agrota.logic.service.ActividadService;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class ActividadServiceImp
implements ActividadService {
    private final ActividadDAO actividadDAO;
    private final ConversacionDAO conversacionDAO;
    private final ActualizacionesDAO actualizacionesDAO;
    private final CalificacionesDAO calificacionesDAO;
    private final RolesDAO rolesDAO;

    public List<TemasConsumo> buscarActividad4Fecha(Date fechaInicial, Date fechaFinal, String rol) {
        return this.actividadDAO.listadoTemasFrecuencia(fechaInicial, fechaFinal, rol);
    }

    public List<Actividad> listadoActividadCarpetas(Long id, Date fecha1, Date fecha2) {
        return this.actividadDAO.listadoActividadCarpetas(id, fecha1, fecha2);
    }

    public Page<Actividad> listadoActividadCarpetasPaginado(Long id, Date fecha1, Date fecha2, int page, int size) {
        PageRequest pageable = PageRequest.of((int)page, (int)size);
        return this.actividadDAO.listadoActividadCarpetasPageable(id, fecha1, fecha2, (Pageable)pageable);
    }

    public List<UsuariosConsumo> listadoUsuarios(Date fecha1, Date fecha2) {
        return this.conversacionDAO.listadoUsuarios(fecha1, fecha2);
    }

    public List<ActualizacionConsumo> listadoActualizaciones(Date fecha1, Date fecha2) {
        return this.actualizacionesDAO.listadoActualizaciones(fecha1, fecha2);
    }

    public List<CalificacionConsumo> listadoCalificacionFrecuencia(Date fecha1, Date fecha2, String rol, Boolean enviado, String calificacion) {
        return this.calificacionesDAO.listadoCalificacionFrecuencia(fecha1, fecha2, rol, enviado, calificacion);
    }

    public List<RolesPreguntas> obtenerNumeroPreguntasRol(Date fecha1, Date fecha2) {
        return this.rolesDAO.obtenerNumeroPreguntasRol(fecha1, fecha2);
    }

    public List<Gobernanza> obtenerGovernanza(Date fecha1, Date fecha2, String rol) {
        long frecuenciaBuena = this.calificacionesDAO.listadoCalificacionFrecuencia(fecha1, fecha2, rol, Boolean.valueOf(true), "BUENA").stream().findFirst().map(CalificacionConsumo::getFrecuencia).orElse(0L);
        long frecuenciaSupervisada = this.calificacionesDAO.listadoCalificacionFrecuencia(fecha1, fecha2, rol, Boolean.valueOf(false), "MALA").stream().findFirst().map(CalificacionConsumo::getFrecuencia).orElse(0L);
        long frecuenciaMala = this.calificacionesDAO.listadoCalificacionFrecuencia(fecha1, fecha2, rol, Boolean.valueOf(true), "MALA").stream().findFirst().map(CalificacionConsumo::getFrecuencia).orElse(0L);
        return Arrays.asList(new Gobernanza(1, "BUENA", Long.valueOf(frecuenciaBuena)), new Gobernanza(2, "SUPERVISADOS", Long.valueOf(frecuenciaSupervisada)), new Gobernanza(3, "MALA", Long.valueOf(frecuenciaMala)));
    }

    public ActividadDAO getActividadDAO() {
        return this.actividadDAO;
    }

    public ConversacionDAO getConversacionDAO() {
        return this.conversacionDAO;
    }

    public ActualizacionesDAO getActualizacionesDAO() {
        return this.actualizacionesDAO;
    }

    public CalificacionesDAO getCalificacionesDAO() {
        return this.calificacionesDAO;
    }

    public RolesDAO getRolesDAO() {
        return this.rolesDAO;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActividadServiceImp)) {
            return false;
        }
        ActividadServiceImp other = (ActividadServiceImp)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ActividadDAO this$actividadDAO = this.getActividadDAO();
        ActividadDAO other$actividadDAO = other.getActividadDAO();
        if (this$actividadDAO == null ? other$actividadDAO != null : !this$actividadDAO.equals(other$actividadDAO)) {
            return false;
        }
        ConversacionDAO this$conversacionDAO = this.getConversacionDAO();
        ConversacionDAO other$conversacionDAO = other.getConversacionDAO();
        if (this$conversacionDAO == null ? other$conversacionDAO != null : !this$conversacionDAO.equals(other$conversacionDAO)) {
            return false;
        }
        ActualizacionesDAO this$actualizacionesDAO = this.getActualizacionesDAO();
        ActualizacionesDAO other$actualizacionesDAO = other.getActualizacionesDAO();
        if (this$actualizacionesDAO == null ? other$actualizacionesDAO != null : !this$actualizacionesDAO.equals(other$actualizacionesDAO)) {
            return false;
        }
        CalificacionesDAO this$calificacionesDAO = this.getCalificacionesDAO();
        CalificacionesDAO other$calificacionesDAO = other.getCalificacionesDAO();
        if (this$calificacionesDAO == null ? other$calificacionesDAO != null : !this$calificacionesDAO.equals(other$calificacionesDAO)) {
            return false;
        }
        RolesDAO this$rolesDAO = this.getRolesDAO();
        RolesDAO other$rolesDAO = other.getRolesDAO();
        return !(this$rolesDAO == null ? other$rolesDAO != null : !this$rolesDAO.equals(other$rolesDAO));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActividadServiceImp;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ActividadDAO $actividadDAO = this.getActividadDAO();
        result = result * 59 + ($actividadDAO == null ? 43 : $actividadDAO.hashCode());
        ConversacionDAO $conversacionDAO = this.getConversacionDAO();
        result = result * 59 + ($conversacionDAO == null ? 43 : $conversacionDAO.hashCode());
        ActualizacionesDAO $actualizacionesDAO = this.getActualizacionesDAO();
        result = result * 59 + ($actualizacionesDAO == null ? 43 : $actualizacionesDAO.hashCode());
        CalificacionesDAO $calificacionesDAO = this.getCalificacionesDAO();
        result = result * 59 + ($calificacionesDAO == null ? 43 : $calificacionesDAO.hashCode());
        RolesDAO $rolesDAO = this.getRolesDAO();
        result = result * 59 + ($rolesDAO == null ? 43 : $rolesDAO.hashCode());
        return result;
    }

    public String toString() {
        return "ActividadServiceImp(actividadDAO=" + this.getActividadDAO() + ", conversacionDAO=" + this.getConversacionDAO() + ", actualizacionesDAO=" + this.getActualizacionesDAO() + ", calificacionesDAO=" + this.getCalificacionesDAO() + ", rolesDAO=" + this.getRolesDAO() + ")";
    }

    public ActividadServiceImp(ActividadDAO actividadDAO, ConversacionDAO conversacionDAO, ActualizacionesDAO actualizacionesDAO, CalificacionesDAO calificacionesDAO, RolesDAO rolesDAO) {
        this.actividadDAO = actividadDAO;
        this.conversacionDAO = conversacionDAO;
        this.actualizacionesDAO = actualizacionesDAO;
        this.calificacionesDAO = calificacionesDAO;
        this.rolesDAO = rolesDAO;
    }
}

