/*
 * Decompiled with CFR 0.152.
 */
package com.agrota.logic.repository;

import com.agrota.logic.dto.ConversacionDetalleDTO;
import com.agrota.logic.model.ConversacionDetalle;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ConversacionDetalleDAO
extends JpaRepository<ConversacionDetalle, Long> {
    @Query(value="select sum(cd.tokens) from ConversacionDetalle cd where cd.fecha >= :fecha1 and cd.fecha <= :fecha2")
    public String obtenerTokens(@Param(value="fecha1") LocalDateTime var1, @Param(value="fecha2") LocalDateTime var2);

    @Query(value="select cd from ConversacionDetalle cd, Carpeta c where cd.conversacion.identificador = :identificador and cd.carpeta.id_carpeta = c.id_carpeta and c.nombre=:carpeta order by cd.idConversacionDetalle DESC limit 4")
    public List<ConversacionDetalle> obtenerConversacion(@Param(value="carpeta") String var1, @Param(value="identificador") String var2);

    @Query(value="select cd from ConversacionDetalle cd, Carpeta c where cd.conversacion.identificador = :identificador and cd.carpeta.id_carpeta = c.id_carpeta and c.nombre=:carpeta order by cd.idConversacionDetalle DESC limit 20")
    public List<ConversacionDetalle> obtenerConversacionCompleta(@Param(value="carpeta") String var1, @Param(value="identificador") String var2);

    @Query(value="select ta.id_actividad as idConversacionDetalle, ta.fecha as fecha, ta.respuesta as mensaje, tr.descripcion as rol, ta.pregunta as pregunta from t_actividad ta , t_conversacion tc, t_usuarios tu , t_roles tr, t_carpeta tca where ta.id_conversacion= tc.id_conversacion and tc.id_usuario=tu.id_usuario and tu.id_roles = tr.id_roles and ta.id_carpeta = tca.id_carpeta and tu.usuario =:usuario and tca.nombre =:carpeta and tc.identificador=:identificador order by ta.id_actividad desc limit 3", nativeQuery=true)
    public List<ConversacionDetalleDTO> obtenerUltimas3Conversacion(@Param(value="usuario") String var1, @Param(value="carpeta") String var2, @Param(value="identificador") String var3);
}

