/*
 * Decompiled with CFR 0.152.
 */
package com.agrota.logic.repository;

import com.agrota.logic.data.UsuariosConsumo;
import com.agrota.logic.model.Conversacion;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ConversacionDAO
extends JpaRepository<Conversacion, Long> {
    public boolean existsByIdentificador(String var1);

    @Query(value="select tr.id_roles AS id, tr.descripcion as rol, count( distinct tc.id_usuario) as usuarios from t_conversacion tc, t_roles tr, t_usuarios tu  where tr.id_roles=tu.id_roles and tu.id_usuario=tc.id_usuario and tc.fecha >= :fecha1 and tc.fecha <= :fecha2 group by  tr.id_roles ORDER BY usuarios desc", nativeQuery=true)
    public List<UsuariosConsumo> listadoUsuarios(@Param(value="fecha1") Date var1, @Param(value="fecha2") Date var2);

    @Query(value="SELECT cv.idConversacion FROM Conversacion cv JOIN cv.usuarios u WHERE u.usuario = :user order by cv.idConversacion desc limit 1")
    public Optional<Long> findIdConversationByUser(String var1);

    public Optional<Conversacion> findByIdentificador(String var1);

    @Query(value="SELECT c FROM Conversacion c, Usuarios u WHERE c.usuarios.id_usuario = u.id_usuario and u.usuario = :usuario order by c.idConversacion desc limit 1")
    public List<Conversacion> obtenerUltimaConversacion(String var1);

    @Query(value="SELECT c FROM Conversacion c, Usuarios u, Actividad a, Carpeta ca WHERE c.usuarios.id_usuario = u.id_usuario and u.usuario = :usuario and a.id_conversacion.idConversacion = c.idConversacion and a.carpetas.id_carpeta = ca.id_carpeta and ca.nombre=:nombre_carpeta order by c.idConversacion desc limit 1")
    public List<Conversacion> obtenerUltimaConversacionCliente(String var1, String var2);
}

