/*
 * Decompiled with CFR 0.152.
 */
package com.agrota.logic.repository;

import com.agrota.logic.data.CalificacionConsumo;
import com.agrota.logic.data.CalificacionesUsuarios;
import com.agrota.logic.model.Calificacion;
import java.util.Date;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface CalificacionesDAO
extends JpaRepository<Calificacion, Long> {
    @Query(value="select tca.calificacion_actualizada as calificacion , COUNT(tca.*) AS frecuencia, ROW_NUMBER() OVER(ORDER BY COUNT(tca.calificacion)) AS id from t_calificacion tca, t_conversacion tco, t_roles tr where tca.id_conversacion = tco.id_conversacion and tco.id_roles = tr.id_roles and tr.descripcion like :rol and tca.fecha >= :fecha1 and tca.fecha <= :fecha2 and tca.enviado = :enviado and calificacion_actualizada like CONCAT('%', :calificacion, '%') GROUP BY tca.calificacion_actualizada HAVING COUNT(*) > 1 ORDER BY frecuencia asc", nativeQuery=true)
    public List<CalificacionConsumo> listadoCalificacionFrecuencia(@Param(value="fecha1") Date var1, @Param(value="fecha2") Date var2, @Param(value="rol") String var3, @Param(value="enviado") Boolean var4, @Param(value="calificacion") String var5);

    @Query(value="select new com.agrota.logic.data.CalificacionesUsuarios(c.id_calificacion, c.calificacion, c.fecha, c.pregunta, c.respuesta, c.respuesta_esperada, c.enviado, c.calificacion_actualizada, u.usuario) from Calificacion c, Conversacion cv, Usuarios u where c.id_conversacion.idConversacion = cv.idConversacion and cv.usuarios.id_usuario = u.id_usuario and c.calificacion like '%MALA%' and c.fecha >= :fecha1 and c.fecha <= :fecha2 order by c.fecha DESC")
    public List<CalificacionesUsuarios> listadoCalificacionRespuestasMalas(@Param(value="fecha1") Date var1, @Param(value="fecha2") Date var2);
}

