/*
 * Decompiled with CFR 0.152.
 */
package com.agrota.logic.repository;

import com.agrota.logic.data.TemasConsumo;
import com.agrota.logic.model.Actividad;
import java.util.Date;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface ActividadDAO
extends JpaRepository<Actividad, Long> {
    @Query(value="SELECT tc.*, count(ta.id_carpeta) as total_pregunta, max(ta.fecha) as fecha_ultima_consulta FROM t_conversacion tc2, t_usuarios tu, t_roles tr,t_carpeta tc LEFT JOIN t_actividad ta ON ta.id_carpeta = tc.id_carpeta where  ta.id_conversacion = tc2.id_conversacion and tr.id_roles = tu.id_roles and tu.id_usuario= tc2.id_usuario and tr.descripcion = :rol AND ta.fecha >= :fecha1 and ta.fecha <= :fecha2 AND tu.usuario <> 'dcoronel' AND tu.usuario <> 'gaby.agrota' and tc.id_carpeta not in (5) AND LOWER(ta.respuesta) NOT LIKE '%hola soy%' AND LOWER(ta.pregunta) <> 'hola' GROUP BY tc.id_carpeta ORDER BY tc.id_carpeta", nativeQuery=true)
    public List<TemasConsumo> listadoTemasFrecuencia(@Param(value="fecha1") Date var1, @Param(value="fecha2") Date var2, @Param(value="rol") String var3);

    @Query(value="select a from Actividad a, Conversacion c, Usuarios u where a.id_conversacion.idConversacion = c.idConversacion and c.usuarios.id_usuario = u.id_usuario and u.roles.id = 1 and a.carpetas.id_carpeta =:id and a.fecha >= :fecha1 and a.fecha <= :fecha2 AND u.usuario <> 'dcoronel' AND u.usuario <> 'gaby.agrota' AND LOWER(a.texto_respuesta) NOT LIKE '%hola soy%' AND LOWER(a.texto_pregunta) <> 'hola' order by a.id_actividad DESC")
    public List<Actividad> listadoActividadCarpetas(@Param(value="id") Long var1, @Param(value="fecha1") Date var2, @Param(value="fecha2") Date var3);

    @Query(value="select a from Actividad a, Conversacion c, Usuarios u where a.id_conversacion.idConversacion = c.idConversacion and c.usuarios.id_usuario = u.id_usuario and u.roles.id = 1 and a.carpetas.id_carpeta =:id and a.fecha >= :fecha1 and a.fecha <= :fecha2 AND u.usuario <> 'dcoronel' AND u.usuario <> 'gaby.agrota' AND LOWER(a.texto_respuesta) NOT LIKE '%hola soy%' AND LOWER(a.texto_pregunta) <> 'hola' order by a.id_actividad DESC")
    public Page<Actividad> listadoActividadCarpetasPageable(@Param(value="id") Long var1, @Param(value="fecha1") Date var2, @Param(value="fecha2") Date var3, Pageable var4);

    @Query(value="select a from Actividad a, Conversacion c where a.id_conversacion.idConversacion = c.idConversacion and c.identificador = :identificador order by a.id_actividad desc limit 2")
    public List<Actividad> historial(@Param(value="identificador") String var1);
}

