/*
 * Decompiled with CFR 0.152.
 */
package com.agrota.logic.controller;

import com.agrota.logic.data.CalificacionConsumo;
import com.agrota.logic.data.Gobernanza;
import com.agrota.logic.model.Calificacion;
import com.agrota.logic.service.ActividadService;
import com.agrota.logic.service.BaseService;
import com.agrota.logic.service.ClienteService;
import com.agrota.logic.service.DocumentosEntrenadosService;
import com.agrota.logic.service.GovernanzaService;
import com.agrota.utils.DateTimeUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dashboard-report"})
@CrossOrigin(value={"*"})
public class ReportDashboardController {
    @Autowired
    private final ActividadService actividadService;
    private final GovernanzaService governanzaService;
    private final BaseService serincoRepository;
    private final ClienteService clienteService;
    private final DocumentosEntrenadosService documentosEntrenadosService;

    @PostMapping(value={"/calificaciones"}, produces={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public List<CalificacionConsumo> listadoCalificacionFrecuencia(@RequestParam Date fecha1, Date fecha2, String rol) {
        return this.actividadService.listadoCalificacionFrecuencia(fecha1, fecha2, rol, Boolean.valueOf(true), "");
    }

    @PostMapping(value={"/calificaciones_malas"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public List<?> getQuestionsToQualify(@RequestParam Date fecha1, @RequestParam Date fecha2) {
        return this.governanzaService.obtenerCalificacionesRespuestasMalas(fecha1, fecha2);
    }

    @PostMapping(value={"/calificaciones_malas/envio"}, produces={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public ResponseEntity<Calificacion> obtenerCalificacionesMalas(@RequestParam Long id, String nueva_respuesta_esperada) {
        return this.governanzaService.actualizarEnviadoCalificacionesMalas(id, nueva_respuesta_esperada);
    }

    @PostMapping(value={"/actualizaciones"})
    public List<?> getActualizacionesDocumentos(@RequestParam String fecha1, @RequestParam String fecha2) {
        Date fechaInicial = DateTimeUtil.StringToDate((String)fecha1);
        Date fechaFin = DateTimeUtil.StringToDate((String)fecha2);
        return this.actividadService.listadoActualizaciones(fechaInicial, fechaFin);
    }

    @PostMapping(value={"/gobernanza"}, produces={"application/json"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    public List<Gobernanza> obtenerGovernanza(@RequestParam Date fecha1, Date fecha2, String rol) {
        return this.actividadService.obtenerGovernanza(fecha1, fecha2, rol);
    }

    @PostMapping(value={"/temas"})
    public List<?> getTemas(@RequestParam String fecha1, @RequestParam String fecha2, @RequestParam String rol) {
        Date fechaInicial = DateTimeUtil.StringToDate((String)fecha1);
        Date fechaFin = DateTimeUtil.StringToDate((String)fecha2);
        return this.actividadService.buscarActividad4Fecha(fechaInicial, fechaFin, rol);
    }

    @PostMapping(value={"/preguntas"})
    public List<?> getTematicasConsultadas(@RequestParam Long id, @RequestParam String fecha1, @RequestParam String fecha2) {
        Date fechaInicial = DateTimeUtil.StringToDate((String)fecha1);
        Date fechaFin = DateTimeUtil.StringToDate((String)fecha2);
        return this.actividadService.listadoActividadCarpetas(id, fechaInicial, fechaFin);
    }

    @PostMapping(value={"/preguntas/paginado"}, consumes={"application/x-www-form-urlencoded"})
    public Page<?> getTematicasConsultadaspaginado(@RequestParam Long id, String fecha1, String fecha2, int pagina, int filas) {
        Date fechaInicial = DateTimeUtil.StringToDate((String)fecha1);
        Date fechaFin = DateTimeUtil.StringToDate((String)fecha2);
        System.out.println(this.actividadService.listadoActividadCarpetasPaginado(Long.valueOf(1L), fechaInicial, fechaFin, pagina, filas));
        return this.actividadService.listadoActividadCarpetasPaginado(id, fechaInicial, fechaFin, pagina, filas);
    }

    @PostMapping(value={"/rol/usuarios"})
    public List<?> peopleUsingLhia(@RequestParam String fecha1, @RequestParam String fecha2) {
        Date fechaInicial = DateTimeUtil.StringToDate((String)fecha1);
        Date fechaFin = DateTimeUtil.StringToDate((String)fecha2);
        return this.actividadService.listadoUsuarios(fechaInicial, fechaFin);
    }

    @PostMapping(value={"/rol/total_preguntas"})
    public List<?> uso4rolLhia(@RequestParam String fecha1, @RequestParam String fecha2) {
        Date fechaInicial = DateTimeUtil.StringToDate((String)fecha1);
        Date fechaFin = DateTimeUtil.StringToDate((String)fecha2);
        return this.actividadService.obtenerNumeroPreguntasRol(fechaInicial, fechaFin);
    }

    @PostMapping(value={"/conversacion/tokens"}, produces={"application/json"})
    public int obtenerTokens(@RequestParam String fecha1, String fecha2) {
        System.out.println("fecha1: " + fecha1 + " fecha2: " + fecha2);
        return this.serincoRepository.obtenerTokens(DateTimeUtil.parseStringToLocalDateTime((String)fecha1), DateTimeUtil.parseStringToLocalDateTime((String)fecha2));
    }

    @PostMapping(value={"/documentos/datosEntrenados"}, produces={"application/json"})
    public List<?> datosEntrenados() {
        return this.documentosEntrenadosService.getDocumentosEntrenados();
    }

    @PostMapping(value={"/empleadosAgrota"}, produces={"application/json"})
    public List<?> consultarUsuarios() {
        return this.clienteService.consultarUsuarios();
    }

    public ReportDashboardController(ActividadService actividadService, GovernanzaService governanzaService, BaseService serincoRepository, ClienteService clienteService, DocumentosEntrenadosService documentosEntrenadosService) {
        this.actividadService = actividadService;
        this.governanzaService = governanzaService;
        this.serincoRepository = serincoRepository;
        this.clienteService = clienteService;
        this.documentosEntrenadosService = documentosEntrenadosService;
    }
}

