/*
 * Decompiled with CFR 0.152.
 */
package com.agrota.logic.controller;

import com.agrota.logic.data.ClienteConsumo;
import com.agrota.logic.data.RespuestaRobot;
import com.agrota.logic.model.Usuarios;
import com.agrota.logic.repository.DocumentoDAO;
import com.agrota.logic.repository.SeccionDocumentoDAO;
import com.agrota.logic.repository.UsuarioGestionDAO;
import com.agrota.logic.service.AuthenticationService;
import com.agrota.logic.service.BaseService;
import com.agrota.logic.service.ClienteService;
import com.agrota.logic.service.GovernanzaService;
import com.agrota.logic.service.MilvusService;
import com.agrota.logic.service.SeccionDocumentoService;
import com.agrota.logic.service.TestService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"agrota"})
public class ProductController {
    private static final Logger log = LoggerFactory.getLogger(ProductController.class);
    @Autowired
    private BaseService agrotaRepository;
    @Autowired
    private SeccionDocumentoService seccionDocumentoService;
    @Autowired
    private GovernanzaService governanzaService;
    @Autowired
    private TestService testService;
    @Autowired
    private ClienteService clienteService;
    @Autowired
    private AuthenticationService authenticationService;
    @Autowired
    private SeccionDocumentoDAO seccionDocumentoDAO;
    @Autowired
    private DocumentoDAO documentoDAO;
    @Autowired
    private UsuarioGestionDAO usuarioGestionDAO;
    @Autowired
    private MilvusService milvusService;
    private final String carpetaTxts = "/Users/juancaisapanta/NetBeansProjects/JavaApplication1/maquinaria_articulos.json";

    @PostMapping(value={"/servicio/calificacion"}, consumes={"application/x-www-form-urlencoded"})
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"})
    @PreAuthorize(value="hasRole('user')")
    public ResponseEntity<?> guardarCalificacion(@RequestParam String usuario, @RequestParam String calificacion, @RequestParam String pregunta, @RequestParam String respuesta, @RequestParam String respuestaEsperada) {
        return this.governanzaService.guardarCalificacion(usuario, calificacion, pregunta, respuesta, respuestaEsperada);
    }

    @PostMapping(value={"/questionV3"}, consumes={"application/json; charset=UTF-8"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('user')")
    public RespuestaRobot getProductMilvus(@RequestBody ClienteConsumo cliente) throws Exception {
        log.info("request {}", (Object)cliente);
        RespuestaRobot robot = new RespuestaRobot();
        String answer = this.agrotaRepository.preguntaMilvus(cliente.getQuestion(), cliente.getTipo(), cliente.getUsuario(), cliente.getIdentificador());
        robot.setRespuesta(answer);
        System.out.println("response");
        return robot;
    }

    @PostMapping(value={"/questionCliente"}, consumes={"application/json; charset=UTF-8"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('user')")
    public RespuestaRobot getProductCLiente(@RequestBody ClienteConsumo cliente) throws Exception {
        RespuestaRobot robot = new RespuestaRobot();
        String answer = this.clienteService.preguntaCliente(cliente.getQuestion(), cliente.getUsuario(), cliente.getIdentificador());
        robot.setRespuesta(answer);
        System.out.println("response");
        return robot;
    }

    @PostMapping(value={"/questionPedido"}, consumes={"application/json; charset=UTF-8"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('user')")
    public RespuestaRobot getProductPedido(@RequestBody ClienteConsumo cliente) throws Exception {
        RespuestaRobot robot = new RespuestaRobot();
        String answer = this.clienteService.preguntaClientePedido(cliente.getQuestion(), cliente.getUsuario(), cliente.getIdentificador());
        robot.setRespuesta(answer);
        System.out.println("response");
        return robot;
    }

    @PostMapping(value={"/questionDirMaquinaria"}, consumes={"application/json; charset=UTF-8"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('user')")
    public RespuestaRobot getDireccionMaquinaria(@RequestBody ClienteConsumo cliente) throws Exception {
        RespuestaRobot robot = new RespuestaRobot();
        String answer = this.clienteService.preguntaDireccionesMaquinarias(cliente.getQuestion(), cliente.getUsuario(), cliente.getIdentificador(), cliente.getDescripcion());
        robot.setRespuesta(answer);
        System.out.println("response");
        return robot;
    }

    @PostMapping(value={"/questionDirAgricola"}, consumes={"application/json; charset=UTF-8"})
    @CrossOrigin
    @PreAuthorize(value="hasRole('user')")
    public RespuestaRobot getDireccionAgricola(@RequestBody ClienteConsumo cliente) throws Exception {
        RespuestaRobot robot = new RespuestaRobot();
        String answer = this.clienteService.preguntaDireccionesQuimicos(cliente.getQuestion(), cliente.getUsuario(), cliente.getIdentificador(), cliente.getDescripcion());
        robot.setRespuesta(answer);
        System.out.println("response");
        return robot;
    }

    @PostMapping(value={"/crear_usuario"}, consumes={"application/x-www-form-urlencoded"})
    @CrossOrigin
    public Usuarios crearUsuario(@RequestParam String nombre_usuario, String rol) throws Exception {
        return this.authenticationService.crearUsuario(nombre_usuario, rol);
    }

    @GetMapping(value={"/generaEmb"})
    @CrossOrigin
    public void generaEmb() {
        this.seccionDocumentoService.generateEmbeddingsForSections();
    }

    @GetMapping(value={"/generaNumTokens"})
    @CrossOrigin
    public void generaNumTokens() {
        this.agrotaRepository.generateNumTokens();
    }

    @PostMapping(value={"/upload"})
    public List<Usuarios> leerYGuardarTxts() {
        return this.usuarioGestionDAO.obtenerUsuariosGestionadosPorNombre("sroman");
    }

    @PostMapping(value={"/pedidos"})
    public void subirPedidos() {
        this.milvusService.resetAndRebuildGlobal();
    }
}

