/*
 * Decompiled with CFR 0.152.
 */
package com.agrota.logic.controller;

import com.agrota.logic.model.Informacion;
import com.agrota.logic.service.EntrenamientoService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"entrenamiento"})
@CrossOrigin(origins={"*"})
public class EntrenamientoController {
    private static final Logger log = LoggerFactory.getLogger(EntrenamientoController.class);
    @Autowired
    private EntrenamientoService entrenamientoService;

    @PostMapping(value={"/upload"})
    public ResponseEntity<String> uploadFile(@RequestParam(value="file") MultipartFile file) {
        try {
            this.entrenamientoService.saveFromExcelInformacionQuimicos(file.getInputStream());
            return ResponseEntity.ok((Object)"Datos subidos correctamente.");
        }
        catch (Exception e) {
            return ResponseEntity.status((int)500).body((Object)("Error al subir archivo: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/obtener_entrenamientos"})
    public List<Informacion> obtenerEntrenamientos() {
        return this.entrenamientoService.obtenerEntrenamientos();
    }

    @PostMapping(value={"/actualizar_entrenamientos"}, consumes={"application/x-www-form-urlencoded"})
    public Informacion actualizarEntrenamiento(@RequestParam Long id) {
        return this.entrenamientoService.actualizarEntrenamiento(id);
    }
}

