/*
 * Decompiled with CFR 0.152.
 */
package com.agrota.logic.controller;

import com.agrota.logic.data.TDispositivos;
import com.agrota.logic.dto.DispositivoDTO;
import com.agrota.logic.model.ViewAccesosDispositivos;
import com.agrota.logic.service.DispositivoService;
import com.agrota.logic.service.impl.DispositivoServiceImpl;
import com.agrota.utils.DateTimeUtil;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"dispositivo"})
@CrossOrigin(value={"*"})
public class DispositivoController {
    private static final Logger log = LoggerFactory.getLogger(DispositivoController.class);
    private final DispositivoService dispositivoService;
    private final DispositivoServiceImpl dispositivoServiceImp;

    @PostMapping(value={"/validar"})
    public Long validarDispositivo(@RequestParam String identificador, @RequestParam String imei, @RequestParam String device, @RequestParam String usuario) {
        log.info("Informacion entrante del dispositivo {}, {}, {}, {}", new Object[]{identificador, imei, device, usuario});
        if ("testAgrota".equalsIgnoreCase(usuario)) {
            log.info("El usuario {} tiene acceso sin restricciones, sin importar el dispositivo", (Object)usuario);
            return 1L;
        }
        return this.dispositivoService.validarDispositivo(imei, device, identificador, usuario);
    }

    @PostMapping(value={"/dispositivosActivos"})
    public Page<TDispositivos> listadodeDispositivosactivos(@RequestParam int page, @RequestParam int size) {
        return this.dispositivoService.listadodeDispositivosactivos(page, size);
    }

    @PostMapping(value={"/accesosDispositivos"})
    public Page<ViewAccesosDispositivos> listadodeAccesos(@RequestParam String fecha1, @RequestParam String fecha2, @RequestParam int page, @RequestParam int size) {
        LocalDateTime fechaInicial = DateTimeUtil.parseStringToLocalDateTime((String)fecha1);
        LocalDateTime fechaFin = DateTimeUtil.parseStringToLocalDateTime((String)fecha2);
        return this.dispositivoService.listadodeAccesos(fechaInicial, fechaFin, page, size);
    }

    @PutMapping(value={"/activacionDispositivo/{identificador}"})
    public ResponseEntity<TDispositivos> ActivoDesactivo(@PathVariable String identificador) {
        TDispositivos dispositivos = this.dispositivoService.activoDesactivo(identificador);
        return ResponseEntity.ok((Object)dispositivos);
    }

    @PostMapping(value={"/aceptar"})
    public ResponseEntity<String> aceptarDispositivo(@RequestBody DispositivoDTO accesosDispositivos) {
        log.info("aceptar {}", (Object)accesosDispositivos);
        try {
            this.dispositivoServiceImp.aceptarAcceso(accesosDispositivos);
            return ResponseEntity.ok((Object)"Dispositivo guardado satisfactoriamente");
        }
        catch (IllegalArgumentException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CONFLICT).body((Object)e.getMessage());
        }
    }

    @PostMapping(value={"/estado"})
    public Page<TDispositivos> obtenerDispositivosPorEstado(@RequestParam int page, @RequestParam int size, @RequestParam Boolean activo) {
        return this.dispositivoServiceImp.obtenerDispositivosPorEstado(page, size, activo);
    }

    @PostMapping(value={"/buscarUser"})
    public ResponseEntity<?> getByUsuario(@RequestParam String usuario) {
        List dispositivoDTO = this.dispositivoService.findByUsuario(usuario);
        return new ResponseEntity((Object)dispositivoDTO, (HttpStatusCode)HttpStatus.OK);
    }

    public DispositivoController(DispositivoService dispositivoService, DispositivoServiceImpl dispositivoServiceImp) {
        this.dispositivoService = dispositivoService;
        this.dispositivoServiceImp = dispositivoServiceImp;
    }
}

