/*
 * Decompiled with CFR 0.152.
 */
package com.agrota.logic.controller;

import com.agrota.logic.dto.ConversacionDetalleDTO;
import com.agrota.logic.service.ConversacionService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"agrota/conversacion"})
public class ConversacionController {
    private final ConversacionService conversacionService;

    @PostMapping(value={"/ultimas3"})
    public List<ConversacionDetalleDTO> obtenerTokens(@RequestParam String usuario, @RequestParam String carpeta) {
        System.out.println("Obteniendo las ultimas 3 conversaciones");
        return this.conversacionService.obtenerUltimas3Conversaciones(usuario, carpeta);
    }

    @PostMapping(value={"/identificadorUltimaConversacion"})
    public Map<String, String> obtenerUltimaConversacion(@RequestParam String usuario) {
        System.out.println(this.conversacionService.obtenerUltimaConversacion(usuario).getIdentificador());
        String identificador = this.conversacionService.obtenerUltimaConversacion(usuario).getIdentificador();
        HashMap<String, String> response = new HashMap<String, String>();
        response.put("identificador", identificador);
        return response;
    }

    public ConversacionService getConversacionService() {
        return this.conversacionService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConversacionController)) {
            return false;
        }
        ConversacionController other = (ConversacionController)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        ConversacionService this$conversacionService = this.getConversacionService();
        ConversacionService other$conversacionService = other.getConversacionService();
        return !(this$conversacionService == null ? other$conversacionService != null : !this$conversacionService.equals(other$conversacionService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConversacionController;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConversacionService $conversacionService = this.getConversacionService();
        result = result * 59 + ($conversacionService == null ? 43 : $conversacionService.hashCode());
        return result;
    }

    public String toString() {
        return "ConversacionController(conversacionService=" + this.getConversacionService() + ")";
    }

    public ConversacionController(ConversacionService conversacionService) {
        this.conversacionService = conversacionService;
    }
}

