/*
 * Decompiled with CFR 0.152.
 */
package com.agrota.logic.controller;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"complements"})
public class ComplementsController {
    private static final String BASE_DIR = "/url";

    @GetMapping(value={"/{nombreImagen}"})
    public ResponseEntity<Resource> getImage(@PathVariable String nombreImagen) throws IOException {
        Path imagePath = Paths.get(BASE_DIR, new String[0]).resolve(nombreImagen);
        UrlResource resource = new UrlResource(imagePath.toUri());
        if (resource.exists() && resource.isReadable()) {
            HttpHeaders headers = new HttpHeaders();
            String[] filenameParts = nombreImagen.split("\\.");
            if (filenameParts.length > 1) {
                String fileExtension = filenameParts[filenameParts.length - 1].toLowerCase();
                HashMap<String, MediaType> extensionToMediaType = new HashMap<String, MediaType>();
                extensionToMediaType.put("jpg", MediaType.IMAGE_JPEG);
                extensionToMediaType.put("jpeg", MediaType.IMAGE_JPEG);
                extensionToMediaType.put("png", MediaType.IMAGE_PNG);
                extensionToMediaType.put("gif", MediaType.IMAGE_GIF);
                MediaType mediaType = extensionToMediaType.getOrDefault(fileExtension, MediaType.APPLICATION_OCTET_STREAM);
                headers.setContentType(mediaType);
            } else {
                headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().headers(headers)).body((Object)resource);
        }
        return ResponseEntity.notFound().build();
    }
}

