/*
 * Decompiled with CFR 0.152.
 */
package com.agrota.auth;

import com.agrota.auth.AuthAccessDeniedHandler;
import com.agrota.auth.CustomAuthenticationEntryPoint;
import com.agrota.auth.JwtAuthConverter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;

@Configuration
@EnableWebSecurity
public class WebSecurityConfig {
    public static final String ADMIN = "admin";
    public static final String USER = "user";
    private final JwtAuthConverter jwtAuthConverter;

    public WebSecurityConfig(JwtAuthConverter jwtAuthConverter) {
        this.jwtAuthConverter = jwtAuthConverter;
    }

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)http.authorizeHttpRequests().requestMatchers(HttpMethod.GET, new String[]{"/ja/anonimo/**"})).permitAll().requestMatchers(HttpMethod.POST, new String[]{"/dispositivo/validar"})).permitAll().requestMatchers(HttpMethod.POST, new String[]{"/dispositivo/accesosDispositivos"})).permitAll().requestMatchers(HttpMethod.POST, new String[]{"/dispositivo/dispositivosActivos"})).permitAll().requestMatchers(HttpMethod.POST, new String[]{"/agrota/upload"})).permitAll().requestMatchers(HttpMethod.POST, new String[]{"/agrota/pedidos"})).permitAll().requestMatchers(HttpMethod.POST, new String[]{"/entrenamiento/*"})).permitAll().requestMatchers(HttpMethod.POST, new String[]{"/agrota/crear_usuario"})).permitAll().requestMatchers(HttpMethod.PUT, new String[]{"/dispositivo/activacionDispositivo/{identificador}"})).permitAll().requestMatchers(HttpMethod.POST, new String[]{"/dispositivo/aceptar"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/ja/user"})).hasAnyRole(new String[]{ADMIN, USER}).requestMatchers(HttpMethod.GET, new String[]{"/ja/admin"})).hasRole(ADMIN).requestMatchers(HttpMethod.POST, new String[]{"/dashboard-report/**"})).permitAll().requestMatchers(HttpMethod.GET, new String[]{"/complements/**"})).permitAll().anyRequest()).authenticated();
        http.exceptionHandling().authenticationEntryPoint((AuthenticationEntryPoint)new CustomAuthenticationEntryPoint());
        http.exceptionHandling().accessDeniedHandler((AccessDeniedHandler)new AuthAccessDeniedHandler());
        http.oauth2ResourceServer().jwt().jwtAuthenticationConverter((Converter)this.jwtAuthConverter);
        http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        ((HttpSecurity)http.cors().and()).csrf().disable();
        return (SecurityFilterChain)http.build();
    }
}

