/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.utils;

import com.tws2.firma_s.logic.model.TCallbackBiometria;
import com.tws2.firma_s.logic.model.TSolicitud;
import com.tws2.firma_s.logic.model.TUsuario;
import com.tws2.firma_s.logic.model.biometria.TDataBiometria;
import com.tws2.firma_s.logic.model.biometria.TErrorMessage;
import com.tws2.firma_s.logic.model.biometria.TImageData;
import com.tws2.firma_s.logic.model.biometria.TIndicadorSeccion;
import com.tws2.firma_s.logic.model.biometria.TIndicadores;
import com.tws2.firma_s.logic.model.biometria.TMetadata;
import com.tws2.firma_s.logic.model.biometria.TProcesado;
import com.tws2.firma_s.logic.model.biometria.TResultData;
import ec.tws2.crypto.run.CryptoMain;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DecriptUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DecriptUtils.class);
    private final CryptoMain cryptoService;

    public TCallbackBiometria encriptando(TCallbackBiometria callback) {
        try {
            if (callback.getData() != null) {
                TDataBiometria data = callback.getData();
                data.setCallback(callback);
                data.setFrontAttempt(callback.getData().getFrontAttempt());
                data.setBackAttempt(callback.getData().getBackAttempt());
                data.setSelfieAttempt(callback.getData().getSelfieAttempt());
                data.setImageData(callback.getData().getImageData());
                if (data.getImageData() != null) {
                    for (TImageData image : data.getImageData()) {
                        image.setDataBiometria(data);
                        image.setImage(image.getImage());
                        image.setType(image.getType());
                    }
                }
            }
            if (callback.getErrorMessage() != null) {
                TErrorMessage err = callback.getErrorMessage();
                err.setCallback(callback);
                err.setError(err.getError());
            }
            if (callback.getIndicator() != null) {
                TIndicadores indicadores = callback.getIndicator();
                indicadores.setCallback(callback);
                indicadores.setConfidence(callback.getConfidence());
                if (indicadores.getFront() != null) {
                    TIndicadorSeccion front = indicadores.getFront();
                    front.setIndicator(indicadores);
                    front.setMetadata(front.getMetadata());
                    front.setFingerCode(front.getFingerCode());
                    front.setIdentificationNumber(front.getIdentificationNumber());
                }
                if (indicadores.getBack() != null) {
                    TIndicadorSeccion back = indicadores.getBack();
                    back.setIndicator(indicadores);
                    back.setMetadata(back.getMetadata());
                    back.setFingerCode(back.getFingerCode());
                    back.setIdentificationNumber(back.getIdentificationNumber());
                }
                if (indicadores.getMetadata() != null) {
                    TMetadata metadata = indicadores.getMetadata();
                    metadata.setIndicadores(indicadores);
                    if (metadata.getProcessed() != null) {
                        TProcesado proc = metadata.getProcessed();
                        proc.setMetadata(metadata);
                        proc.setIdentificationNumber(metadata.getProcessed().getIdentificationNumber());
                        proc.setFullName(this.encrypt(metadata.getProcessed().getFullName()));
                        proc.setFingerCode(this.encrypt(metadata.getProcessed().getFingerCode()));
                        proc.setExpirationDate(metadata.getProcessed().getExpirationDate());
                        proc.setExpeditionDate(metadata.getProcessed().getExpeditionDate());
                        proc.setCurrentDate(metadata.getProcessed().getCurrentDate());
                        proc.setCurrentAge(metadata.getProcessed().getCurrentAge());
                        proc.setBirthPlace(metadata.getProcessed().getBirthPlace());
                        proc.setBirthDate(metadata.getProcessed().getBirthDate());
                    }
                    if (metadata.getResult() != null) {
                        TResultData result = metadata.getResult();
                        result.setMetadata(metadata);
                        result.setCertificate(metadata.getResult().getCertificate());
                        result.setPassword(this.encrypt(metadata.getResult().getPassword()));
                    }
                }
            }
        }
        catch (Exception e) {
            log.warn("ERROR AL ENCRIPTAR LA INFORMACI\u00d3N DE CALLBACK", (Throwable)e);
        }
        return callback;
    }

    public String decrypt(String decryptData) {
        try {
            decryptData = this.cryptoService.decrypt(decryptData);
        }
        catch (Exception e) {
            log.info("no se ha encriptado nada" + e.getMessage());
        }
        return decryptData;
    }

    public String encrypt(String encryptValue) {
        try {
            encryptValue = this.cryptoService.encriptar(encryptValue);
        }
        catch (Exception e) {
            log.info("no se ha encriptado nada" + e.getMessage());
        }
        return encryptValue;
    }

    public TSolicitud encryptSolicitud(TSolicitud sn) {
        TSolicitud se = new TSolicitud();
        se.setOrigen(sn.getOrigen());
        se.setCanal(sn.getCanal());
        se.setCellphoneNumber(this.encrypt(sn.getCellphoneNumber()));
        se.setCallbackUrl(this.encrypt(sn.getCallbackUrl()));
        se.setReferenceTransaction(sn.getReferenceTransaction());
        se.setAddress(this.encrypt(sn.getAddress()));
        se.setCity(this.encrypt(sn.getCity()));
        se.setEmail(this.encrypt(sn.getEmail()));
        se.setFingerCode(this.encrypt(sn.getFingerCode()));
        se.setIdentificationNumber(this.encrypt(sn.getIdentificationNumber()));
        se.setMotivo(this.encrypt(sn.getMotivo()));
        se.setValidationLinkLifeTime(sn.getValidationLinkLifeTime());
        se.setNombresCompletos(this.encrypt(sn.getNombresCompletos()));
        return se;
    }

    public TUsuario encryptUsuario(TUsuario us) {
        TUsuario se = new TUsuario();
        se.setNombres(this.encrypt(us.getNombres()));
        se.setApellidoPaterno(this.encrypt(us.getApellidoPaterno()));
        se.setApellidoMaterno(this.encrypt(us.getApellidoMaterno()));
        se.setCodigoDactilar(this.encrypt(us.getCodigoDactilar()));
        se.setTelefono(this.encrypt(us.getTelefono()));
        se.setCiudad(this.encrypt(us.getCiudad()));
        se.setDireccion(this.encrypt(us.getDireccion()));
        se.setEmail(this.encrypt(us.getEmail()));
        se.setIdentificacion(this.encrypt(us.getIdentificacion()));
        se.setUsername(this.encrypt(us.getUsername()));
        return se;
    }

    public TUsuario decryptUsuario(TUsuario us) {
        TUsuario se = new TUsuario();
        se.setNombres(this.decrypt(us.getNombres()));
        se.setApellidoPaterno(this.decrypt(us.getApellidoPaterno()));
        se.setApellidoMaterno(this.decrypt(us.getApellidoMaterno()));
        se.setCodigoDactilar(this.decrypt(us.getCodigoDactilar()));
        se.setTelefono(this.decrypt(us.getTelefono()));
        se.setCiudad(this.decrypt(us.getCiudad()));
        se.setDireccion(this.decrypt(us.getDireccion()));
        se.setEmail(this.decrypt(us.getEmail()));
        se.setIdentificacion(this.decrypt(us.getIdentificacion()));
        se.setUsername(this.encrypt(us.getUsername()));
        return se;
    }

    @Generated
    public DecriptUtils(CryptoMain cryptoService) {
        this.cryptoService = cryptoService;
    }
}

