/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.service.impl;

import com.tws2.firma_s.logic.model.dashboard.MetricaDiariaDTO;
import com.tws2.firma_s.logic.model.dashboard.MetricaMensualDTO;
import com.tws2.firma_s.logic.repository.DocumentoMetricaDAO;
import com.tws2.firma_s.logic.service.TrasabilidadService;
import java.time.LocalDateTime;
import java.time.YearMonth;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class TrasabilidadServiceImpl
implements TrasabilidadService {
    private final DocumentoMetricaDAO metricsDAO;

    public List<MetricaMensualDTO> metricasMensuales(int year) {
        LocalDateTime inicio = LocalDateTime.of(year, 1, 1, 0, 0);
        LocalDateTime fin = LocalDateTime.of(year, 12, 31, 23, 59, 59);
        return this.metricsDAO.obtenerMetricasMensuales(inicio, fin).stream().map(p -> new MetricaMensualDTO(LocalDateTime.of((int)p.getYear(), p.getMonth(), 1, 0, 0), p.getFirmados().longValue(), p.getNoFirmados().longValue())).toList();
    }

    public List<MetricaDiariaDTO> metricasDiarias(int year, int month) {
        LocalDateTime inicio = LocalDateTime.of(year, month, 1, 0, 0);
        LocalDateTime fin = LocalDateTime.of(year, month, YearMonth.of(year, month).lengthOfMonth(), 23, 59, 59);
        return this.metricsDAO.obtenerMetricasDiarias(inicio, fin).stream().map(p -> new MetricaDiariaDTO(LocalDateTime.of((int)p.getYear(), p.getMonth(), (int)p.getDay(), 0, 0), p.getFirmados().longValue(), p.getNoFirmados().longValue())).toList();
    }

    @Generated
    public TrasabilidadServiceImpl(DocumentoMetricaDAO metricsDAO) {
        this.metricsDAO = metricsDAO;
    }
}

