/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.service.impl;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.StampingProperties;
import com.itextpdf.signatures.BouncyCastleDigest;
import com.itextpdf.signatures.IExternalDigest;
import com.itextpdf.signatures.IExternalSignature;
import com.itextpdf.signatures.PdfPKCS7;
import com.itextpdf.signatures.PdfSignatureAppearance;
import com.itextpdf.signatures.PdfSigner;
import com.itextpdf.signatures.PrivateKeySignature;
import com.itextpdf.signatures.SignatureUtil;
import com.tws2.firma_s.exceptions.CustomException;
import com.tws2.firma_s.logic.model.LocalizacionModel;
import com.tws2.firma_s.logic.model.SignModel;
import com.tws2.firma_s.logic.model.certificate.CertificateModel;
import com.tws2.firma_s.logic.model.firma.TFirmaUbicacion;
import com.tws2.firma_s.logic.service.SignDocumentoService;
import com.tws2.firma_s.utils.ApiResponse;
import com.tws2.firma_s.utils.CertificateDataExtractor;
import com.tws2.firma_s.utils.LocalizacionUtils;
import com.tws2.firma_s.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.Base64;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class SignDocumentoServiceImpl
implements SignDocumentoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SignDocumentoServiceImpl.class);

    public String signDocumento(String pdfBase64, byte[] certificadoBytes, String password, List<TFirmaUbicacion> coordenadas, String identification) {
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12");
            ks.load(new ByteArrayInputStream(certificadoBytes), password.toCharArray());
            String alias = ks.aliases().nextElement();
            PrivateKey pk = (PrivateKey)ks.getKey(alias, password.toCharArray());
            Certificate[] chain = ks.getCertificateChain(alias);
            CertificateModel certificateModel = this.extractInformation(ks, identification);
            String resultado = pdfBase64;
            for (TFirmaUbicacion coord : coordenadas) {
                byte[] pdfBytes = Base64.getDecoder().decode(resultado);
                resultado = this.signDocumentWithQRModel(pdfBytes, certificateModel, pk, chain, coord.getPosX(), coord.getPosY(), coord.getPagina());
            }
            return resultado;
        }
        catch (Exception e) {
            return "Error firmando PDF: " + e.getMessage();
        }
    }

    protected String signDocumentWithQRModel(byte[] pdfBytes, CertificateModel certificateModel, PrivateKey pk, Certificate[] chain, String coordenadaX, String coordenadaY, String pageNumber) throws Exception {
        try (ByteArrayInputStream source = new ByteArrayInputStream(pdfBytes);){
            String string;
            try (ByteArrayOutputStream pdfSignedOut = new ByteArrayOutputStream();){
                PdfReader reader = new PdfReader((InputStream)source);
                PdfSigner signer = new PdfSigner(reader, (OutputStream)pdfSignedOut, new StampingProperties().useAppendMode());
                String qrCodeData = new SignModel(certificateModel.getSubject().getFullName(), "", "").getFullData();
                QRCodeWriter qrCodeWriter = new QRCodeWriter();
                HashMap<EncodeHintType, String> hints = new HashMap<EncodeHintType, String>();
                hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
                BitMatrix bitMatrix = qrCodeWriter.encode(qrCodeData, BarcodeFormat.QR_CODE, 50, 50, hints);
                ByteArrayOutputStream qrBaos = new ByteArrayOutputStream();
                MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"PNG", (OutputStream)qrBaos);
                LocalizacionModel lm = LocalizacionUtils.getCoordenadas((String)coordenadaX, (String)coordenadaY, (String)pageNumber, (int)Utils.getPageNumber((byte[])pdfBytes));
                PdfSignatureAppearance appearance = signer.getSignatureAppearance();
                appearance.setReason("");
                appearance.setLocation("");
                appearance.setSignatureGraphic(ImageDataFactory.create((byte[])qrBaos.toByteArray()));
                appearance.setLocationCaption("");
                appearance.setRenderingMode(PdfSignatureAppearance.RenderingMode.GRAPHIC_AND_DESCRIPTION);
                appearance.setLayer2Text("\nFirmado por:\n" + certificateModel.getSubject().getFullName());
                appearance.setLayer2FontSize(9.0f);
                appearance.setPageRect(new Rectangle(lm.getX(), lm.getY(), 200.0f, 50.0f));
                appearance.setPageNumber(lm.getPage());
                BouncyCastleDigest digest = new BouncyCastleDigest();
                PrivateKeySignature signature = new PrivateKeySignature(pk, "SHA256", "BC");
                signer.signDetached((IExternalDigest)digest, (IExternalSignature)signature, chain, null, null, null, 0, PdfSigner.CryptoStandard.CMS);
                byte[] signedPdfBytes = pdfSignedOut.toByteArray();
                string = Base64.getEncoder().encodeToString(signedPdfBytes);
            }
            return string;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ResponseEntity<?> validarDocumento(String base64, String identificacion) {
        if (!Utils.isPdfFile((String)base64).booleanValue()) {
            throw new CustomException("El archivo enviado no corresponde a un PDF.", HttpStatus.BAD_REQUEST);
        }
        byte[] decodedFile = Base64.getDecoder().decode(base64);
        ByteArrayInputStream source = new ByteArrayInputStream(decodedFile);
        try (PdfReader reader = new PdfReader((InputStream)source);){
            PdfDocument pdfDoc = new PdfDocument(reader);
            SignatureUtil signUtil = new SignatureUtil(pdfDoc);
            List signatures = signUtil.getSignatureNames();
            if (signatures.isEmpty()) {
                pdfDoc.close();
                ResponseEntity responseEntity = new ResponseEntity((Object)ApiResponse.ok((Object)"No se encontraron firmas en el documento", (boolean)false), (HttpStatusCode)HttpStatus.OK);
                return responseEntity;
            }
            for (String signatureName : signatures) {
                PdfPKCS7 pkcs7 = signUtil.readSignatureData(signatureName);
                boolean isSignatureCoversWholeDocument = signUtil.signatureCoversWholeDocument(signatureName);
                CertificateDataExtractor extractor = new CertificateDataExtractor();
                CertificateModel certificateModel = extractor.extractCertificateDetails(pkcs7.getSigningCertificate(), identificacion);
                Calendar signingTime = pkcs7.getSignDate();
                if (certificateModel == null || !certificateModel.getSubject().getSerialNumber().contains(identificacion)) continue;
                pdfDoc.close();
                ResponseEntity responseEntity = new ResponseEntity((Object)ApiResponse.ok((Object)("Firma validada correctamente, la fecha de firma del documento es: " + signingTime.getTime()), (boolean)true), (HttpStatusCode)HttpStatus.OK);
                return responseEntity;
            }
            pdfDoc.close();
            throw new CustomException("La firma no corresponde al usuario de la sesi\u00f3n", HttpStatus.BAD_REQUEST);
        }
        catch (IOException e) {
            java.util.logging.Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "ERROR AL VALIDAR LA FIRMA: ", e);
            return new ResponseEntity((Object)ApiResponse.error((int)HttpStatus.INTERNAL_SERVER_ERROR.value(), (String)"Ha ocurrido un error al validar la firma"), (HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    protected CertificateModel extractInformation(KeyStore keyStore, String identificacion) throws CustomException, Exception {
        Enumeration<String> aliases = keyStore.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            if (!keyStore.isKeyEntry(alias)) continue;
            CertificateDataExtractor extractor = new CertificateDataExtractor();
            X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
            CertificateModel certModel = extractor.extractCertificateDetails(cert, identificacion);
            if (certModel.getValidTo().isBefore(LocalDateTime.now())) {
                throw new CustomException("El certificado ha expirado, carga una nueva firma electr\u00f3nica.", HttpStatus.BAD_REQUEST);
            }
            return extractor.extractCertificateDetails(cert, identificacion);
        }
        return null;
    }

    @Generated
    public SignDocumentoServiceImpl() {
    }
}

