/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tws2.firma_s.exceptions.CustomException;
import com.tws2.firma_s.logic.model.TCallbackBiometria;
import com.tws2.firma_s.logic.model.TFirmanteMultiple;
import com.tws2.firma_s.logic.model.TSolicitud;
import com.tws2.firma_s.logic.model.biometria.TImageData;
import com.tws2.firma_s.logic.model.biometria.TIndicadores;
import com.tws2.firma_s.logic.model.biometria.TMetadata;
import com.tws2.firma_s.logic.model.documento.TDocumento;
import com.tws2.firma_s.logic.model.dto.FirmadocumentoDTO;
import com.tws2.firma_s.logic.repository.CallbackBiometriaDAO;
import com.tws2.firma_s.logic.repository.DocumentoDAO;
import com.tws2.firma_s.logic.repository.FirmaUbicacionDAO;
import com.tws2.firma_s.logic.repository.FirmanteMultipleDAO;
import com.tws2.firma_s.logic.repository.SolicitudDAO;
import com.tws2.firma_s.logic.service.CallbackService;
import com.tws2.firma_s.logic.service.ReenvioService;
import com.tws2.firma_s.logic.service.SignDocumentoService;
import com.tws2.firma_s.logic.service.impl.DocumentoCoreServiceImpl;
import com.tws2.firma_s.utils.ApiResponse;
import com.tws2.firma_s.utils.DecriptUtils;
import jakarta.transaction.Transactional;
import java.time.LocalDateTime;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class CallbackServiceImpl
implements CallbackService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CallbackServiceImpl.class);
    private final CallbackBiometriaDAO callbackDAO;
    private final SolicitudDAO solicitudDAO;
    private final FirmanteMultipleDAO firmanteMultipleDAO;
    private final DocumentoDAO documentoDAO;
    private final FirmaUbicacionDAO firmaDAO;
    private final SignDocumentoService signDocumentService;
    private final DecriptUtils encriptUtils;
    private final ReenvioService reenvioService;
    private final ObjectMapper objectMapper;
    private final DocumentoCoreServiceImpl core;

    @Transactional
    public ResponseEntity<ApiResponse<?>> guardarCallbackBiometria(TCallbackBiometria callback) {
        String refTransaction = callback.getReferenceTransaction();
        TSolicitud solicitudOpt = this.solicitudDAO.findByReferenceTransaction(refTransaction);
        if (solicitudOpt == null) {
            throw new CustomException("Error: No se encontr\u00f3 la solicitud con referenceTransaction: " + refTransaction, HttpStatus.BAD_REQUEST);
        }
        callback.setSolicitud(solicitudOpt);
        if (callback.getData() != null) {
            callback.getData().setCallback(callback);
            if (callback.getData().getImageData() != null) {
                for (TImageData image : callback.getData().getImageData()) {
                    image.setDataBiometria(callback.getData());
                }
            }
        }
        if (callback.getErrorMessage() != null) {
            callback.getErrorMessage().setCallback(callback);
        }
        if (callback.getIndicator() != null) {
            TIndicadores indicadores = callback.getIndicator();
            indicadores.setCallback(callback);
            if (indicadores.getFront() != null) {
                indicadores.getFront().setIndicator(indicadores);
            }
            if (indicadores.getBack() != null) {
                indicadores.getBack().setIndicator(indicadores);
            }
            if (indicadores.getMetadata() != null) {
                TMetadata metadata = indicadores.getMetadata();
                metadata.setIndicadores(indicadores);
                if (metadata.getProcessed() != null) {
                    metadata.getProcessed().setMetadata(metadata);
                }
                if (metadata.getResult() != null) {
                    metadata.getResult().setMetadata(metadata);
                }
            }
        }
        callback = this.encriptUtils.encriptando(callback);
        this.callbackDAO.save((Object)callback);
        long totalDocs = this.documentoDAO.contarTotalPorGrupo(callback.getSolicitud().getFirmanteMultiple().getCodigoGrupo());
        try {
            this.reenvioService.notificarBiometria(callback);
            if (totalDocs == 0L) {
                log.info("No existen documentos asociados a la transacci\u00f3n {}, se omite la firma.", (Object)callback.getReferenceTransaction());
                return new ResponseEntity((Object)ApiResponse.ok((int)200, (Object)"Informaci\u00f3n guardada (sin documentos para firmar)"), (HttpStatusCode)HttpStatus.OK);
            }
            if (!this.estanTodosFirmados(callback.getSolicitud().getFirmanteMultiple().getCodigoGrupo())) {
                this.procesarFirmadoYReenvio(callback.getReferenceTransaction());
            }
            return new ResponseEntity((Object)ApiResponse.ok((int)200, (Object)"Informaci\u00f3n guardada y documentos procesados para firma"), (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            log.error("Error enviando biometr\u00eda del grupo {}: {}", (Object)solicitudOpt.getFirmanteMultiple().getCodigoGrupo(), (Object)e.getMessage());
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)ApiResponse.error((int)500, (String)("Biometr\u00eda guardada pero error al reenviar: " + e.getMessage())));
        }
    }

    @Async
    @Transactional
    public void procesarFirmadoYReenvio(String referenceTransaction) {
        log.info("INICIO - Procesando firma asincrona y reenvio para: {}", (Object)referenceTransaction);
        TSolicitud solicitudActual = this.solicitudDAO.findByReferenceTransaction(referenceTransaction);
        log.info("Solicitud actual obtenida: {}", solicitudActual != null ? solicitudActual.getId() : "null");
        if (solicitudActual == null) {
            throw new CustomException("Solicitud no encontrada", HttpStatus.NOT_FOUND);
        }
        TFirmanteMultiple grupo = solicitudActual.getFirmanteMultiple();
        log.info("Grupo de firmantes obtenido: {}", grupo != null ? grupo.getId() : "null");
        if (grupo == null) {
            throw new CustomException("Grupo de firmantes no encontrado", HttpStatus.NOT_FOUND);
        }
        List solicitudes = this.firmanteMultipleDAO.findByCodigoGrupo(grupo.getCodigoGrupo());
        log.info("Grupo solicitudes size: {}", solicitudes != null ? Integer.valueOf(solicitudes.size()) : "null");
        if (solicitudes == null || solicitudes.isEmpty()) {
            throw new CustomException("No existen firmantes asociados al grupo", HttpStatus.NOT_FOUND);
        }
        int totalFirmantes = Integer.parseInt(grupo.getCantidadFirmantes());
        log.info("Total firmantes esperados: {}", (Object)totalFirmantes);
        int certificadosRecibidos = this.solicitudDAO.contarCertificadosPorGrupo(grupo.getCodigoGrupo());
        log.info("Certificados recibidos hasta ahora: {}", (Object)certificadosRecibidos);
        if (certificadosRecibidos < totalFirmantes) {
            return;
        }
        solicitudes.sort(Comparator.comparing(TSolicitud::getId));
        List documentos = this.documentoDAO.findDocumentsByGrupo(grupo.getId());
        log.info("Documentos a firmar encontrados: {}", documentos != null ? Integer.valueOf(documentos.size()) : "null");
        if (documentos == null || documentos.isEmpty()) {
            throw new CustomException("No existen documentos para firmar", HttpStatus.BAD_REQUEST);
        }
        for (TDocumento doc : documentos) {
            String pdfActual;
            String string = pdfActual = doc.getArchivoBase64Signed() != null ? doc.getArchivoBase64Signed() : doc.getArchivoBase64();
            if (pdfActual == null) {
                throw new CustomException("Documento sin contenido para firmar", HttpStatus.INTERNAL_SERVER_ERROR);
            }
            for (TSolicitud firmante : solicitudes) {
                FirmadocumentoDTO certData = this.solicitudDAO.obtenerCertificadoPorReferencia(firmante.getReferenceTransaction());
                if (certData == null) {
                    throw new CustomException("Certificado faltante para " + firmante.getReferenceTransaction(), HttpStatus.BAD_REQUEST);
                }
                byte[] certificadoBytes = Base64.getDecoder().decode(certData.getCertificate());
                String passwordCert = this.encriptUtils.decrypt(certData.getPassword());
                List coordenadas = this.firmaDAO.findLocationByIdDocumento(doc.getId());
                pdfActual = this.signDocumentService.signDocumento(pdfActual, certificadoBytes, passwordCert, coordenadas, certData.getIdentification());
            }
            doc.setArchivoBase64Signed(pdfActual);
            doc.setArchivoBase64(null);
            doc.setFirmado(true);
            doc.setFechaFirmado(LocalDateTime.now());
            this.documentoDAO.save((Object)doc);
        }
        this.reenvioService.notificarDocumentos(grupo.getCodigoGrupo());
        log.info("FIN - Procesando firma asincrona completado para: {}", (Object)referenceTransaction);
    }

    public boolean estanTodosFirmados(String referenceTransaction) {
        long total = this.documentoDAO.contarTotalPorGrupo(referenceTransaction);
        long firmados = this.documentoDAO.contarFirmadosPorGrupo(referenceTransaction);
        return total > 0L && total == firmados;
    }

    @Transactional
    public ResponseEntity<ApiResponse<?>> firmarDocumentos(String identification, String referenceTransaction, String certificate, String password, String documentosJson) throws JsonMappingException, JsonProcessingException {
        TSolicitud solicitud = this.solicitudDAO.findByReferenceTransaction(referenceTransaction);
        if (solicitud == null) {
            throw new CustomException("Solicitud no encontrada", HttpStatus.NOT_FOUND);
        }
        TFirmanteMultiple grupo = solicitud.getFirmanteMultiple();
        if (grupo == null) {
            throw new CustomException("Grupo de firmantes no encontrado", HttpStatus.BAD_REQUEST);
        }
        List documentosDto = (List)this.objectMapper.readValue(documentosJson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        List savedDocs = this.core.guardarDocumentosConCoordenadas(documentosDto, grupo);
        for (TDocumento doc : savedDocs) {
            List coordenadas = this.firmaDAO.findLocationByIdDocumento(doc.getId());
            byte[] certificadoBytes = Base64.getDecoder().decode(certificate);
            String decryptedPassword = this.encriptUtils.decrypt(password);
            String pdfFirmado = this.signDocumentService.signDocumento(doc.getArchivoBase64(), certificadoBytes, decryptedPassword, coordenadas, identification);
            doc.setArchivoBase64(null);
            doc.setFirmado(true);
            doc.setArchivoBase64Signed(pdfFirmado);
            doc.setFechaFirmado(LocalDateTime.now());
            this.documentoDAO.save((Object)doc);
        }
        return new ResponseEntity((Object)ApiResponse.ok((int)200, (Object)"Documentos firmados y almacenados correctamente."), (HttpStatusCode)HttpStatus.OK);
    }

    public void firmarDocumentos(List<TDocumento> documentos, String identification, String referenceTransaction, String certificate, String password) {
        for (TDocumento doc : documentos) {
            List coordenadas = this.firmaDAO.findLocationByIdDocumento(doc.getId());
            byte[] certificadoBytes = Base64.getDecoder().decode(certificate);
            String decryptedPassword = this.encriptUtils.decrypt(password);
            String pdfFirmado = this.signDocumentService.signDocumento(doc.getArchivoBase64(), certificadoBytes, decryptedPassword, coordenadas, identification);
            doc.setArchivoBase64(null);
            doc.setArchivoBase64Signed(pdfFirmado);
            doc.setFechaFirmado(LocalDateTime.now());
            doc.setFirmado(true);
            this.documentoDAO.save((Object)doc);
        }
    }

    @Generated
    public CallbackServiceImpl(CallbackBiometriaDAO callbackDAO, SolicitudDAO solicitudDAO, FirmanteMultipleDAO firmanteMultipleDAO, DocumentoDAO documentoDAO, FirmaUbicacionDAO firmaDAO, SignDocumentoService signDocumentService, DecriptUtils encriptUtils, ReenvioService reenvioService, ObjectMapper objectMapper, DocumentoCoreServiceImpl core) {
        this.callbackDAO = callbackDAO;
        this.solicitudDAO = solicitudDAO;
        this.firmanteMultipleDAO = firmanteMultipleDAO;
        this.documentoDAO = documentoDAO;
        this.firmaDAO = firmaDAO;
        this.signDocumentService = signDocumentService;
        this.encriptUtils = encriptUtils;
        this.reenvioService = reenvioService;
        this.objectMapper = objectMapper;
        this.core = core;
    }
}

