/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.repository;

import com.tws2.firma_s.logic.model.TSolicitud;
import com.tws2.firma_s.logic.model.dto.FirmadocumentoDTO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface SolicitudDAO
extends JpaRepository<TSolicitud, Long> {
    public boolean existsByReferenceTransaction(String var1);

    public TSolicitud findByReferenceTransaction(String var1);

    @Query(value="SELECT\n    v.solicitud_id AS solicitudId,\n    v.identification_number as identification,\n    v.reference_transaction AS referenceTransaction,\n    v.callback_status AS callbackStatus,\n    v.certificate AS certificate,\n    v.password AS password\nFROM v_certificado_por_transaccion v\nWHERE v.reference_transaction = :referenceTransaction\nLIMIT 1\n", nativeQuery=true)
    public FirmadocumentoDTO obtenerCertificadoPorReferencia(@Param(value="referenceTransaction") String var1);

    @Query(value="SELECT s.reference_transaction\nFROM t_solicitud s\nWHERE s.identification_number = :identificationNumber\n  AND s.date_registry >= CURRENT_DATE\n  AND s.date_registry < CURRENT_DATE + INTERVAL '1 day'\nORDER BY s.date_registry DESC\nLIMIT 1\n", nativeQuery=true)
    public String findLatestTransactionToday(@Param(value="identificationNumber") String var1);

    @Query(value="    SELECT *\n    FROM t_firmante_multiple fm\n    JOIN t_solicitud s ON s.id = fm.solicitud_id\n    WHERE s.identification_number = :identificationNumber\n      AND s.date_registry >= CURRENT_DATE\n      AND s.date_registry < CURRENT_DATE + INTERVAL '1 day'\n    ORDER BY fm.fecha_creacion DESC\n    LIMIT 1\n", nativeQuery=true)
    public TSolicitud findByIdentificationNumber(@Param(value="identificationNumber") String var1);

    @Query(value="    SELECT COUNT(1)\n    FROM v_certificado_por_transaccion v\n    WHERE v.codigo_grupo = :codigoGrupo\n", nativeQuery=true)
    public int contarCertificadosPorGrupo(@Param(value="codigoGrupo") String var1);
}

