/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.repository;

import com.tws2.firma_s.logic.model.dashboard.projection.MetricaDiariaProjection;
import com.tws2.firma_s.logic.model.dashboard.projection.MetricaMensualProjection;
import com.tws2.firma_s.logic.model.documento.TDocumento;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

public interface DocumentoMetricaDAO
extends JpaRepository<TDocumento, Long> {
    @Query(value="    SELECT\n        YEAR(COALESCE(d.fechaFirmado, d.fechaRegistro))  AS year,\n        MONTH(COALESCE(d.fechaFirmado, d.fechaRegistro)) AS month,\n        SUM(CASE WHEN d.firmado = true  THEN 1 ELSE 0 END)  AS firmados,\n        SUM(CASE WHEN d.firmado = false THEN 1 ELSE 0 END) AS noFirmados\n    FROM TDocumento d\n    WHERE COALESCE(d.fechaFirmado, d.fechaRegistro)\n          BETWEEN :inicio AND :fin\n    GROUP BY\n        YEAR(COALESCE(d.fechaFirmado, d.fechaRegistro)),\n        MONTH(COALESCE(d.fechaFirmado, d.fechaRegistro))\n    ORDER BY year, month\n")
    public List<MetricaMensualProjection> obtenerMetricasMensuales(LocalDateTime var1, LocalDateTime var2);

    @Query(value="    SELECT\n        YEAR(COALESCE(d.fechaFirmado, d.fechaRegistro))  AS year,\n        MONTH(COALESCE(d.fechaFirmado, d.fechaRegistro)) AS month,\n        DAY(COALESCE(d.fechaFirmado, d.fechaRegistro))   AS day,\n        SUM(CASE WHEN d.firmado = true  THEN 1 ELSE 0 END)  AS firmados,\n        SUM(CASE WHEN d.firmado = false THEN 1 ELSE 0 END) AS noFirmados\n    FROM TDocumento d\n    WHERE COALESCE(d.fechaFirmado, d.fechaRegistro)\n          BETWEEN :inicio AND :fin\n    GROUP BY\n        YEAR(COALESCE(d.fechaFirmado, d.fechaRegistro)),\n        MONTH(COALESCE(d.fechaFirmado, d.fechaRegistro)),\n        DAY(COALESCE(d.fechaFirmado, d.fechaRegistro))\n    ORDER BY year, month, day\n")
    public List<MetricaDiariaProjection> obtenerMetricasDiarias(LocalDateTime var1, LocalDateTime var2);
}

