/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.repository;

import com.tws2.firma_s.logic.model.documento.TDocumento;
import com.tws2.firma_s.logic.model.view.DocumentoFirmanteView;
import com.tws2.firma_s.logic.model.view.SolicitudFirmanteView;
import java.util.List;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface DocumentoDAO
extends JpaRepository<TDocumento, Long> {
    @Query(value="select t from TDocumento t where t.grupo.id = :grupoId")
    public List<TDocumento> findDocumentsByGrupo(Long var1);

    @Query(value="SELECT COUNT(DISTINCT d) FROM TDocumento d JOIN d.grupo g  WHERE g.codigoGrupo = :codigoGrupo")
    public long contarTotalPorGrupo(String var1);

    @Query(value="SELECT COUNT(DISTINCT d) FROM TDocumento d JOIN d.grupo g  WHERE g.codigoGrupo = :codigoGrupo AND d.firmado = true")
    public long contarFirmadosPorGrupo(String var1);

    @Query(value="SELECT d FROM TDocumento d JOIN d.grupo g WHERE g.codigoGrupo = :codigoGrupo")
    public List<TDocumento> findAllDocumentsByGrupo(@Param(value="codigoGrupo") String var1);

    @Query(value="    SELECT\n        ts.id,\n        ts.nombres_completos AS nombresCompletos,\n        ts.identification_number AS identificationNumber,\n        ts.cellphone_number AS cellphoneNumber,\n        ts.address,\n        ts.reference_transaction AS referenceTransaction\n    FROM pruebas.t_firmante_multiple tfm\n    JOIN pruebas.t_solicitud ts\n      ON ts.firmante_multiple_id =tfm.id\n    WHERE tfm.codigo_grupo = :codigoGrupo\n", nativeQuery=true)
    public List<SolicitudFirmanteView> findFirmantesByCodigoGrupo(@Param(value="codigoGrupo") String var1);

    @Query(value="    SELECT\n        tfm.codigo_grupo AS codigoGrupo,\n        td.id,\n        td.nombre,\n        td.fecha_registro AS fechaRegistro,\n        td.fecha_firmado AS fechaFirmado,\n        td.firmado,\n        td.codigo_documento AS codigoDocumento\n    FROM pruebas.t_documento td\n    JOIN pruebas.t_firmante_multiple tfm\n      ON tfm.id = td.grupo_id\n    WHERE tfm.codigo_grupo = :codigoGrupo\n", nativeQuery=true)
    public List<DocumentoFirmanteView> findDocumentosByCodigoGrupo(@Param(value="codigoGrupo") String var1);
}

