/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.model.documento;

import com.tws2.firma_s.logic.model.TFirmanteMultiple;
import com.tws2.firma_s.logic.model.TSolicitud;
import com.tws2.firma_s.logic.model.firma.TFirmaUbicacion;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

@Entity
@Table(name="t_documento")
public class TDocumento {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String nombre;
    private String tipo;
    private String pagina;
    private String coordenada;
    private String codigoDocumento;
    private LocalDateTime fechaRegistro = LocalDateTime.now();
    private LocalDateTime fechaFirmado;
    @Column(columnDefinition="TEXT")
    private String archivoBase64;
    @Column(columnDefinition="TEXT")
    private String archivoBase64Signed;
    private boolean firmado;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="grupo_id")
    private TFirmanteMultiple grupo;
    @OneToMany(mappedBy="documento", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TFirmaUbicacion> firmaUbicaciones = new ArrayList();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="solicitud_id")
    private TSolicitud solicitud;

    public TDocumento(String nombre, String tipo, String pagina, String coordenada, String codigoDocumento, String archivoBase64, boolean firmado, TFirmanteMultiple grupo) {
        this.nombre = nombre;
        this.tipo = tipo;
        this.pagina = pagina;
        this.coordenada = coordenada;
        this.codigoDocumento = codigoDocumento;
        this.archivoBase64 = archivoBase64;
        this.firmado = false;
        this.grupo = grupo;
    }

    public TDocumento(String nombre, String codigoDocumento, LocalDateTime fechaFirmado, String archivoBase64Signed, boolean firmado) {
        this.nombre = nombre;
        this.codigoDocumento = codigoDocumento;
        this.fechaFirmado = LocalDateTime.now();
        this.archivoBase64Signed = archivoBase64Signed;
        this.firmado = firmado;
    }

    @Generated
    public TDocumento(Long id, String nombre, String tipo, String pagina, String coordenada, String codigoDocumento, LocalDateTime fechaRegistro, LocalDateTime fechaFirmado, String archivoBase64, String archivoBase64Signed, boolean firmado, TFirmanteMultiple grupo, List<TFirmaUbicacion> firmaUbicaciones, TSolicitud solicitud) {
        this.id = id;
        this.nombre = nombre;
        this.tipo = tipo;
        this.pagina = pagina;
        this.coordenada = coordenada;
        this.codigoDocumento = codigoDocumento;
        this.fechaRegistro = fechaRegistro;
        this.fechaFirmado = fechaFirmado;
        this.archivoBase64 = archivoBase64;
        this.archivoBase64Signed = archivoBase64Signed;
        this.firmado = firmado;
        this.grupo = grupo;
        this.firmaUbicaciones = firmaUbicaciones;
        this.solicitud = solicitud;
    }

    @Generated
    public TDocumento() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getNombre() {
        return this.nombre;
    }

    @Generated
    public String getTipo() {
        return this.tipo;
    }

    @Generated
    public String getPagina() {
        return this.pagina;
    }

    @Generated
    public String getCoordenada() {
        return this.coordenada;
    }

    @Generated
    public String getCodigoDocumento() {
        return this.codigoDocumento;
    }

    @Generated
    public LocalDateTime getFechaRegistro() {
        return this.fechaRegistro;
    }

    @Generated
    public LocalDateTime getFechaFirmado() {
        return this.fechaFirmado;
    }

    @Generated
    public String getArchivoBase64() {
        return this.archivoBase64;
    }

    @Generated
    public String getArchivoBase64Signed() {
        return this.archivoBase64Signed;
    }

    @Generated
    public boolean isFirmado() {
        return this.firmado;
    }

    @Generated
    public TFirmanteMultiple getGrupo() {
        return this.grupo;
    }

    @Generated
    public List<TFirmaUbicacion> getFirmaUbicaciones() {
        return this.firmaUbicaciones;
    }

    @Generated
    public TSolicitud getSolicitud() {
        return this.solicitud;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setNombre(String nombre) {
        this.nombre = nombre;
    }

    @Generated
    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setPagina(String pagina) {
        this.pagina = pagina;
    }

    @Generated
    public void setCoordenada(String coordenada) {
        this.coordenada = coordenada;
    }

    @Generated
    public void setCodigoDocumento(String codigoDocumento) {
        this.codigoDocumento = codigoDocumento;
    }

    @Generated
    public void setFechaRegistro(LocalDateTime fechaRegistro) {
        this.fechaRegistro = fechaRegistro;
    }

    @Generated
    public void setFechaFirmado(LocalDateTime fechaFirmado) {
        this.fechaFirmado = fechaFirmado;
    }

    @Generated
    public void setArchivoBase64(String archivoBase64) {
        this.archivoBase64 = archivoBase64;
    }

    @Generated
    public void setArchivoBase64Signed(String archivoBase64Signed) {
        this.archivoBase64Signed = archivoBase64Signed;
    }

    @Generated
    public void setFirmado(boolean firmado) {
        this.firmado = firmado;
    }

    @Generated
    public void setGrupo(TFirmanteMultiple grupo) {
        this.grupo = grupo;
    }

    @Generated
    public void setFirmaUbicaciones(List<TFirmaUbicacion> firmaUbicaciones) {
        this.firmaUbicaciones = firmaUbicaciones;
    }

    @Generated
    public void setSolicitud(TSolicitud solicitud) {
        this.solicitud = solicitud;
    }

    @Generated
    public String toString() {
        return "TDocumento(id=" + this.getId() + ", nombre=" + this.getNombre() + ", tipo=" + this.getTipo() + ", pagina=" + this.getPagina() + ", coordenada=" + this.getCoordenada() + ", codigoDocumento=" + this.getCodigoDocumento() + ", fechaRegistro=" + this.getFechaRegistro() + ", fechaFirmado=" + this.getFechaFirmado() + ", archivoBase64=" + this.getArchivoBase64() + ", archivoBase64Signed=" + this.getArchivoBase64Signed() + ", firmado=" + this.isFirmado() + ", solicitud=" + this.getSolicitud() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TDocumento)) {
            return false;
        }
        TDocumento other = (TDocumento)o;
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TDocumento;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

