/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.mail.controller;

import com.tws2.firma_s.logic.mail.model.dto.MailConfiguracionDTO;
import com.tws2.firma_s.logic.mail.service.MailConfigurationService;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/mail/configuracion"})
public class MailConfiguracionController {
    private final MailConfigurationService mailConfigService;

    @PostMapping(value={"/save"}, consumes={"application/json"})
    public ResponseEntity<MailConfiguracionDTO> saveOrUpdate(@RequestBody MailConfiguracionDTO dto) {
        return ResponseEntity.ok((Object)this.mailConfigService.saveOrUpdate(dto));
    }

    @GetMapping(value={"/{codigo}"})
    public ResponseEntity<MailConfiguracionDTO> getByCodigo(@PathVariable String codigo) {
        return ResponseEntity.ok((Object)this.mailConfigService.getByCodigo(codigo));
    }

    @GetMapping(value={"/preview/{codigo}"}, produces={"text/html"})
    public ResponseEntity<String> getPreview(@PathVariable String codigo) {
        return ResponseEntity.ok((Object)this.mailConfigService.getPreview(codigo));
    }

    @PostMapping(value={"/preview"}, produces={"text/html"})
    public ResponseEntity<String> renderPreview(@RequestBody MailConfiguracionDTO dto) {
        return ResponseEntity.ok((Object)this.mailConfigService.renderPreview(dto));
    }

    @Generated
    public MailConfiguracionController(MailConfigurationService mailConfigService) {
        this.mailConfigService = mailConfigService;
    }
}

