/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.campaign.service.impl;

import com.tws2.firma_s.exceptions.CustomException;
import com.tws2.firma_s.logic.biometria.utils.ApiResponse;
import com.tws2.firma_s.logic.campaign.model.CampaignReportRequest;
import com.tws2.firma_s.logic.campaign.model.CampaignReportResponse;
import com.tws2.firma_s.logic.campaign.model.CampaignSendRequest;
import com.tws2.firma_s.logic.campaign.model.CampaignSendResponse;
import com.tws2.firma_s.logic.campaign.model.TCampaignConfig;
import com.tws2.firma_s.logic.campaign.repository.CampaignConfigRepository;
import com.tws2.firma_s.logic.campaign.service.ICampaignConfigService;
import com.tws2.firma_s.logic.campaign.service.IWhatsAppCampaignService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class WhatsAppCampaignServiceImpl
implements IWhatsAppCampaignService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WhatsAppCampaignServiceImpl.class);
    @Autowired
    private CampaignConfigRepository campaignConfigRepository;
    @Autowired
    private ICampaignConfigService campaignConfigService;
    @Autowired
    private RestTemplate restTemplate;

    public ApiResponse<CampaignSendResponse> sendCampaign(CampaignSendRequest request, String clientReference, String environment) {
        TCampaignConfig campaignConfig = this.getConfig(clientReference, environment);
        String accessToken = this.campaignConfigService.getTransactionToken(clientReference, environment);
        String url = campaignConfig.getBaseUrl() + campaignConfig.getSendEndpoint();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(accessToken);
        HttpEntity requestEntity = new HttpEntity((Object)request, (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, Object.class, new Object[0]);
            CampaignSendResponse campaignResponse = new CampaignSendResponse();
            campaignResponse.setSuccess(Boolean.valueOf(response.getStatusCode().is2xxSuccessful()));
            campaignResponse.setStatusCode(Integer.valueOf(response.getStatusCode().value()));
            campaignResponse.setMessage("Campa\u00f1a enviada exitosamente");
            campaignResponse.setData(response.getBody());
            return ApiResponse.ok((int)200, (Object)campaignResponse);
        }
        catch (Exception e) {
            log.error("Error al enviar campa\u00f1a: {}", (Object)e.getMessage(), (Object)e);
            if (e.getMessage() != null && e.getMessage().contains("401")) {
                return this.sendCampaign(request, clientReference, environment);
            }
            throw new CustomException("Error al enviar campa\u00f1a", HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }

    public ApiResponse<Object> getAllTemplates(String clientReference, String environment) {
        TCampaignConfig campaignConfig = this.getConfig(clientReference, environment);
        String accessToken = this.campaignConfigService.getTransactionToken(clientReference, environment);
        String url = campaignConfig.getBaseUrl() + "/whatsapp-campaign/templates";
        HttpHeaders headers = new HttpHeaders();
        headers.setBearerAuth(accessToken);
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, Object.class, new Object[0]);
        return ApiResponse.ok((int)200, (Object)response.getBody());
    }

    public ApiResponse<Object> getTemplateById(String templateId, String clientReference, String environment) {
        TCampaignConfig campaignConfig = this.getConfig(clientReference, environment);
        String accessToken = this.campaignConfigService.getTransactionToken(clientReference, environment);
        String url = campaignConfig.getBaseUrl() + "/whatsapp-campaign/templates/" + templateId;
        HttpHeaders headers = new HttpHeaders();
        headers.setBearerAuth(accessToken);
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, Object.class, new Object[0]);
        return ApiResponse.ok((int)200, (Object)response.getBody());
    }

    public ApiResponse<CampaignReportResponse> getCampaignReports(CampaignReportRequest request, String clientReference, String environment) {
        TCampaignConfig campaignConfig = this.getConfig(clientReference, environment);
        String accessToken = this.campaignConfigService.getTransactionToken(clientReference, environment);
        String url = campaignConfig.getBaseUrl() + "/report-campaign/report-campaigns";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.setBearerAuth(accessToken);
        MultiValueMap body = this.buildReportParams(request);
        HttpEntity requestEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)requestEntity, Object.class, new Object[0]);
        CampaignReportResponse reportResponse = new CampaignReportResponse();
        reportResponse.setSuccess(Boolean.valueOf(response.getStatusCode().is2xxSuccessful()));
        reportResponse.setData(response.getBody());
        reportResponse.setMessage("Reporte obtenido exitosamente");
        return ApiResponse.ok((int)200, (Object)reportResponse);
    }

    public ApiResponse<CampaignReportResponse> getCampaignReportDetails(CampaignReportRequest request, String clientReference, String environment) {
        TCampaignConfig campaignConfig = this.getConfig(clientReference, environment);
        String accessToken = this.campaignConfigService.getTransactionToken(clientReference, environment);
        String url = campaignConfig.getBaseUrl() + "/report-campaign/report-campaigns-detail";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.setBearerAuth(accessToken);
        MultiValueMap body = this.buildReportParams(request);
        HttpEntity requestEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)requestEntity, Object.class, new Object[0]);
        CampaignReportResponse reportResponse = new CampaignReportResponse();
        reportResponse.setSuccess(Boolean.valueOf(response.getStatusCode().is2xxSuccessful()));
        reportResponse.setData(response.getBody());
        reportResponse.setMessage("Detalle de reporte obtenido exitosamente");
        return ApiResponse.ok((int)200, (Object)reportResponse);
    }

    public ApiResponse<CampaignReportResponse> getCampaignReportHistory(CampaignReportRequest request, String clientReference, String environment) {
        TCampaignConfig campaignConfig = this.getConfig(clientReference, environment);
        String accessToken = this.campaignConfigService.getTransactionToken(clientReference, environment);
        String url = campaignConfig.getBaseUrl() + "/report-campaign/report-campaigns-detail-history";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.setBearerAuth(accessToken);
        MultiValueMap body = this.buildReportParams(request);
        HttpEntity requestEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)requestEntity, Object.class, new Object[0]);
        CampaignReportResponse reportResponse = new CampaignReportResponse();
        reportResponse.setSuccess(Boolean.valueOf(response.getStatusCode().is2xxSuccessful()));
        reportResponse.setData(response.getBody());
        reportResponse.setMessage("Historial obtenido exitosamente");
        return ApiResponse.ok((int)200, (Object)reportResponse);
    }

    public byte[] exportCampaigns(Long campaignHeaderId, String clientReference, String environment) {
        TCampaignConfig campaignConfig = this.getConfig(clientReference, environment);
        String accessToken = this.campaignConfigService.getTransactionToken(clientReference, environment);
        String url = campaignConfig.getBaseUrl() + "/report-campaign/export-campaigns";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.setBearerAuth(accessToken);
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"campaignHeaderId", (Object)campaignHeaderId.toString());
        HttpEntity requestEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)requestEntity, byte[].class, new Object[0]);
        return (byte[])response.getBody();
    }

    private TCampaignConfig getConfig(String clientReference, String environment) {
        return (TCampaignConfig)this.campaignConfigRepository.findByClientReferenceAndEnvironmentAndActiveTrue(clientReference, environment).orElseThrow(() -> new CustomException("No se encontr\u00f3 configuraci\u00f3n de campa\u00f1a para " + clientReference + " en " + environment, HttpStatus.NOT_FOUND));
    }

    private MultiValueMap<String, String> buildReportParams(CampaignReportRequest request) {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        if (request.getStartDate() != null) {
            params.add((Object)"startDate", (Object)request.getStartDate());
        }
        if (request.getEndDate() != null) {
            params.add((Object)"endDate", (Object)request.getEndDate());
        }
        if (request.getPage() != null) {
            params.add((Object)"page", (Object)request.getPage().toString());
        }
        if (request.getSize() != null) {
            params.add((Object)"size", (Object)request.getSize().toString());
        }
        if (request.getConversationId() != null) {
            params.add((Object)"conversationId", (Object)request.getConversationId());
        }
        if (request.getCampaignHeaderId() != null) {
            params.add((Object)"campaignHeaderId", (Object)request.getCampaignHeaderId().toString());
        }
        return params;
    }
}

