/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.campaign.controller;

import com.tws2.firma_s.logic.campaign.model.CampaignReportRequest;
import com.tws2.firma_s.logic.campaign.model.CampaignSendRequest;
import com.tws2.firma_s.logic.campaign.model.TCampaignAuthConfig;
import com.tws2.firma_s.logic.campaign.model.TCampaignConfig;
import com.tws2.firma_s.logic.campaign.service.ICampaignConfigService;
import com.tws2.firma_s.logic.campaign.service.IWhatsAppCampaignService;
import jakarta.validation.Valid;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/campaign/"})
public class CampaignController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CampaignController.class);
    @Autowired
    private IWhatsAppCampaignService campaignService;
    @Autowired
    private ICampaignConfigService configService;

    @PostMapping(value={"send"})
    public ResponseEntity<?> sendCampaign(@RequestBody CampaignSendRequest request, @RequestParam(required=false) String clientReference, @RequestParam(required=false) String environment) {
        String client = clientReference != null ? clientReference : this.configService.getDefaultClientReference();
        String env = environment != null ? environment : this.configService.getDefaultEnvironment();
        log.info("Sending campaign for client: {}, environment: {}", (Object)client, (Object)env);
        return ResponseEntity.ok((Object)this.campaignService.sendCampaign(request, client, env));
    }

    @PostMapping(value={"config/auth/save"})
    public ResponseEntity<?> saveAuthConfig(@Valid @RequestBody TCampaignAuthConfig config) {
        return ResponseEntity.ok((Object)this.configService.saveAuthConfig(config));
    }

    @PostMapping(value={"config/auth/get"})
    public ResponseEntity<?> getAuthConfig(@RequestParam(required=false) String clientReference, @RequestParam(required=false) String environment) {
        String createdBy = SecurityContextHolder.getContext().getAuthentication().getName();
        return ResponseEntity.ok((Object)this.configService.getAuthConfig(createdBy));
    }

    @PostMapping(value={"config/auth/list"})
    public ResponseEntity<?> getAllAuthConfigs(@RequestParam(required=true) String createdBy) {
        log.info("Getting all auth configs for client: {}, environment: {}", (Object)this.configService.getAllAuthConfigs(createdBy));
        return ResponseEntity.ok((Object)this.configService.getAllAuthConfigs(createdBy));
    }

    @PostMapping(value={"config/auth/delete"})
    public ResponseEntity<?> deleteAuthConfig(@RequestParam Long id) {
        return ResponseEntity.ok((Object)this.configService.deleteAuthConfig(id));
    }

    @PostMapping(value={"config/endpoint/save"})
    public ResponseEntity<?> saveCampaignConfig(@Valid @RequestBody TCampaignConfig config) {
        return ResponseEntity.ok((Object)this.configService.saveCampaignConfig(config));
    }

    @PostMapping(value={"config/endpoint/get"})
    public ResponseEntity<?> getCampaignConfig(@RequestParam(required=false) String clientReference, @RequestParam(required=false) String environment) {
        String createdBy = SecurityContextHolder.getContext().getAuthentication().getName();
        return ResponseEntity.ok((Object)this.configService.getCampaignConfig(createdBy));
    }

    @PostMapping(value={"config/endpoint/list"})
    public ResponseEntity<?> getAllCampaignConfigs(@RequestParam(required=true) String createdBy) {
        return ResponseEntity.ok((Object)this.configService.getAllCampaignConfigs(createdBy));
    }

    @PostMapping(value={"config/endpoint/delete"})
    public ResponseEntity<?> deleteCampaignConfig(@RequestParam Long id) {
        return ResponseEntity.ok((Object)this.configService.deleteCampaignConfig(id));
    }

    @PostMapping(value={"templates/list"})
    public ResponseEntity<?> getAllTemplates(@RequestParam(required=false) String clientReference, @RequestParam(required=false) String environment) {
        String client = clientReference != null ? clientReference : this.configService.getDefaultClientReference();
        String env = environment != null ? environment : this.configService.getDefaultEnvironment();
        return ResponseEntity.ok((Object)this.campaignService.getAllTemplates(client, env));
    }

    @PostMapping(value={"templates/get"})
    public ResponseEntity<?> getTemplateById(@RequestParam String templateId, @RequestParam(required=false) String clientReference, @RequestParam(required=false) String environment) {
        String client = clientReference != null ? clientReference : this.configService.getDefaultClientReference();
        String env = environment != null ? environment : this.configService.getDefaultEnvironment();
        return ResponseEntity.ok((Object)this.campaignService.getTemplateById(templateId, client, env));
    }

    @PostMapping(value={"reports/campaigns"})
    public ResponseEntity<?> getCampaignReports(@RequestBody CampaignReportRequest request, @RequestParam(required=false) String clientReference, @RequestParam(required=false) String environment) {
        String client = clientReference != null ? clientReference : this.configService.getDefaultClientReference();
        String env = environment != null ? environment : this.configService.getDefaultEnvironment();
        return ResponseEntity.ok((Object)this.campaignService.getCampaignReports(request, client, env));
    }

    @PostMapping(value={"reports/campaigns-detail"})
    public ResponseEntity<?> getCampaignReportDetails(@RequestBody CampaignReportRequest request, @RequestParam(required=false) String clientReference, @RequestParam(required=false) String environment) {
        String client = clientReference != null ? clientReference : this.configService.getDefaultClientReference();
        String env = environment != null ? environment : this.configService.getDefaultEnvironment();
        return ResponseEntity.ok((Object)this.campaignService.getCampaignReportDetails(request, client, env));
    }

    @PostMapping(value={"reports/campaigns-detail-history"})
    public ResponseEntity<?> getCampaignReportHistory(@RequestBody CampaignReportRequest request, @RequestParam(required=false) String clientReference, @RequestParam(required=false) String environment) {
        String client = clientReference != null ? clientReference : this.configService.getDefaultClientReference();
        String env = environment != null ? environment : this.configService.getDefaultEnvironment();
        return ResponseEntity.ok((Object)this.campaignService.getCampaignReportHistory(request, client, env));
    }

    @PostMapping(value={"reports/export-campaigns"})
    public ResponseEntity<byte[]> exportCampaigns(@RequestParam Long campaignHeaderId, @RequestParam(required=false) String clientReference, @RequestParam(required=false) String environment) {
        String client = clientReference != null ? clientReference : this.configService.getDefaultClientReference();
        String env = environment != null ? environment : this.configService.getDefaultEnvironment();
        byte[] data = this.campaignService.exportCampaigns(campaignHeaderId, client, env);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().header("Content-Disposition", new String[]{"attachment; filename=campaigns.xlsx"})).body((Object)data);
    }
}

