/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.biometria.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tws2.firma_s.logic.biometria.model.TCallbackBiometria;
import com.tws2.firma_s.logic.biometria.service.CallbackService;
import com.tws2.firma_s.logic.biometria.service.ReenvioService;
import com.tws2.firma_s.logic.biometria.utils.ValidationUtils;
import java.time.LocalDateTime;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"callback/v1"})
public class CallbackController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CallbackController.class);
    private final ObjectMapper objectMapper;
    private final CallbackService callbackService;
    private final ReenvioService resendService;

    @PostMapping(value={"/callback-biometria"})
    public ResponseEntity<?> callbackBiometria(@RequestBody Map<String, Object> callback) {
        try {
            String rawJson = this.objectMapper.writeValueAsString(callback);
            JsonNode validado = ValidationUtils.validateBiometricObject((String)rawJson);
            String jsonValidado = this.objectMapper.writeValueAsString((Object)validado);
            TCallbackBiometria tCallbackBiometria = (TCallbackBiometria)this.objectMapper.readValue(jsonValidado, TCallbackBiometria.class);
            tCallbackBiometria.setFechaRegistro(LocalDateTime.now());
            this.callbackService.guardarCallbackBiometria(tCallbackBiometria);
            return ResponseEntity.ok((Object)"Callback procesado correctamente");
        }
        catch (JsonProcessingException e) {
            log.error("Error processing JSON", (Throwable)e);
            return ResponseEntity.badRequest().body((Object)"Error procesando el JSON recibido");
        }
    }

    @PostMapping(value={"/reenviar"})
    public void reenviarCallback(@RequestParam String referenceTransaction) {
        this.resendService.reenvioBiometriaCallback(referenceTransaction);
    }

    @Generated
    public CallbackController(ObjectMapper objectMapper, CallbackService callbackService, ReenvioService resendService) {
        this.objectMapper = objectMapper;
        this.callbackService = callbackService;
        this.resendService = resendService;
    }
}

