/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.biometria.controller;

import com.tws2.firma_s.logic.biometria.service.AuthService;
import com.tws2.firma_s.logic.biometria.service.DataBaseService;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1"})
public class AuthController {
    private final AuthService authService;
    private final DataBaseService baseService;

    @PostMapping(value={"/token"})
    public ResponseEntity<?> getToken(@RequestHeader(value="Authorization", required=false) String authorizationHeader) {
        if (authorizationHeader == null || !authorizationHeader.startsWith("Basic ")) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body((Object)"Falta cabecera Authorization: Basic <base64(user:pass)>");
        }
        try {
            String base64 = authorizationHeader.substring("Basic ".length()).trim();
            String decoded = new String(Base64.getDecoder().decode(base64), StandardCharsets.UTF_8);
            String[] pair = decoded.split(":", 2);
            if (pair.length != 2) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Authorization malformado");
            }
            String username = pair[0];
            String password = pair[1];
            return this.authService.getTokenWithPasswordGrant(username, password);
        }
        catch (IllegalArgumentException ex) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)"Authorization Base64 inv\u00e1lido");
        }
    }

    @PostMapping(value={"/refresh"})
    public String test() {
        return this.baseService.getTokenFromJti();
    }

    @Generated
    public AuthController(AuthService authService, DataBaseService baseService) {
        this.authService = authService;
        this.baseService = baseService;
    }
}

