/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.campaign.service.impl;

import com.tws2.firma_s.logic.campaign.model.AuthTokenResponse;
import com.tws2.firma_s.logic.campaign.model.TCampaignAuthConfig;
import com.tws2.firma_s.logic.campaign.repository.CampaignAuthConfigRepository;
import com.tws2.firma_s.logic.campaign.service.IWhatsAppAuthService;
import com.tws2.firma_s.logic.campaign.service.impl.WhatsAppAuthServiceImpl;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class WhatsAppAuthServiceImpl
implements IWhatsAppAuthService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WhatsAppAuthServiceImpl.class);
    @Autowired
    private CampaignAuthConfigRepository authConfigRepository;
    @Autowired
    private RestTemplate restTemplate;
    private final Map<String, TokenCache> tokenCacheMap = new HashMap();

    public String getAccessToken(String clientReference, String environment) {
        String cacheKey = clientReference + ":" + environment;
        TokenCache cached = (TokenCache)this.tokenCacheMap.get(cacheKey);
        if (cached != null && cached.isValid()) {
            log.info("Using cached token for {}", (Object)cacheKey);
            return cached.getAccessToken();
        }
        log.info("Authenticating for {}", (Object)cacheKey);
        String token = this.authenticate(clientReference, environment);
        return token;
    }

    private String authenticate(String clientReference, String environment) {
        TCampaignAuthConfig authConfig = (TCampaignAuthConfig)this.authConfigRepository.findByClientReferenceAndEnvironmentAndActiveTrue(clientReference, environment).orElseThrow(() -> new RuntimeException("No se encontr\u00f3 configuraci\u00f3n de autenticaci\u00f3n para " + clientReference + " en " + environment));
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            body.add((Object)"username", (Object)authConfig.getUsername());
            body.add((Object)"password", (Object)authConfig.getPassword());
            body.add((Object)"client_id", (Object)authConfig.getClientId());
            body.add((Object)"grant_type", (Object)authConfig.getGrantType());
            HttpEntity request = new HttpEntity((Object)body, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.postForEntity(authConfig.getAuthUrl(), (Object)request, AuthTokenResponse.class, new Object[0]);
            AuthTokenResponse tokenResponse = (AuthTokenResponse)response.getBody();
            if (tokenResponse != null && tokenResponse.getAccessToken() != null) {
                String cacheKey = clientReference + ":" + environment;
                Integer expiresIn = tokenResponse.getExpiresIn() != null ? tokenResponse.getExpiresIn() : 3600;
                TokenCache cache = new TokenCache(tokenResponse.getAccessToken(), expiresIn);
                this.tokenCacheMap.put(cacheKey, cache);
                log.info("Authentication successful for {}", (Object)cacheKey);
                return tokenResponse.getAccessToken();
            }
            throw new RuntimeException("No se recibi\u00f3 token de acceso en la respuesta");
        }
        catch (Exception e) {
            log.error("Error al autenticar: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("Error en autenticaci\u00f3n: " + e.getMessage(), e);
        }
    }

    public void invalidateToken(String clientReference, String environment) {
        String cacheKey = clientReference + ":" + environment;
        this.tokenCacheMap.remove(cacheKey);
        log.info("Token cache invalidated for {}", (Object)cacheKey);
    }
}

