/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.campaign.service.impl;

import com.tws2.firma_s.logic.biometria.utils.ApiResponse;
import com.tws2.firma_s.logic.campaign.model.TCampaignAuthConfig;
import com.tws2.firma_s.logic.campaign.model.TCampaignConfig;
import com.tws2.firma_s.logic.campaign.repository.CampaignAuthConfigRepository;
import com.tws2.firma_s.logic.campaign.repository.CampaignConfigRepository;
import com.tws2.firma_s.logic.campaign.service.ICampaignConfigService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class CampaignConfigServiceImpl
implements ICampaignConfigService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CampaignConfigServiceImpl.class);
    private final CampaignAuthConfigRepository authConfigRepository;
    private final CampaignConfigRepository campaignConfigRepository;
    private final RestTemplate restTemplate;
    @Value(value="${tws.client.reference:tws2}")
    private String defaultClientReference;
    @Value(value="${tws.ambiente:dev}")
    private String defaultEnvironment;

    public ApiResponse<TCampaignAuthConfig> saveAuthConfig(TCampaignAuthConfig config) {
        config.setActive(Boolean.valueOf(true));
        config.setCreatedDate(LocalDateTime.now());
        TCampaignAuthConfig saved = (TCampaignAuthConfig)this.authConfigRepository.save((Object)config);
        return ApiResponse.ok((int)200, (Object)saved);
    }

    public ApiResponse<TCampaignAuthConfig> getAuthConfig(String createdBy) {
        TCampaignAuthConfig config = (TCampaignAuthConfig)this.authConfigRepository.findByCreatedByAndActiveTrue(createdBy).orElseThrow(() -> new RuntimeException(String.format("No se encontr\u00f3 configuraci\u00f3n de autenticaci\u00f3n creada por %s", createdBy)));
        return ApiResponse.ok((int)200, (Object)config);
    }

    public ApiResponse<List<TCampaignAuthConfig>> getAllAuthConfigs(String createdBy) {
        return ApiResponse.ok((int)200, (Object)this.authConfigRepository.findAllByCreatedBy(createdBy));
    }

    public ApiResponse<String> deleteAuthConfig(Long id) {
        this.authConfigRepository.deleteById((Object)id);
        return ApiResponse.ok((int)200, (Object)"Configuraci\u00f3n de autenticaci\u00f3n eliminada exitosamente");
    }

    public ApiResponse<TCampaignConfig> saveCampaignConfig(TCampaignConfig config) {
        config.setActive(Boolean.valueOf(true));
        config.setCreatedDate(LocalDateTime.now());
        TCampaignConfig saved = (TCampaignConfig)this.campaignConfigRepository.save((Object)config);
        return ApiResponse.ok((int)200, (Object)saved);
    }

    public ApiResponse<TCampaignConfig> getCampaignConfig(String createdBy) {
        TCampaignConfig config = (TCampaignConfig)this.campaignConfigRepository.findByCreatedByAndActiveTrue(createdBy).orElseThrow(() -> new RuntimeException(String.format("No se encontr\u00f3 configuraci\u00f3n de campa\u00f1a creada por %s", createdBy)));
        return ApiResponse.ok((int)200, (Object)config);
    }

    public ApiResponse<List<TCampaignConfig>> getAllCampaignConfigs(String createdBy) {
        return ApiResponse.ok((int)200, (Object)this.campaignConfigRepository.findAllByCreatedByAndActiveTrue(createdBy));
    }

    public ApiResponse<String> deleteCampaignConfig(Long id) {
        this.campaignConfigRepository.deleteById((Object)id);
        return ApiResponse.ok((int)200, (Object)"Configuraci\u00f3n de campa\u00f1a eliminada exitosamente");
    }

    public String getTransactionToken(String clientReference, String environment) {
        TCampaignAuthConfig authConfig = (TCampaignAuthConfig)this.authConfigRepository.findByCreatedByAndActiveTrue(clientReference).orElseThrow(() -> new RuntimeException("Auth config not found for client: " + clientReference));
        return this.executeAuthRequest(authConfig);
    }

    public ApiResponse<String> sendWhatsappTemplateBatch(Map<String, Object> payload, String clientReference, String environment) {
        String token = this.getTransactionToken(clientReference, environment);
        String url = "https://tsign.tws2.io/campaign-whatsapp-firma-segura/whatsapp-campaign/send-template-batch";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setBearerAuth(token);
        HttpEntity request = new HttpEntity(payload, (MultiValueMap)headers);
        try {
            String response = (String)this.restTemplate.postForObject(url, (Object)request, String.class, new Object[0]);
            return ApiResponse.ok((int)200, (Object)response);
        }
        catch (HttpClientErrorException e) {
            log.error("Client Error sending whatsapp batch: {}", (Object)e.getResponseBodyAsString(), (Object)e);
            return ApiResponse.error((int)e.getStatusCode().value(), (String)("Error sending whatsapp: " + e.getResponseBodyAsString()));
        }
        catch (Exception e) {
            log.error("Internal Error sending whatsapp batch", (Throwable)e);
            return ApiResponse.error((int)500, (String)("Error sending whatsapp: " + e.getMessage()));
        }
    }

    private String executeAuthRequest(TCampaignAuthConfig authConfig) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"client_id", (Object)authConfig.getClientId());
        map.add((Object)"username", (Object)authConfig.getUsername());
        map.add((Object)"password", (Object)authConfig.getPassword());
        map.add((Object)"grant_type", (Object)authConfig.getGrantType());
        HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)headers);
        try {
            Map response = (Map)this.restTemplate.postForObject(authConfig.getAuthUrl(), (Object)request, Map.class, new Object[0]);
            if (response != null && response.containsKey("access_token")) {
                return (String)response.get("access_token");
            }
            throw new RuntimeException("Token Not Found in Keycloak response");
        }
        catch (Exception e) {
            log.error("Error fetching access token from {}", (Object)authConfig.getAuthUrl(), (Object)e);
            throw new RuntimeException("Failed to retrieve access token: " + e.getMessage());
        }
    }

    public String getDefaultClientReference() {
        return this.defaultClientReference;
    }

    public String getDefaultEnvironment() {
        return this.defaultEnvironment;
    }

    @Generated
    public CampaignConfigServiceImpl(CampaignAuthConfigRepository authConfigRepository, CampaignConfigRepository campaignConfigRepository, RestTemplate restTemplate) {
        this.authConfigRepository = authConfigRepository;
        this.campaignConfigRepository = campaignConfigRepository;
        this.restTemplate = restTemplate;
    }
}

