/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.biometria.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.tws2.firma_s.logic.biometria.model.TFirmanteMultiple;
import com.tws2.firma_s.logic.biometria.model.TSolicitud;
import com.tws2.firma_s.logic.biometria.model.documento.TDocumento;
import com.tws2.firma_s.logic.biometria.model.dto.CoordenadaDTO;
import com.tws2.firma_s.logic.biometria.model.dto.DocumentDTO;
import com.tws2.firma_s.logic.biometria.model.firma.TFirmaUbicacion;
import com.tws2.firma_s.logic.biometria.repository.DocumentoDAO;
import com.tws2.firma_s.logic.biometria.repository.FirmaUbicacionDAO;
import com.tws2.firma_s.logic.biometria.service.DocumentoCoreService;
import com.tws2.firma_s.logic.biometria.utils.GenerateRandomUtils;
import jakarta.transaction.Transactional;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DocumentoCoreServiceImpl
implements DocumentoCoreService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentoCoreServiceImpl.class);
    private final DocumentoDAO documentoDAO;
    private final FirmaUbicacionDAO firmaDAO;

    public List<TDocumento> guardarDocumentosNoFirmantes(List<DocumentDTO> documentosDto, TFirmanteMultiple grupo) {
        ArrayList<TDocumento> documentosGuardados = new ArrayList<TDocumento>();
        for (DocumentDTO dto : documentosDto) {
            TDocumento doc = this.crearDocumentoBase(dto, grupo);
            documentosGuardados.add(doc);
        }
        return documentosGuardados;
    }

    public TDocumento crearDocumentoBase(DocumentDTO dto, TFirmanteMultiple grupo) {
        TDocumento documento = new TDocumento();
        String codigo = dto.getCodigoDocumento() != null && !dto.getCodigoDocumento().isEmpty() ? dto.getCodigoDocumento() : GenerateRandomUtils.generarIdentificadorAleatorio();
        documento.setCodigoDocumento(codigo);
        documento.setNombre(dto.getNombre());
        documento.setTipo(dto.getTipo());
        if (dto.getPagina() != null) {
            if (dto.getPagina().isTextual()) {
                documento.setPagina(dto.getPagina().asText());
            } else {
                documento.setPagina(dto.getPagina().toString());
            }
        }
        documento.setArchivoBase64(dto.getArchivoBase64());
        documento.setFechaRegistro(LocalDateTime.now());
        documento.setGrupo(grupo);
        if (dto.getCoordenada() != null) {
            documento.setCoordenada(dto.getCoordenada().toString());
        }
        return (TDocumento)this.documentoDAO.save((Object)documento);
    }

    public List<TDocumento> guardarDocumentosConCoordenadas(List<DocumentDTO> documentosDto, TFirmanteMultiple grupo) {
        ArrayList<TDocumento> documentosGuardados = new ArrayList<TDocumento>();
        for (DocumentDTO dto : documentosDto) {
            TDocumento doc = this.crearDocumentoBase(dto, grupo);
            documentosGuardados.add(doc);
            List paginas = dto.getPaginasComoLista();
            List coordenadas = dto.getCoordenadasComoLista();
            if (paginas.isEmpty()) {
                String paginaFallback = "last";
                this.procesarCoordenadas(coordenadas, paginaFallback, doc);
                continue;
            }
            for (String pagina : paginas) {
                this.procesarCoordenadas(coordenadas, pagina, doc);
            }
        }
        return documentosGuardados;
    }

    private void procesarCoordenadas(List<String> coordenadas, String pagina, TDocumento savedDoc) {
        if (coordenadas == null || coordenadas.isEmpty()) {
            return;
        }
        for (String c : coordenadas) {
            String[] parts;
            if (c == null || c.trim().isEmpty() || (parts = c.split(",")).length < 2) continue;
            TFirmaUbicacion firma = new TFirmaUbicacion();
            firma.setDocumento(savedDoc);
            firma.setPagina(pagina);
            firma.setPosX(parts[0].trim());
            firma.setPosY(parts[1].trim());
            firma.setFechaCreacion(LocalDateTime.now());
            this.firmaDAO.save((Object)firma);
        }
    }

    @Transactional
    public List<TFirmaUbicacion> asignarCoordenadasASolicitud(TSolicitud solicitud, List<TDocumento> documentos, List<CoordenadaDTO> coordenadas) {
        ArrayList<TFirmaUbicacion> firmasGuardadas = new ArrayList<TFirmaUbicacion>();
        if (coordenadas == null || coordenadas.isEmpty()) {
            return firmasGuardadas;
        }
        for (CoordenadaDTO c : coordenadas) {
            TDocumento doc = documentos.stream().filter(d -> d.getCodigoDocumento().equals(c.getCodigoDocumento())).findFirst().orElse(null);
            if (doc == null) {
                log.warn("Documento no encontrado para c\u00f3digo: {}", (Object)c.getCodigoDocumento());
                continue;
            }
            List paginas = this.extraerLista(c.getPagina());
            List coordLista = this.extraerLista(c.getCoordenada());
            for (String coord : coordLista) {
                if (coord.contains(",")) continue;
                throw new IllegalArgumentException("Coordenada inv\u00e1lida: " + coord);
            }
            if (paginas.size() == coordLista.size()) {
                for (int i = 0; i < paginas.size(); ++i) {
                    this.crearFirma(firmasGuardadas, solicitud, doc, (String)paginas.get(i), (String)coordLista.get(i));
                }
                continue;
            }
            if (paginas.size() == 1 && coordLista.size() > 1) {
                for (String coord : coordLista) {
                    this.crearFirma(firmasGuardadas, solicitud, doc, (String)paginas.get(0), coord);
                }
                continue;
            }
            if (coordLista.size() == 1 && paginas.size() > 1) {
                for (String pag : paginas) {
                    this.crearFirma(firmasGuardadas, solicitud, doc, pag, (String)coordLista.get(0));
                }
                continue;
            }
            throw new IllegalArgumentException("Cantidad de p\u00e1ginas y coordenadas incompatible para documento " + c.getCodigoDocumento());
        }
        return firmasGuardadas;
    }

    private List<String> extraerLista(JsonNode node) {
        ArrayList<String> list = new ArrayList<String>();
        if (node == null) {
            return list;
        }
        if (node.isArray()) {
            node.forEach(n -> list.add(n.asText()));
            return list;
        }
        return List.of(node.asText());
    }

    private void crearFirma(List<TFirmaUbicacion> lista, TSolicitud solicitud, TDocumento doc, String pagina, String coord) {
        String[] xy = coord.split(",");
        String posX = xy[0].trim();
        String posY = xy[1].trim();
        TFirmaUbicacion firma = new TFirmaUbicacion();
        firma.setSolicitud(solicitud);
        firma.setDocumento(doc);
        firma.setPagina(pagina);
        firma.setPosX(posX);
        firma.setPosY(posY);
        firma.setFechaCreacion(LocalDateTime.now());
        TFirmaUbicacion guardado = (TFirmaUbicacion)this.firmaDAO.saveAndFlush((Object)firma);
        lista.add(guardado);
    }

    @Generated
    public DocumentoCoreServiceImpl(DocumentoDAO documentoDAO, FirmaUbicacionDAO firmaDAO) {
        this.documentoDAO = documentoDAO;
        this.firmaDAO = firmaDAO;
    }
}

