/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.biometria.service.impl;

import com.tws2.firma_s.logic.biometria.model.view.DocumentoDetalleView;
import com.tws2.firma_s.logic.biometria.repository.DocumentoDAO;
import com.tws2.firma_s.logic.biometria.repository.DocumentoSolicitudDAO;
import com.tws2.firma_s.logic.biometria.repository.FirmanteMultipleDAO;
import com.tws2.firma_s.logic.biometria.service.DocumentoService;
import com.tws2.firma_s.logic.biometria.utils.ApiResponse;
import com.tws2.firma_s.logic.biometria.utils.DateUtil;
import java.time.LocalDateTime;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class DocumentServiceImpl
implements DocumentoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentServiceImpl.class);
    private final DocumentoSolicitudDAO documentoSolicitudDAO;
    private final FirmanteMultipleDAO firmanteMultipleDAO;
    private final DocumentoDAO documentoDAO;

    public ResponseEntity<ApiResponse<?>> filtrarDocumentos(String cedula, String city, Boolean firmado, String fechaFirmadoInicio, String fechaFirmadoFin, Pageable pageable) {
        LocalDateTime fechaFin;
        LocalDateTime fechaInicio = DateUtil.getLocalDateTimeFromString((String)fechaFirmadoInicio);
        Page result = this.documentoSolicitudDAO.filtrarDocumentos(cedula, city, firmado, fechaInicio, fechaFin = DateUtil.getLocalDateTimeFromString((String)fechaFirmadoFin), pageable);
        return new ResponseEntity((Object)ApiResponse.ok((int)200, (Object)(result.isEmpty() ? "No se encontraron resultados" : "Consulta ejecutada correctamente"), (Page)result), (HttpStatusCode)HttpStatus.OK);
    }

    public ResponseEntity<ApiResponse<?>> FindAllDocuments(Pageable pageable) {
        Page result = this.documentoSolicitudDAO.findAllByOrderByFechaRegistroDesc(pageable);
        return new ResponseEntity((Object)ApiResponse.ok((int)200, (Object)(result.isEmpty() ? "No se encontraron resultados" : "Consulta ejecutada correctamente"), (Page)result), (HttpStatusCode)HttpStatus.OK);
    }

    public ResponseEntity<ApiResponse<?>> getPdfByCodigo(String id, String codigoDocumento) {
        DocumentoDetalleView documento = this.documentoSolicitudDAO.findByIdAndCodigoDocumento((long)Integer.parseInt(id), codigoDocumento);
        return new ResponseEntity((Object)ApiResponse.ok((int)200, (Object)documento), (HttpStatusCode)HttpStatus.OK);
    }

    public ResponseEntity<ApiResponse<?>> filtrarMultipleDocumento(String estadoDocumento, String fechaFirmadoInicio, String fechaFirmadoFin, Pageable pageable) {
        LocalDateTime fechaFin;
        LocalDateTime fechaInicio = DateUtil.getLocalDateTimeFromString((String)fechaFirmadoInicio);
        Page result = this.firmanteMultipleDAO.findOneByCodigoGrupoFirmanteMultiple(fechaInicio, fechaFin = DateUtil.getLocalDateTimeFromString((String)fechaFirmadoFin), pageable);
        return new ResponseEntity((Object)ApiResponse.ok((int)200, (Object)(result.isEmpty() ? "No se encontraron firmantes" : "Consulta ejecutada correctamente"), (Page)result), (HttpStatusCode)HttpStatus.OK);
    }

    public ResponseEntity<ApiResponse<?>> getFirmantesByCodigoGrupo(String codigoGrupo) {
        List data = this.documentoDAO.findFirmantesByCodigoGrupo(codigoGrupo);
        return new ResponseEntity((Object)ApiResponse.ok((int)200, (Object)data), (HttpStatusCode)HttpStatus.OK);
    }

    public ResponseEntity<ApiResponse<?>> getDocumentosByCodigoGrupo(String codigoGrupo) {
        List data = this.documentoDAO.findDocumentosByCodigoGrupo(codigoGrupo);
        return new ResponseEntity((Object)ApiResponse.ok((int)200, (Object)data), (HttpStatusCode)HttpStatus.OK);
    }

    @Generated
    public DocumentServiceImpl(DocumentoSolicitudDAO documentoSolicitudDAO, FirmanteMultipleDAO firmanteMultipleDAO, DocumentoDAO documentoDAO) {
        this.documentoSolicitudDAO = documentoSolicitudDAO;
        this.firmanteMultipleDAO = firmanteMultipleDAO;
        this.documentoDAO = documentoDAO;
    }
}

