/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.biometria.controller;

import com.tws2.firma_s.logic.biometria.model.CertificadoRequest;
import com.tws2.firma_s.logic.biometria.service.CallbackService;
import com.tws2.firma_s.logic.biometria.service.SolicitudService;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FirmanteController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FirmanteController.class);
    private final SolicitudService solicitudService;
    private final CallbackService callbackService;
    protected final Environment env;

    @PostMapping(value={"/proceso/getInformacion4firma"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<?> getInformacion4Firma(@RequestParam(value="dni", required=true) String dni) {
        return this.solicitudService.getInformacion4Firma(dni);
    }

    @PostMapping(value={"/guardar"})
    public ResponseEntity<String> guardarCertificado(@RequestBody CertificadoRequest request) {
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(request.getBase64());
            Path path = Path.of(this.env.getProperty("ruta.temporal.firma"), request.getNombre() + ".p12");
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (FileOutputStream fos = new FileOutputStream(path.toFile());){
                fos.write(decodedBytes);
            }
            return ResponseEntity.ok((Object)("Certificado guardado en: " + path.toAbsolutePath()));
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error al guardar el certificado: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/firmar-internamente"})
    public void firmarInternamente(@RequestParam(value="referenceTransaction", required=true) String referenceTransaction) {
        this.callbackService.procesarFirmadoYReenvio(referenceTransaction);
    }

    @Generated
    public FirmanteController(SolicitudService solicitudService, CallbackService callbackService, Environment env) {
        this.solicitudService = solicitudService;
        this.callbackService = callbackService;
        this.env = env;
    }
}

