/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.biometria.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.tws2.firma_s.logic.biometria.service.CallbackService;
import com.tws2.firma_s.logic.biometria.service.SolicitudService;
import com.tws2.firma_s.logic.biometria.utils.ValidationUtils;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class FirmaSeguraController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FirmaSeguraController.class);
    private final SolicitudService solicitudService;
    private final CallbackService callbackService;
    protected final Environment env;

    @PostMapping(value={"/solicitud-firma"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> guardarSolicitud(@RequestParam(value="codigoDactilar", required=true) String codigoDactilar, @RequestParam(value="telefono", required=true) String telefono, @RequestParam(value="ciudad", required=true) String ciudad, @RequestParam(value="direccion", required=true) String direccion, @RequestParam(value="email", required=true) String email, @RequestParam(value="tiempoValidoLink", required=true) String tiempoVidaLink, @RequestParam(value="callbackUrl", required=false) String callbackUrl, @RequestParam(value="identificacion", required=true) String identificacion) {
        log.info("Inicia proceso para guardar solicitud de firma segura");
        ValidationUtils.ValidarSolicitud((String)codigoDactilar, (String)telefono, (String)ciudad, (String)direccion, (String)callbackUrl, (String)identificacion, (String)tiempoVidaLink, (String)email);
        return this.solicitudService.saveSolicitud(codigoDactilar, telefono, ciudad, direccion, callbackUrl, identificacion, tiempoVidaLink, email);
    }

    @PostMapping(value={"/v2/solicitud/biometria_firma"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> callbiometriaFirmaFlujoUnico(@RequestParam(value="codigoCliente", required=false) String codigoCliente, @RequestParam(value="identificacion", required=false) String identificacion, @RequestParam(value="codigoDactilar", required=false) String codigoDactilar, @RequestParam(value="tiempoValidoLink", required=false) String tiempoVidaLink, @RequestParam(value="nombres", required=false) String nombres, @RequestParam(value="apellido_paterno", required=false) String apellidoPaterno, @RequestParam(value="apellido_materno", required=false) String apellidoMaterno, @RequestParam(value="email", required=false) String email, @RequestParam(value="celular", required=false) String celular, @RequestParam(value="domicilio", required=false) String domicilio, @RequestParam(value="ciudad", required=false) String ciudad, @RequestParam(value="documentos", required=false) String documentos, @RequestParam(value="callback", required=false) String callback, @RequestParam(value="motivo", required=false) String motivo, @RequestParam(value="origen", required=false) String origen, @RequestParam(value="canal", required=false) String canal, @RequestParam(value="provider", required=false) String provider, @RequestParam(value="tiempoValidoLink", required=false) String tiempoValidoLink) throws JsonMappingException, JsonProcessingException {
        ValidationUtils.validarParamsFirmaFlujoUnico((String)codigoCliente, (String)identificacion, (String)nombres, (String)apellidoPaterno, (String)apellidoMaterno, (String)email, (String)celular, (String)domicilio, (String)ciudad, (String)documentos, (String)callback, (String)motivo, (String)origen);
        return this.solicitudService.SolicitudGenericBiometriaFirma(codigoCliente, identificacion, codigoDactilar, nombres, apellidoPaterno, apellidoMaterno, email, celular, domicilio, ciudad, documentos, motivo, origen, callback, tiempoValidoLink, canal);
    }

    @PostMapping(value={"/solicitud-biometria"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> guardarSolicitudBiometria(@RequestParam(value="codigoCliente", required=false) String codigoCliente, @RequestParam(value="identificacion", required=false) String identificacion, @RequestParam(value="codigoDactilar", required=false) String codigoDactilar, @RequestParam(value="tiempoValidoLink", required=false) String tiempoVidaLink, @RequestParam(value="nombres", required=false) String nombres, @RequestParam(value="apellido_paterno", required=false) String apellidoPaterno, @RequestParam(value="apellido_materno", required=false) String apellidoMaterno, @RequestParam(value="email", required=false) String email, @RequestParam(value="celular", required=false) String celular, @RequestParam(value="domicilio", required=false) String domicilio, @RequestParam(value="ciudad", required=false) String ciudad, @RequestParam(value="callback", required=false) String callback, @RequestParam(value="motivo", required=false) String motivo, @RequestParam(value="origen", required=false) String origen, @RequestParam(value="canal", required=false) String canal, @RequestParam(value="provider", required=false) String provider, @RequestParam(value="tiempoValidoLink", required=false) String tiempoValidoLink) throws JsonMappingException, JsonProcessingException {
        log.info("Inicia proceso para guardar solicitud de firma segura");
        ValidationUtils.ValidarBiometria((String)codigoCliente, (String)identificacion, (String)codigoDactilar, (String)nombres, (String)apellidoPaterno, (String)apellidoMaterno, (String)email, (String)celular, (String)domicilio, (String)ciudad, (String)motivo, (String)origen, (String)callback, (String)tiempoValidoLink, (String)canal);
        return this.solicitudService.solicitudBiometriaSimple(codigoCliente, identificacion, codigoDactilar, nombres, apellidoPaterno, apellidoMaterno, email, celular, domicilio, ciudad, motivo, origen, callback, tiempoValidoLink, canal);
    }

    @PostMapping(value={"/solicitud-multiples-firmantes"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> guardarMultiplesSolicitudes(@RequestParam(value="firmantes", required=true) String firmantes, @RequestParam(value="tiempoValidoLink", required=true) String tiempoVidaLink, @RequestParam(value="callbackUrl", required=false) String callbackUrl, @RequestParam(value="documentos", required=true) String documentos, @RequestParam(value="motivo", required=false) String motivo) throws JsonMappingException, JsonProcessingException, NumberFormatException {
        ValidationUtils.validarParamsMultiplesFirmantes((String)firmantes, (String)tiempoVidaLink, (String)callbackUrl, (String)documentos, (String)motivo);
        return this.solicitudService.saveMultiplesFirmantes(firmantes, tiempoVidaLink, callbackUrl, documentos, motivo);
    }

    @PostMapping(value={"/v1/solicitud/firma"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> firmarDocumentos(@RequestParam(value="identification") String identification, @RequestParam(value="referenceTransaction") String referenceTransaction, @RequestParam(value="certificate") String certificate, @RequestParam(value="password") String password, @RequestParam(value="documentos") String documentos) throws JsonMappingException, JsonProcessingException {
        return this.callbackService.firmarDocumentos(identification, referenceTransaction, certificate, password, documentos);
    }

    @PostMapping(value={"/v2/solicitud/biometria"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> solicitudBiometriaSimple(@RequestParam(value="codigoCliente", required=false) String codigoCliente, @RequestParam(value="identificacion", required=false) String identificacion, @RequestParam(value="codigoDactilar", required=false) String codigoDactilar, @RequestParam(value="nombres", required=false) String nombres, @RequestParam(value="apellido_paterno", required=false) String apellidoPaterno, @RequestParam(value="apellido_materno", required=false) String apellidoMaterno, @RequestParam(value="email", required=false) String email, @RequestParam(value="celular", required=false) String celular, @RequestParam(value="domicilio", required=false) String domicilio, @RequestParam(value="ciudad", required=false) String ciudad, @RequestParam(value="callback", required=false) String callback, @RequestParam(value="motivo", required=false) String motivo, @RequestParam(value="origen", required=false) String origen, @RequestParam(value="canal", required=false) String canal, @RequestParam(value="tiempoValidoLink", required=false) String tiempoValidoLink) throws JsonMappingException, JsonProcessingException {
        ValidationUtils.validarParamsBiometriaSimple((String)codigoCliente, (String)identificacion, (String)nombres, (String)apellidoPaterno, (String)apellidoMaterno, (String)email, (String)celular, (String)domicilio, (String)ciudad, (String)callback, (String)motivo, (String)origen);
        return this.solicitudService.solicitudBiometriaSimple(codigoCliente, identificacion, codigoDactilar, nombres, apellidoPaterno, apellidoMaterno, email, celular, domicilio, ciudad, motivo, origen, callback, tiempoValidoLink, canal);
    }

    @PostMapping(value={"/v2/solicitud/register-sign"}, consumes={"multipart/form-data"})
    public ResponseEntity<?> registrarDocumentosYFirmar(@RequestParam(value="referenceTransaction", required=true) String referenceTransaction, @RequestParam(value="documentos", required=true) String documentos) throws JsonMappingException, JsonProcessingException {
        ValidationUtils.ValidarSolicitudDocumentos((String)referenceTransaction, (String)"skip", (String)"skip", (String)"skip", (String)"skip", (String)"skip", (String)"skip", (String)"skip", (String)"skip", (String)documentos);
        return this.solicitudService.registrarDocumentosYFirmar(referenceTransaction, documentos);
    }

    @Generated
    public FirmaSeguraController(SolicitudService solicitudService, CallbackService callbackService, Environment env) {
        this.solicitudService = solicitudService;
        this.callbackService = callbackService;
        this.env = env;
    }
}

