/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.biometria.controller;

import com.tws2.firma_s.logic.biometria.service.DocumentoService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/doc/"})
public class DocumentoController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DocumentoController.class);
    private final DocumentoService documentoService;

    @PostMapping(value={"filter"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<?> filtrarDocumentos(@RequestParam(value="cedula", required=false) String cedula, @RequestParam(value="ciudad", required=false) String ciudad, @RequestParam(value="firmado", required=false) Boolean firmado, @RequestParam(value="fechaFirmadoInicio", required=false) String fechaFirmadoInicio, @RequestParam(value="fechaFirmadoFin", required=false) String fechaFirmadoFin, Pageable pageable) {
        return this.documentoService.filtrarDocumentos(cedula, ciudad, firmado, fechaFirmadoInicio, fechaFirmadoFin, pageable);
    }

    @PostMapping(value={"getPdfByCode"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<?> getPdfByCode(@RequestParam(value="idDocumento", required=true) String idDocumento, @RequestParam(value="codigo", required=true) String codigo) {
        log.info("idDocumento {} codigo {}", (Object)idDocumento, (Object)codigo);
        return this.documentoService.getPdfByCodigo(idDocumento, codigo);
    }

    @PostMapping(value={"multiple-documents"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<?> filtrarMultipleDocumento(@RequestParam(value="estadoDocumento", required=false) String estadoDocumento, @RequestParam(value="fechaFirmadoInicio", required=false) String fechaFirmadoInicio, @RequestParam(value="fechaFirmadoFin", required=false) String fechaFirmadoFin, Pageable pageable) {
        return this.documentoService.filtrarMultipleDocumento(estadoDocumento, fechaFirmadoInicio, fechaFirmadoFin, pageable);
    }

    @PostMapping(value={"firmantes"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<?> getFirmantesByCodigoGrupo(@RequestParam(value="codigoGrupo", required=true) String codigoGrupo) {
        return this.documentoService.getFirmantesByCodigoGrupo(codigoGrupo);
    }

    @PostMapping(value={"find-all-documents"}, consumes={"application/x-www-form-urlencoded"})
    public ResponseEntity<?> findAllDocuments(@RequestParam(value="codigoGrupo", required=true) String codigoGrupo) {
        return this.documentoService.getDocumentosByCodigoGrupo(codigoGrupo);
    }

    @Generated
    public DocumentoController(DocumentoService documentoService) {
        this.documentoService = documentoService;
    }
}

