/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.mail.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tws2.firma_s.logic.mail.model.TMailConfiguracion;
import com.tws2.firma_s.logic.mail.model.dto.MailConfiguracionDTO;
import com.tws2.firma_s.logic.mail.repository.MailConfiguracionDAO;
import com.tws2.firma_s.logic.mail.service.MailConfigurationService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MailConfigurationServiceImpl
implements MailConfigurationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MailConfigurationServiceImpl.class);
    private final MailConfiguracionDAO mailConfiguracionDAO;
    private final ObjectMapper objectMapper;

    @Transactional
    public MailConfiguracionDTO saveOrUpdate(MailConfiguracionDTO dto) {
        TMailConfiguracion entity = this.mailConfiguracionDAO.findByCodigoConfiguracion(dto.getCodigoEmail()).orElse(new TMailConfiguracion());
        entity.setCodigoConfiguracion(dto.getCodigoEmail());
        entity.setAsunto(dto.getAsunto());
        entity.setContenido(dto.getContenido());
        entity.setIsHtml(dto.getContentisHtml());
        try {
            entity.setDestinatarios(this.objectMapper.writeValueAsString((Object)dto.getDestinatarios()));
            entity.setArchivos(this.objectMapper.writeValueAsString((Object)dto.getArchivos()));
        }
        catch (JsonProcessingException e) {
            log.error("Error serializing list to JSON", (Throwable)e);
            throw new RuntimeException("Error processing configuration data", e);
        }
        if (entity.getId() == null) {
            entity.setActive(Boolean.valueOf(true));
        }
        TMailConfiguracion saved = (TMailConfiguracion)this.mailConfiguracionDAO.save((Object)entity);
        return this.convertToDTO(saved);
    }

    public MailConfiguracionDTO getByCodigo(String codigo) {
        return this.mailConfiguracionDAO.findByCodigoConfiguracion(codigo).map(arg_0 -> this.convertToDTO(arg_0)).orElseThrow(() -> new RuntimeException("Configuration not found matching code: " + codigo));
    }

    public String getPreview(String codigo) {
        TMailConfiguracion entity = (TMailConfiguracion)this.mailConfiguracionDAO.findByCodigoConfiguracion(codigo).orElseThrow(() -> new RuntimeException("Configuration not found matching code: " + codigo));
        return entity.getContenido();
    }

    private MailConfiguracionDTO convertToDTO(TMailConfiguracion entity) {
        try {
            ArrayList destinatarios = entity.getDestinatarios() != null ? (List)this.objectMapper.readValue(entity.getDestinatarios(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */) : new ArrayList();
            ArrayList archivos = entity.getArchivos() != null ? (List)this.objectMapper.readValue(entity.getArchivos(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */) : new ArrayList();
            return MailConfiguracionDTO.builder().codigoEmail(entity.getCodigoConfiguracion()).asunto(entity.getAsunto()).contenido(entity.getContenido()).contentisHtml(entity.getIsHtml()).destinatarios(destinatarios).archivos(archivos).build();
        }
        catch (JsonProcessingException e) {
            log.error("Error deserializing JSON to list", (Throwable)e);
            return MailConfiguracionDTO.builder().codigoEmail(entity.getCodigoConfiguracion()).asunto(entity.getAsunto()).contenido(entity.getContenido()).contentisHtml(entity.getIsHtml()).destinatarios(Collections.emptyList()).archivos(Collections.emptyList()).build();
        }
    }

    public String renderPreview(MailConfiguracionDTO dto) {
        return dto.getContenido() != null ? dto.getContenido() : "";
    }

    @Generated
    public MailConfigurationServiceImpl(MailConfiguracionDAO mailConfiguracionDAO, ObjectMapper objectMapper) {
        this.mailConfiguracionDAO = mailConfiguracionDAO;
        this.objectMapper = objectMapper;
    }
}

