/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.biometria.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.tws2.firma_s.exceptions.CustomException;
import com.tws2.firma_s.logic.biometria.model.TUsuario;
import com.tws2.firma_s.logic.biometria.model.dto.DocumentDTO;
import com.tws2.firma_s.logic.biometria.model.dto.SolicitudDTO;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;

/*
 * Exception performing whole class analysis ignored.
 */
public class ValidationUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValidationUtils.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static void ValidarBiometria(String codigoCliente, String identificacion, String codigoDactilar, String nombres, String apellidoPaterno, String apellidoMaterno, String email, String celular, String domicilio, String ciudad, String motivo, String origen, String callback, String tiempoValidoLink, String canal) {
        StringBuilder errores = new StringBuilder();
        if (codigoCliente == null || codigoCliente.isEmpty()) {
            errores.append("codigoCliente, ");
        }
        if (identificacion == null || identificacion.isEmpty()) {
            errores.append("identificacion, ");
        }
        if (nombres == null || nombres.isEmpty()) {
            errores.append("nombres, ");
        }
        if (apellidoPaterno == null || apellidoPaterno.isEmpty()) {
            errores.append("apellido_paterno, ");
        }
        if (apellidoMaterno == null || apellidoMaterno.isEmpty()) {
            errores.append("apellido_materno, ");
        }
        if (email == null || email.isEmpty()) {
            errores.append("email, ");
        }
        if (celular == null || celular.isEmpty()) {
            errores.append("celular, ");
        }
        if (domicilio == null || domicilio.isEmpty()) {
            errores.append("domicilio, ");
        }
        if (ciudad == null || ciudad.isEmpty()) {
            errores.append("ciudad, ");
        }
        if (callback == null || callback.isEmpty()) {
            errores.append("callback, ");
        }
        if (motivo == null || motivo.isEmpty()) {
            errores.append("motivo, ");
        }
        if (errores.length() > 0) {
            errores.setLength(errores.length() - 2);
            String errorMessage = "Faltan los siguientes par\u00e1metros: " + errores.toString();
            throw new CustomException(errorMessage, HttpStatus.BAD_REQUEST);
        }
    }

    public static void ValidarSolicitud(String fingerCode, String telefono, String city, String address, String callbackUrl, String identificationNumber, String validationLinkLifeTime, String email) {
        StringBuilder errores = new StringBuilder();
        if (fingerCode == null || fingerCode.isEmpty()) {
            errores.append("El codigo Dactilar (fingerCode) es un campo obligatorio");
        }
        if (telefono == null || telefono.isEmpty()) {
            errores.append("El numero de contacto es obligatorio");
        }
        if (city == null || city.isEmpty()) {
            errores.append("la ciudad es un campo obligatorio");
        }
        if (address == null || address.isEmpty()) {
            errores.append("La direcci\u00f3n es un campo obligatorio");
        }
        if (callbackUrl == null || callbackUrl.isEmpty()) {
            // empty if block
        }
        if (identificationNumber == null || identificationNumber.isEmpty()) {
            errores.append("El n\u00famero de identificaci\u00f3n es obligatorio");
        }
        if (email == null || email.isEmpty()) {
            errores.append("El correo electr\u00f3nico es un campo obligatorio");
        }
        if (errores.length() > 0) {
            errores.setLength(errores.length() - 2);
            String errorMessage = "faltan los siguientes parametros" + errores.toString();
            throw new CustomException("Faltan los siguientes parametros" + errorMessage, HttpStatus.BAD_REQUEST);
        }
    }

    public static void validarParamsBiometriaSimple(String codigoCliente, String identificacion, String nombres, String apellidoPaterno, String apellidoMaterno, String email, String celular, String domicilio, String ciudad, String callback, String motivo, String origen) {
        StringBuilder errores = new StringBuilder();
        if (codigoCliente == null || codigoCliente.isEmpty()) {
            errores.append("codigoCliente, ");
        }
        if (identificacion == null || identificacion.isEmpty()) {
            errores.append("identificacion, ");
        }
        if (nombres == null || nombres.isEmpty()) {
            errores.append("nombres, ");
        }
        if (apellidoPaterno == null || apellidoPaterno.isEmpty()) {
            errores.append("apellido_paterno, ");
        }
        if (apellidoMaterno == null || apellidoMaterno.isEmpty()) {
            errores.append("apellido_materno, ");
        }
        if (email == null || email.isEmpty()) {
            errores.append("email, ");
        }
        if (celular == null || celular.isEmpty()) {
            errores.append("celular, ");
        }
        if (domicilio == null || domicilio.isEmpty()) {
            errores.append("domicilio, ");
        }
        if (ciudad == null || ciudad.isEmpty()) {
            errores.append("ciudad, ");
        }
        if (callback == null || callback.isEmpty()) {
            errores.append("callback, ");
        }
        if (motivo == null || motivo.isEmpty()) {
            errores.append("motivo, ");
        }
        if (errores.length() > 0) {
            errores.setLength(errores.length() - 2);
            String errorMessage = "Faltan los siguientes par\u00e1metros: " + errores.toString();
            throw new CustomException(errorMessage, HttpStatus.BAD_REQUEST);
        }
    }

    public static void validarParamsFirmaFlujoUnico(String codigoCliente, String identificacion, String nombres, String apellidoPaterno, String apellidoMaterno, String email, String celular, String domicilio, String ciudad, String documentos, String callback, String motivo, String origen) {
        StringBuilder errores = new StringBuilder();
        if (codigoCliente == null || codigoCliente.isEmpty()) {
            errores.append("codigoCliente, ");
        }
        if (identificacion == null || identificacion.isEmpty()) {
            errores.append("identificacion, ");
        }
        if (nombres == null || nombres.isEmpty()) {
            errores.append("nombres, ");
        }
        if (apellidoPaterno == null || apellidoPaterno.isEmpty()) {
            errores.append("apellido_paterno, ");
        }
        if (apellidoMaterno == null || apellidoMaterno.isEmpty()) {
            errores.append("apellido_materno, ");
        }
        if (email == null || email.isEmpty()) {
            errores.append("email, ");
        }
        if (celular == null || celular.isEmpty()) {
            errores.append("celular, ");
        }
        if (domicilio == null || domicilio.isEmpty()) {
            errores.append("domicilio, ");
        }
        if (ciudad == null || ciudad.isEmpty()) {
            errores.append("ciudad, ");
        }
        if (documentos == null || documentos.isEmpty()) {
            errores.append("documentos, ");
        }
        if (callback == null || callback.isEmpty()) {
            errores.append("callback, ");
        }
        if (motivo == null || motivo.isEmpty()) {
            errores.append("motivo, ");
        }
        if (errores.length() > 0) {
            errores.setLength(errores.length() - 2);
            String errorMessage = "Faltan los siguientes par\u00e1metros: " + errores.toString();
            throw new CustomException(errorMessage, HttpStatus.BAD_REQUEST);
        }
    }

    public static void ValidarSolicitudDocumentos(String referenceTransaction, String fingerCode, String telefono, String city, String address, String callbackUrl, String identificationNumber, String validationLinkLifeTime, String email, String documentos) {
        StringBuilder errores = new StringBuilder();
        if (referenceTransaction == null || referenceTransaction.isEmpty()) {
            errores.append("referenceTransaction es un campo obligatorio");
        }
        if (fingerCode == null || fingerCode.isEmpty()) {
            errores.append("El codigo Dactilar (fingerCode) es un campo obligatorio");
        }
        if (telefono == null || telefono.isEmpty()) {
            errores.append("El numero de contacto es obligatorio");
        }
        if (city == null || city.isEmpty()) {
            errores.append("la ciudad es un campo obligatorio");
        }
        if (address == null || address.isEmpty()) {
            errores.append("La direcci\u00f3n es un campo obligatorio");
        }
        if (callbackUrl == null || callbackUrl.isEmpty()) {
            errores.append("El callbackUrl es un campo obligatorio");
        }
        if (identificationNumber == null || identificationNumber.isEmpty()) {
            errores.append("El n\u00famero de identificaci\u00f3n es obligatorio");
        }
        if (email == null || email.isEmpty()) {
            errores.append("El correo electr\u00f3nico es un campo obligatorio");
        }
        if (documentos == null || documentos.isEmpty()) {
            errores.append("El campo 'documentos' es obligatorio y no puede estar vac\u00edo. ");
        } else {
            try {
                List listaDocs = (List)MAPPER.readValue(documentos, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                if (listaDocs.isEmpty()) {
                    errores.append("Debe enviar al menos un documento en 'documentos'. ");
                } else {
                    for (DocumentDTO doc : listaDocs) {
                        if (doc.getCodigoDocumento() == null || doc.getCodigoDocumento().isEmpty()) {
                            errores.append("codigoDoc es obligatorio en uno de los documentos. ");
                        }
                        if (doc.getNombre() == null || doc.getNombre().isEmpty()) {
                            errores.append("nombreDoc es obligatorio en uno de los documentos. ");
                        }
                        if (doc.getArchivoBase64() == null || doc.getArchivoBase64().isEmpty()) {
                            errores.append("pdfBase64 es obligatorio en uno de los documentos. ");
                        }
                        if (doc.getCoordenadasComoLista().isEmpty()) {
                            errores.append("Debe proporcionar al menos una coordenada por documento. ");
                        }
                        if (doc.getPaginasComoLista().isEmpty()) {
                            errores.append("Debe proporcionar al menos una pagina por documento. ");
                        }
                        if (doc.getTipo() != null && !doc.getTipo().isEmpty()) continue;
                        errores.append("Debe proporcionar al menos una tipo por documento. ");
                    }
                }
            }
            catch (Exception e) {
                errores.append("El formato del campo 'documentos' no es v\u00e1lido JSON. ");
            }
        }
        if (errores.length() > 0) {
            errores.setLength(errores.length() - 2);
            String errorMessage = "faltan los siguientes parametros" + errores.toString();
            throw new CustomException("Faltan los siguientes parametros" + errorMessage, HttpStatus.BAD_REQUEST);
        }
    }

    public static JsonNode validateBiometricObject(String jsonRaw) {
        try {
            JsonNode root = MAPPER.readTree(jsonRaw);
            if (!root.has("status") || !root.has("referenceTransaction")) {
                throw new IllegalArgumentException("Faltan campos esenciales: status o referenceTransaction");
            }
            if (root.has("data") && root.get("data").has("imageData")) {
                for (JsonNode image : root.get("data").get("imageData")) {
                    if (image.get("image") != null && !image.get("image").asText().isBlank()) continue;
                    ((ObjectNode)image).put("image", "");
                }
            }
            if ("ERROR".equalsIgnoreCase(root.get("status").asText()) && !root.has("errorMessage")) {
                ((ObjectNode)root).set("errorMessage", (JsonNode)MAPPER.createObjectNode().put("error", "Error no especificado"));
            }
            if (!root.has("indicator")) {
                ((ObjectNode)root).set("indicator", (JsonNode)MAPPER.createObjectNode());
            }
            return root;
        }
        catch (Exception e) {
            throw new RuntimeException("JSON inv\u00e1lido o malformado", e);
        }
    }

    public static String validationLifeTimeLink(String lifeTimeLink) {
        if (lifeTimeLink == null || lifeTimeLink.trim().isEmpty()) {
            return "1440";
        }
        return lifeTimeLink;
    }

    public static void validarParamsMultiplesFirmantes(String firmantesJson, String tiempoVidaLink, String callbackUrl, String documentosJson, String motivo) {
        StringBuilder errores = new StringBuilder();
        if (tiempoVidaLink == null || tiempoVidaLink.isBlank()) {
            errores.append("Debe especificar el tiempo de vida del link. ");
        }
        if (motivo == null || motivo.isBlank()) {
            errores.append("Debe especificar el motivo de la solicitud. ");
        }
        try {
            List listaDocs = (List)MAPPER.readValue(documentosJson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (listaDocs.isEmpty()) {
                errores.append("Debe enviar al menos un documento en 'documentos'. ");
            } else {
                for (DocumentDTO doc : listaDocs) {
                    if (ValidationUtils.isBlank((String)doc.getCodigoDocumento())) {
                        errores.append("codigoDocumento es obligatorio en uno de los documentos. ");
                    }
                    if (ValidationUtils.isBlank((String)doc.getNombre())) {
                        errores.append("nombreDoc es obligatorio en uno de los documentos. ");
                    }
                    if (ValidationUtils.isBlank((String)doc.getArchivoBase64())) {
                        errores.append("archivoBase64 es obligatorio en uno de los documentos. ");
                    }
                    if (ValidationUtils.isBlank(doc.getPagina() != null ? doc.getPagina().toString() : null)) {
                        errores.append("pagina es obligatoria en uno de los documentos. ");
                    }
                    if (!ValidationUtils.isBlank((String)doc.getTipo())) continue;
                    errores.append("tipo es obligatorio en uno de los documentos. ");
                }
            }
        }
        catch (Exception e) {
            errores.append("El formato del campo 'documentos' no es un JSON v\u00e1lido. ");
        }
        try {
            List listaFirmantes = (List)MAPPER.readValue(firmantesJson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (listaFirmantes.isEmpty()) {
                errores.append("Debe enviar al menos un firmante en 'firmantes'. ");
            } else {
                for (SolicitudDTO f : listaFirmantes) {
                    ValidationUtils.validarFirmante((SolicitudDTO)f, (StringBuilder)errores);
                }
            }
        }
        catch (Exception e) {
            errores.append("El formato del campo 'firmantes' no es un JSON v\u00e1lido. ");
        }
        if (errores.length() > 0) {
            throw new IllegalArgumentException("Errores de validaci\u00f3n: " + errores.toString());
        }
    }

    private static void validarFirmante(SolicitudDTO f, StringBuilder errores) {
        if (ValidationUtils.isBlank((String)f.getCodigoCliente())) {
            errores.append("El c\u00f3digoCliente es obligatorio para todos los firmantes. ");
        }
        if (ValidationUtils.isBlank((String)f.getCodigoDactilar())) {
            errores.append("El c\u00f3digo dactilar es obligatorio para todos los firmantes. ");
        }
        if (ValidationUtils.isBlank((String)f.getNombres())) {
            errores.append("El nombre es obligatorio para todos los firmantes. ");
        }
        if (ValidationUtils.isBlank((String)f.getApellido_paterno())) {
            errores.append("El apellido_paterno es obligatorio para todos los firmantes. ");
        }
        if (ValidationUtils.isBlank((String)f.getApellido_materno())) {
            errores.append("El apellido_materno es obligatorio para todos los firmantes. ");
        }
        if (ValidationUtils.isBlank((String)f.getIdentificacion())) {
            errores.append("La identificaci\u00f3n es obligatoria para todos los firmantes. ");
        }
        if (ValidationUtils.isBlank((String)f.getEmail())) {
            errores.append("El email es obligatorio para todos los firmantes. ");
        }
        if (ValidationUtils.isBlank((String)f.getCelular())) {
            errores.append("El celular es obligatorio para todos los firmantes. ");
        }
        if (ValidationUtils.isBlank((String)f.getCiudad())) {
            errores.append("La ciudad es obligatoria para todos los firmantes. ");
        }
        if (ValidationUtils.isBlank((String)f.getDomicilio())) {
            errores.append("La direccion es obligatoria para todos los firmantes. ");
        }
        if (f.getCoordenadas() == null || f.getCoordenadas().isEmpty()) {
            errores.append("Debe especificar al menos una coordenada por firmante. ");
        }
    }

    private static boolean isBlank(String value) {
        return value == null || value.isEmpty();
    }

    @NonNull
    public static TUsuario validarUsuario(TUsuario usuario) {
        if (ValidationUtils.isBlank((String)usuario.getNombres())) {
            throw new IllegalArgumentException("El nombre es obligatorio para todos los firmantes. ");
        }
        if (ValidationUtils.isBlank((String)usuario.getApellidoPaterno())) {
            throw new IllegalArgumentException("El apellido_paterno es obligatorio para todos los firmantes. ");
        }
        if (ValidationUtils.isBlank((String)usuario.getApellidoMaterno())) {
            throw new IllegalArgumentException("El apellido_materno es obligatorio para todos los firmantes. ");
        }
        if (ValidationUtils.isBlank((String)usuario.getIdentificacion())) {
            throw new IllegalArgumentException("La identificaci\u00f3n es obligatoria para todos los firmantes. ");
        }
        if (ValidationUtils.isBlank((String)usuario.getEmail())) {
            throw new IllegalArgumentException("El email es obligatorio para todos los firmantes. ");
        }
        if (ValidationUtils.isBlank((String)usuario.getTelefono())) {
            throw new IllegalArgumentException("El telefono es obligatorio para todos los firmantes. ");
        }
        if (ValidationUtils.isBlank((String)usuario.getCiudad())) {
            throw new IllegalArgumentException("La ciudad es obligatoria para todos los firmantes. ");
        }
        if (ValidationUtils.isBlank((String)usuario.getDireccion())) {
            throw new IllegalArgumentException("La direccion es obligatoria para todos los firmantes. ");
        }
        if (ValidationUtils.isBlank((String)usuario.getCodigoDactilar())) {
            throw new IllegalArgumentException("El codigoDactilar es obligatorio para todos los firmantes. ");
        }
        return usuario;
    }
}

