/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.biometria.utils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;

public class DateUtil {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");

    public static LocalDateTime convertDateToLocalDateTime(Date fecha) {
        LocalDateTime localDateTime = fecha.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        return localDateTime;
    }

    public static LocalDateTime getLocalDateTimeFromString(String dateString) {
        if (dateString == null || dateString.isBlank()) {
            return null;
        }
        try {
            if (dateString.length() == 10) {
                return LocalDate.parse(dateString).atStartOfDay();
            }
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            return LocalDateTime.parse(dateString, formatter);
        }
        catch (DateTimeParseException e) {
            return LocalDateTime.parse(dateString);
        }
    }

    public static LocalDate parseDate(String dateStr) {
        try {
            return dateStr != null ? LocalDateTime.parse(dateStr, DATE_TIME_FORMATTER).toLocalDate() : null;
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException("Formato de fecha inv\u00e1lido: " + dateStr);
        }
    }
}

