/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.biometria.service.impl;

import com.tws2.firma_s.exceptions.CustomException;
import com.tws2.firma_s.logic.biometria.model.TUsuario;
import com.tws2.firma_s.logic.biometria.repository.UsuarioDAO;
import com.tws2.firma_s.logic.biometria.service.UsuarioService;
import com.tws2.firma_s.logic.biometria.utils.ApiResponse;
import com.tws2.firma_s.logic.biometria.utils.DecriptUtils;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class UsuarioServiceImpl
implements UsuarioService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UsuarioServiceImpl.class);
    private final UsuarioDAO usuarioDAO;
    private final DecriptUtils decriptUtils;

    public ResponseEntity<ApiResponse<?>> findUserByUserName(String username) {
        log.info("nombre de usuario" + username);
        TUsuario usuario = this.usuarioDAO.findUsuarioByUsername(this.decriptUtils.encrypt(username));
        usuario = this.decriptUtils.decryptUsuario(usuario);
        if (null == usuario) {
            throw new CustomException("No existe un registro con esta referencia de transacci\u00f3n", HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity((Object)ApiResponse.ok((int)200, (Object)usuario), (HttpStatusCode)HttpStatus.OK);
    }

    public ResponseEntity<ApiResponse<?>> saveUser(TUsuario usuario) {
        if (this.usuarioDAO.findUsuarioByIdentificacion((usuario = this.decriptUtils.encryptUsuario(usuario)).getIdentificacion()) != null) {
            throw new CustomException("Ya existe un usuario con esta identificaci\u00f3n", HttpStatus.BAD_REQUEST);
        }
        this.usuarioDAO.save((Object)usuario);
        return new ResponseEntity((Object)ApiResponse.ok((int)200, (Object)"Usuario guardado exitosamente"), (HttpStatusCode)HttpStatus.OK);
    }

    public ResponseEntity<ApiResponse<?>> findUserByIdentification(String identification) {
        log.info("identificacion de usuario" + identification);
        TUsuario usuario = this.usuarioDAO.findUsuarioByIdentificacion(this.decriptUtils.encrypt(identification));
        usuario = this.decriptUtils.decryptUsuario(usuario);
        if (null == usuario) {
            throw new CustomException("No existe un registro con esta identificaci\u00f3n", HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity((Object)ApiResponse.ok((int)200, (Object)usuario), (HttpStatusCode)HttpStatus.OK);
    }

    @Generated
    public UsuarioServiceImpl(UsuarioDAO usuarioDAO, DecriptUtils decriptUtils) {
        this.usuarioDAO = usuarioDAO;
        this.decriptUtils = decriptUtils;
    }
}

