/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.biometria.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tws2.firma_s.exceptions.CustomException;
import com.tws2.firma_s.logic.biometria.data.DataFirmaS;
import com.tws2.firma_s.logic.biometria.model.TFirmanteMultiple;
import com.tws2.firma_s.logic.biometria.model.TSolicitud;
import com.tws2.firma_s.logic.biometria.model.TSolicitudResponse;
import com.tws2.firma_s.logic.biometria.model.documento.TDocumento;
import com.tws2.firma_s.logic.biometria.model.dto.DocumentDTO;
import com.tws2.firma_s.logic.biometria.model.dto.FirmadocumentoDTO;
import com.tws2.firma_s.logic.biometria.model.dto.SolicitudDTO;
import com.tws2.firma_s.logic.biometria.model.dto.SolicitudResponseDTO;
import com.tws2.firma_s.logic.biometria.model.firma.TFirmaUbicacion;
import com.tws2.firma_s.logic.biometria.repository.DocumentoDAO;
import com.tws2.firma_s.logic.biometria.repository.FirmaUbicacionDAO;
import com.tws2.firma_s.logic.biometria.repository.FirmanteMultipleDAO;
import com.tws2.firma_s.logic.biometria.repository.SolicitudDAO;
import com.tws2.firma_s.logic.biometria.repository.SolicitudResponseDAO;
import com.tws2.firma_s.logic.biometria.restTemplate.service.FirmaSeguraServiceAPI;
import com.tws2.firma_s.logic.biometria.service.CallbackService;
import com.tws2.firma_s.logic.biometria.service.FirmanteMultipleService;
import com.tws2.firma_s.logic.biometria.service.SolicitudService;
import com.tws2.firma_s.logic.biometria.service.impl.DocumentoCoreServiceImpl;
import com.tws2.firma_s.logic.biometria.utils.ApiResponse;
import com.tws2.firma_s.logic.biometria.utils.DecriptUtils;
import com.tws2.firma_s.logic.biometria.utils.GenerateRandomUtils;
import com.tws2.firma_s.logic.biometria.utils.ValidationUtils;
import ec.tws2.crypto.run.CryptoMain;
import jakarta.transaction.Transactional;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class SolicitudServiceImpl
implements SolicitudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SolicitudServiceImpl.class);
    private final SolicitudDAO solicitudDAO;
    private final SolicitudResponseDAO solicitudResponseDAO;
    private final FirmaSeguraServiceAPI firmaSeguraServiceAPI;
    private final DocumentoDAO documentoDAO;
    private final FirmaUbicacionDAO firmaUbicacionDAO;
    private final CryptoMain cryptoService;
    private final Environment env;
    private final ObjectMapper objectMapper;
    private final FirmanteMultipleService firmanteMultipleService;
    private final FirmanteMultipleDAO firmanteMultipleDAO;
    private final DocumentoCoreServiceImpl core;
    private final DecriptUtils encriptor;
    private final CallbackService callbackService;

    @Transactional
    public ResponseEntity<ApiResponse<?>> saveSolicitud(String fingerCode, String telefono, String city, String address, String callbackUrl, String identificationNumber, String validationLinkLifeTime, String email) {
        String referenceTransaction = GenerateRandomUtils.generarIdentificadorAleatorio();
        String grupoCodigo = GenerateRandomUtils.generarIdentificadorAleatorio();
        TFirmanteMultiple grupo = this.firmanteMultipleService.crearFirmanteMultiple(grupoCodigo, "1");
        String validatLinkLifeTime = ValidationUtils.validationLifeTimeLink((String)validationLinkLifeTime);
        TSolicitud solicitud = new TSolicitud(referenceTransaction, this.cryptoService.encriptar(fingerCode), telefono, city, address, email, Integer.parseInt(validatLinkLifeTime), this.cryptoService.encriptar(identificationNumber), callbackUrl);
        if (this.solicitudDAO.existsByReferenceTransaction(referenceTransaction)) {
            throw new CustomException("Ya existe un registro con esta referencia de transaccion", HttpStatus.BAD_REQUEST);
        }
        solicitud.setFirmanteMultiple(grupo);
        TSolicitud savedSolicitud = (TSolicitud)this.solicitudDAO.save((Object)solicitud);
        TSolicitudResponse solicitudResponse = new TSolicitudResponse();
        SolicitudResponseDTO responseDTO = new SolicitudResponseDTO();
        ResponseEntity firma = this.firmaSeguraServiceAPI.sendToFirmaSegura(referenceTransaction, fingerCode, telefono, city, address, this.env.getProperty("tws.callback.bio-firm"), identificationNumber, Integer.parseInt(validatLinkLifeTime), email);
        responseDTO.setCodigo(((DataFirmaS)firma.getBody()).getTransactionalSignatureRequestId());
        responseDTO.setIdentificacion(identificationNumber);
        responseDTO.setUrl(((DataFirmaS)firma.getBody()).getValidationLink());
        responseDTO.setShort_url("");
        solicitudResponse.setSolicitud(savedSolicitud);
        solicitudResponse.setUrl(((DataFirmaS)firma.getBody()).getValidationLink());
        solicitudResponse.setLinkExpirationDate(((DataFirmaS)firma.getBody()).getLinkExpirationDate());
        solicitudResponse.setRegistrationDate(((DataFirmaS)firma.getBody()).getRegistrationDate());
        solicitudResponse.setCodigo(((DataFirmaS)firma.getBody()).getTransactionalSignatureRequestId());
        this.solicitudResponseDAO.save((Object)solicitudResponse);
        return new ResponseEntity((Object)ApiResponse.ok((int)200, (Object)responseDTO), (HttpStatusCode)HttpStatus.OK);
    }

    public ResponseEntity<ApiResponse<?>> SolicitudGenericBiometriaFirma(String codigoCliente, String identificacion, String codigoDactilar, String nombres, String apellidoPaterno, String apellidoMaterno, String email, String celular, String domicilio, String ciudad, String documentos, String motivo, String origen, String callback, String validationLifeTimeLink, String canal) throws JsonMappingException, JsonProcessingException {
        TSolicitud savedSolicitud = this.crearSolicitudInicial(codigoCliente, identificacion, codigoDactilar, nombres, apellidoPaterno, apellidoMaterno, email, celular, domicilio, ciudad, documentos, motivo, origen, callback, validationLifeTimeLink, canal);
        DataFirmaS responseFirma = (DataFirmaS)this.firmaSeguraServiceAPI.sendToFirmaSegura(savedSolicitud.getReferenceTransaction(), codigoDactilar, celular, ciudad, domicilio, this.env.getProperty("tws.callback.bio-firm"), identificacion, savedSolicitud.getValidationLinkLifeTime().intValue(), email).getBody();
        TSolicitudResponse savedResponse = this.guardarRespuestaExterna(savedSolicitud, responseFirma);
        SolicitudResponseDTO responseDTO = new SolicitudResponseDTO();
        responseDTO.setCodigo(savedResponse.getCodigo());
        responseDTO.setIdentificacion(identificacion);
        responseDTO.setUrl(savedResponse.getUrl());
        responseDTO.setShort_url("");
        return ResponseEntity.ok((Object)ApiResponse.ok((int)200, (Object)responseDTO));
    }

    @Transactional
    public TSolicitud crearSolicitudInicial(String codigoCliente, String identificacion, String codigoDactilar, String nombres, String apellidoPaterno, String apellidoMaterno, String email, String celular, String domicilio, String ciudad, String documentos, String motivo, String origen, String callback, String validationLifeTimeLink, String canal) throws JsonProcessingException {
        String grupoCodigo = GenerateRandomUtils.generarIdentificadorAleatorio();
        TFirmanteMultiple grupo = this.firmanteMultipleService.crearFirmanteMultiple(grupoCodigo, "1");
        String fullName = nombres + " " + apellidoPaterno + " " + apellidoMaterno;
        String referenceTransaction = GenerateRandomUtils.generarIdentificadorAleatorio();
        int lifetime = Integer.parseInt(ValidationUtils.validationLifeTimeLink((String)validationLifeTimeLink));
        TSolicitud solicitud = new TSolicitud(codigoCliente, fullName, referenceTransaction, codigoDactilar, celular, ciudad, domicilio, callback, identificacion, Integer.valueOf(lifetime), email, origen, canal, motivo);
        solicitud = this.encriptor.encryptSolicitud(solicitud);
        solicitud.setFirmanteMultiple(grupo);
        if (this.solicitudDAO.existsByReferenceTransaction(referenceTransaction)) {
            throw new CustomException("Ya existe un registro con esta referencia de transacci\u00f3n", HttpStatus.BAD_REQUEST);
        }
        TSolicitud savedSolicitud = (TSolicitud)this.solicitudDAO.save((Object)solicitud);
        if (documentos != null && !documentos.isEmpty() && !documentos.equals("[]")) {
            List documentosDto = (List)this.objectMapper.readValue(documentos, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            for (DocumentDTO docDto : documentosDto) {
                TDocumento doc = new TDocumento();
                doc.setCodigoDocumento(docDto.getCodigoDocumento());
                doc.setNombre(docDto.getNombre());
                doc.setTipo(docDto.getTipo());
                doc.setArchivoBase64(docDto.getArchivoBase64());
                doc.setFechaRegistro(LocalDateTime.now());
                doc.setGrupo(grupo);
                if (docDto.getPagina() != null) {
                    doc.setPagina(docDto.getPagina().toString());
                }
                if (docDto.getCoordenada() != null) {
                    doc.setCoordenada(docDto.getCoordenada().toString());
                }
                TDocumento savedDoc = (TDocumento)this.documentoDAO.save((Object)doc);
                List paginas = this.convertirJsonNodeALista(docDto.getPagina());
                List coords = this.convertirJsonNodeALista(docDto.getCoordenada());
                for (int i = 0; i < coords.size(); ++i) {
                    String coordenada = (String)coords.get(i);
                    if (coordenada == null || coordenada.trim().isEmpty()) continue;
                    String pagina = "last";
                    if (paginas.size() > i) {
                        pagina = (String)paginas.get(i);
                    } else if (!paginas.isEmpty()) {
                        pagina = (String)paginas.get(0);
                    }
                    String[] parts = coordenada.split(",");
                    TFirmaUbicacion firma = new TFirmaUbicacion();
                    firma.setDocumento(savedDoc);
                    firma.setPagina(pagina);
                    firma.setPosX(parts.length > 0 ? parts[0].trim() : null);
                    firma.setPosY(parts.length > 1 ? parts[1].trim() : null);
                    firma.setFechaCreacion(LocalDateTime.now());
                    this.firmaUbicacionDAO.save((Object)firma);
                }
            }
        }
        return savedSolicitud;
    }

    private List<String> convertirJsonNodeALista(JsonNode nodo) {
        ArrayList<String> lista = new ArrayList<String>();
        if (nodo == null || nodo.isNull()) {
            return lista;
        }
        if (nodo.isArray()) {
            for (JsonNode n : nodo) {
                lista.add(n.asText());
            }
        } else {
            lista.add(nodo.asText());
        }
        return lista;
    }

    @Transactional
    public TSolicitudResponse guardarRespuestaExterna(TSolicitud solicitud, DataFirmaS responseFirma) {
        TSolicitudResponse res = new TSolicitudResponse();
        res.setSolicitud(solicitud);
        res.setUrl(responseFirma.getValidationLink());
        res.setLinkExpirationDate(responseFirma.getLinkExpirationDate());
        res.setRegistrationDate(responseFirma.getRegistrationDate());
        res.setCodigo(responseFirma.getTransactionalSignatureRequestId());
        return (TSolicitudResponse)this.solicitudResponseDAO.save((Object)res);
    }

    public ResponseEntity<ApiResponse<?>> saveDocuments(String cedula, String documentos) throws JsonMappingException, JsonProcessingException {
        String nroTransaccion = this.solicitudDAO.findLatestTransactionToday(cedula);
        if (nroTransaccion == null) {
            throw new CustomException("No existe una solicitud asociada a la c\u00e9dula proporcionada", HttpStatus.BAD_REQUEST);
        }
        List documentosDto = (List)this.objectMapper.readValue(documentos, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        for (DocumentDTO docDto : documentosDto) {
            TDocumento documento = new TDocumento();
            documento.setCodigoDocumento(docDto.getCodigoDocumento());
            documento.setNombre(docDto.getNombre());
            documento.setTipo(docDto.getTipo());
            if (docDto.getPagina() != null) {
                documento.setPagina(docDto.getPagina().toString());
            }
            documento.setArchivoBase64(docDto.getArchivoBase64());
            documento.setFechaRegistro(LocalDateTime.now());
            if (docDto.getCoordenada() != null) {
                documento.setCoordenada(docDto.getCoordenada().toString());
            }
            TDocumento savedDoc = (TDocumento)this.documentoDAO.save((Object)documento);
            this.guardarFirmasDesdeJson(docDto.getPagina(), docDto.getCoordenada(), savedDoc);
        }
        return new ResponseEntity((Object)ApiResponse.ok((int)200, (Object)"Documentos guardados exitosamente"), (HttpStatusCode)HttpStatus.OK);
    }

    private void guardarFirmasDesdeJson(JsonNode paginaNode, JsonNode coordenadaNode, TDocumento savedDoc) {
        TFirmaUbicacion firma;
        String[] parts;
        String pagina;
        if (paginaNode != null && paginaNode.isTextual()) {
            pagina = paginaNode.asText();
            if (coordenadaNode != null && coordenadaNode.isArray()) {
                for (JsonNode coordNode : coordenadaNode) {
                    if (coordNode == null || !coordNode.isTextual()) continue;
                    parts = coordNode.asText().split(",");
                    firma = new TFirmaUbicacion();
                    firma.setDocumento(savedDoc);
                    firma.setPagina(pagina);
                    firma.setPosX(parts.length > 0 ? parts[0].trim() : null);
                    firma.setPosY(parts.length > 1 ? parts[1].trim() : null);
                    firma.setFechaCreacion(LocalDateTime.now());
                    this.firmaUbicacionDAO.save((Object)firma);
                }
            }
        }
        if (paginaNode != null && paginaNode.isArray()) {
            pagina = null;
            for (JsonNode item : paginaNode) {
                if (item.isTextual() && !item.asText().contains(",")) {
                    pagina = item.asText();
                }
                if (!item.isTextual() || !item.asText().contains(",")) continue;
                parts = item.asText().split(",");
                firma = new TFirmaUbicacion();
                firma.setDocumento(savedDoc);
                firma.setPagina(pagina != null ? pagina : "last");
                firma.setPosX(parts.length > 0 ? parts[0].trim() : null);
                firma.setPosY(parts.length > 1 ? parts[1].trim() : null);
                firma.setFechaCreacion(LocalDateTime.now());
                this.firmaUbicacionDAO.save((Object)firma);
            }
        }
    }

    public ResponseEntity<ApiResponse<?>> getInformacion4Firma(String dni) {
        log.info("identificacion:{}", (Object)dni);
        String nroTransaccion = this.solicitudDAO.findLatestTransactionToday(this.cryptoService.encriptar(dni));
        log.info("nroTransaccion:{}", (Object)nroTransaccion);
        FirmadocumentoDTO firmadocumentoDTO = this.solicitudDAO.obtenerCertificadoPorReferencia(nroTransaccion);
        log.info("firmadocumentoDTO:{}", (Object)firmadocumentoDTO);
        if (nroTransaccion == null) {
            throw new CustomException("No existe una solicitud asociada a la c\u00e9dula proporcionada", HttpStatus.BAD_REQUEST);
        }
        if (firmadocumentoDTO == null) {
            throw new CustomException("No se encontr\u00f3 informaci\u00f3n de firma para la c\u00e9dula proporcionada", HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)ApiResponse.ok((int)200, (Object)firmadocumentoDTO), (HttpStatusCode)HttpStatus.OK);
    }

    @Transactional
    public ResponseEntity<ApiResponse<?>> saveMultiplesFirmantes(String firmantes, String validationLifeTimeLink, String callbackUrl, String documentos, String motivo) throws JsonProcessingException {
        List firmantesDto = (List)this.objectMapper.readValue(firmantes, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        List documentosDto = (List)this.objectMapper.readValue(documentos, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        String grupoCodigo = GenerateRandomUtils.generarIdentificadorAleatorio();
        TFirmanteMultiple grupo = this.firmanteMultipleService.crearFirmanteMultiple(grupoCodigo, String.valueOf(firmantesDto.size()));
        List documentosGuardados = this.core.guardarDocumentosNoFirmantes(documentosDto, grupo);
        ArrayList<SolicitudResponseDTO> respuestas = new ArrayList<SolicitudResponseDTO>();
        int tiempoExpiracion = Integer.parseInt(ValidationUtils.validationLifeTimeLink((String)validationLifeTimeLink));
        for (SolicitudDTO firmante : firmantesDto) {
            TSolicitud solicitudSaved = this.crearSolicitudParaFirmante(firmante, grupo, tiempoExpiracion, callbackUrl, motivo);
            log.info("informacion de coordenadas {}", (Object)firmante.getCoordenadas());
            List firmas = this.core.asignarCoordenadasASolicitud(solicitudSaved, documentosGuardados, firmante.getCoordenadas());
            log.info("Firmas guardadas: {}", (Object)firmas);
            SolicitudResponseDTO response = this.generarSolicitudFirmaSegura(firmante, solicitudSaved, tiempoExpiracion, this.env.getProperty("tws.callback.bio-firm"));
            respuestas.add(response);
        }
        return ResponseEntity.ok((Object)ApiResponse.ok((int)200, respuestas));
    }

    private TSolicitud crearSolicitudParaFirmante(SolicitudDTO f, TFirmanteMultiple grupo, int tiempoExpiracion, String callbackUrl, String motivo) {
        String fullName = f.getNombres() + " " + f.getApellido_paterno() + " " + f.getApellido_materno();
        TSolicitud solicitud = new TSolicitud(f.getCodigoCliente(), this.cryptoService.encriptar(fullName), GenerateRandomUtils.generarIdentificadorAleatorio(), this.cryptoService.encriptar(f.getCodigoDactilar()), this.cryptoService.encriptar(f.getCelular()), this.cryptoService.encriptar(f.getCiudad()), this.cryptoService.encriptar(f.getDomicilio()), this.cryptoService.encriptar(callbackUrl), this.cryptoService.encriptar(f.getIdentificacion()), Integer.valueOf(tiempoExpiracion), this.cryptoService.encriptar(f.getEmail()), "BIO", "WEB", this.cryptoService.encriptar(motivo));
        solicitud.setFirmanteMultiple(grupo);
        return (TSolicitud)this.solicitudDAO.save((Object)solicitud);
    }

    private SolicitudResponseDTO generarSolicitudFirmaSegura(SolicitudDTO firmante, TSolicitud solicitudSaved, int tiempoExpiracion, String callbackUrl) {
        ResponseEntity responseFirma = this.firmaSeguraServiceAPI.sendToFirmaSegura(solicitudSaved.getReferenceTransaction(), firmante.getCodigoDactilar(), firmante.getCelular(), firmante.getCiudad(), firmante.getDomicilio(), callbackUrl, firmante.getIdentificacion(), tiempoExpiracion, firmante.getEmail());
        DataFirmaS data = (DataFirmaS)responseFirma.getBody();
        TSolicitudResponse solicitudResponse = new TSolicitudResponse();
        solicitudResponse.setSolicitud(solicitudSaved);
        solicitudResponse.setUrl(data.getValidationLink());
        solicitudResponse.setLinkExpirationDate(data.getLinkExpirationDate());
        solicitudResponse.setRegistrationDate(data.getRegistrationDate());
        solicitudResponse.setCodigo(data.getTransactionalSignatureRequestId());
        this.solicitudResponseDAO.save((Object)solicitudResponse);
        SolicitudResponseDTO dto = new SolicitudResponseDTO();
        dto.setCodigo(solicitudResponse.getCodigo());
        dto.setIdentificacion(firmante.getIdentificacion());
        dto.setUrl(solicitudResponse.getUrl());
        dto.setShort_url("");
        return dto;
    }

    public ResponseEntity<ApiResponse<?>> SolicitudGenericBiometria(String codigoCliente, String identificacion, String codigoDactilar, String nombres, String apellidoPaterno, String apellidoMaterno, String email, String celular, String domicilio, String ciudad, String motivo, String origen, String callback, String validationLifeTimeLink, String canal) throws JsonMappingException, JsonProcessingException {
        TSolicitud savedSolicitud = this.crearSolicitudInicial(codigoCliente, identificacion, codigoDactilar, nombres, apellidoPaterno, apellidoMaterno, email, celular, domicilio, ciudad, "", motivo, origen, callback, validationLifeTimeLink, canal);
        DataFirmaS responseFirma = (DataFirmaS)this.firmaSeguraServiceAPI.sendToFirmaSegura(savedSolicitud.getReferenceTransaction(), codigoDactilar, celular, ciudad, domicilio, this.env.getProperty("tws.callback.bio-firm"), identificacion, savedSolicitud.getValidationLinkLifeTime().intValue(), email).getBody();
        TSolicitudResponse savedResponse = this.guardarRespuestaExterna(savedSolicitud, responseFirma);
        SolicitudResponseDTO responseDTO = new SolicitudResponseDTO();
        responseDTO.setCodigo(savedResponse.getCodigo());
        responseDTO.setIdentificacion(identificacion);
        responseDTO.setUrl(savedResponse.getUrl());
        responseDTO.setShort_url("");
        return ResponseEntity.ok((Object)ApiResponse.ok((int)200, (Object)responseDTO));
    }

    public ResponseEntity<ApiResponse<?>> solicitudBiometriaSimple(String codigoCliente, String identificacion, String codigoDactilar, String nombres, String apellidoPaterno, String apellidoMaterno, String email, String celular, String domicilio, String ciudad, String motivo, String origen, String callback, String validationLifeTimeLink, String canal) throws JsonMappingException, JsonProcessingException {
        TSolicitud savedSolicitud = this.crearSolicitudInicial(codigoCliente, identificacion, codigoDactilar, nombres, apellidoPaterno, apellidoMaterno, email, celular, domicilio, ciudad, "[]", motivo, origen, callback, validationLifeTimeLink, canal);
        DataFirmaS responseFirma = (DataFirmaS)this.firmaSeguraServiceAPI.sendToFirmaSegura(savedSolicitud.getReferenceTransaction(), codigoDactilar, celular, ciudad, domicilio, this.env.getProperty("tws.callback.bio-firm"), identificacion, savedSolicitud.getValidationLinkLifeTime().intValue(), email).getBody();
        TSolicitudResponse savedResponse = this.guardarRespuestaExterna(savedSolicitud, responseFirma);
        SolicitudResponseDTO responseDTO = new SolicitudResponseDTO();
        responseDTO.setCodigo(savedResponse.getCodigo());
        responseDTO.setIdentificacion(identificacion);
        responseDTO.setUrl(savedResponse.getUrl());
        responseDTO.setShort_url("");
        return ResponseEntity.ok((Object)ApiResponse.ok((int)200, (Object)responseDTO));
    }

    public ResponseEntity<ApiResponse<?>> registrarDocumentosYFirmar(String referenceTransaction, String documentos) throws JsonMappingException, JsonProcessingException {
        TFirmanteMultiple grupo = this.firmanteMultipleDAO.findOneByCodigoGrupo(referenceTransaction).getFirmanteMultiple();
        if (grupo == null) {
            throw new CustomException("Solicitud no encontrada para referenceTransaction: " + referenceTransaction, HttpStatus.NOT_FOUND);
        }
        List documentosDto = (List)this.objectMapper.readValue(documentos, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        for (DocumentDTO docDto : documentosDto) {
            TDocumento doc = new TDocumento();
            doc.setCodigoDocumento(docDto.getCodigoDocumento());
            doc.setNombre(docDto.getNombre());
            doc.setTipo(docDto.getTipo());
            doc.setArchivoBase64(docDto.getArchivoBase64());
            doc.setFechaRegistro(LocalDateTime.now());
            doc.setGrupo(grupo);
            if (docDto.getPagina() != null) {
                doc.setPagina(docDto.getPagina().toString());
            }
            if (docDto.getCoordenada() != null) {
                doc.setCoordenada(docDto.getCoordenada().toString());
            }
            TDocumento savedDoc = (TDocumento)this.documentoDAO.save((Object)doc);
            List paginas = this.convertirJsonNodeALista(docDto.getPagina());
            List coords = this.convertirJsonNodeALista(docDto.getCoordenada());
            for (int i = 0; i < coords.size(); ++i) {
                String coordenada = (String)coords.get(i);
                if (coordenada == null || coordenada.trim().isEmpty()) continue;
                String pagina = "last";
                if (paginas.size() > i) {
                    pagina = (String)paginas.get(i);
                } else if (!paginas.isEmpty()) {
                    pagina = (String)paginas.get(0);
                }
                String[] parts = coordenada.split(",");
                TFirmaUbicacion firma = new TFirmaUbicacion();
                firma.setDocumento(savedDoc);
                firma.setPagina(pagina);
                firma.setPosX(parts.length > 0 ? parts[0].trim() : null);
                firma.setPosY(parts.length > 1 ? parts[1].trim() : null);
                firma.setFechaCreacion(LocalDateTime.now());
                this.firmaUbicacionDAO.save((Object)firma);
            }
        }
        this.callbackService.procesarFirmadoYReenvio(((TSolicitud)grupo.getSolicitudes().get(0)).getReferenceTransaction());
        return ResponseEntity.ok((Object)ApiResponse.ok((int)200, (Object)"Documentos procesados"));
    }

    @Generated
    public SolicitudServiceImpl(SolicitudDAO solicitudDAO, SolicitudResponseDAO solicitudResponseDAO, FirmaSeguraServiceAPI firmaSeguraServiceAPI, DocumentoDAO documentoDAO, FirmaUbicacionDAO firmaUbicacionDAO, CryptoMain cryptoService, Environment env, ObjectMapper objectMapper, FirmanteMultipleService firmanteMultipleService, FirmanteMultipleDAO firmanteMultipleDAO, DocumentoCoreServiceImpl core, DecriptUtils encriptor, CallbackService callbackService) {
        this.solicitudDAO = solicitudDAO;
        this.solicitudResponseDAO = solicitudResponseDAO;
        this.firmaSeguraServiceAPI = firmaSeguraServiceAPI;
        this.documentoDAO = documentoDAO;
        this.firmaUbicacionDAO = firmaUbicacionDAO;
        this.cryptoService = cryptoService;
        this.env = env;
        this.objectMapper = objectMapper;
        this.firmanteMultipleService = firmanteMultipleService;
        this.firmanteMultipleDAO = firmanteMultipleDAO;
        this.core = core;
        this.encriptor = encriptor;
        this.callbackService = callbackService;
    }
}

