/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tws2.firma_s.exceptions.CustomException;
import com.tws2.firma_s.logic.data.DataFirmaS;
import com.tws2.firma_s.logic.model.TSolicitud;
import com.tws2.firma_s.logic.model.TSolicitudResponse;
import com.tws2.firma_s.logic.model.documento.TDocumento;
import com.tws2.firma_s.logic.model.dto.DocumentoDTO;
import com.tws2.firma_s.logic.model.firma.TFirmaUbicacion;
import com.tws2.firma_s.logic.repository.DocumentoDAO;
import com.tws2.firma_s.logic.repository.FirmaUbicacionDAO;
import com.tws2.firma_s.logic.repository.SolicitudDAO;
import com.tws2.firma_s.logic.repository.SolicitudResponseDAO;
import com.tws2.firma_s.logic.restTemplate.service.FirmaSeguraServiceAPI;
import com.tws2.firma_s.logic.service.SolicitudService;
import com.tws2.firma_s.utils.ApiResponse;
import com.tws2.firma_s.utils.DecriptUtils;
import jakarta.transaction.Transactional;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class SolicitudServiceImpl
implements SolicitudService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SolicitudServiceImpl.class);
    private final SolicitudDAO solicitudDAO;
    private final SolicitudResponseDAO solicitudResponseDAO;
    private final FirmaSeguraServiceAPI firmaSeguraServiceAPI;
    private final DocumentoDAO documentoDAO;
    private final FirmaUbicacionDAO firmaUbicacionDAO;
    private final DecriptUtils decriptUtils;
    private final Environment env;

    @Transactional
    public ResponseEntity<ApiResponse<?>> saveSolicitud(String referenceTransaction, String fingerCode, String telefono, String city, String address, String callbackUrl, String identificationNumber, Integer validationLinkLifeTime, String email) {
        TSolicitud solicitud = new TSolicitud(referenceTransaction, this.decriptUtils.encrypt(fingerCode), telefono, city, address, email, validationLinkLifeTime.intValue(), this.decriptUtils.encrypt(identificationNumber), callbackUrl);
        solicitud = this.decriptUtils.encryptSolicitud(solicitud, this.decriptUtils);
        if (this.solicitudDAO.existsByReferenceTransaction(referenceTransaction)) {
            throw new CustomException("Ya existe un registro con esta referencia de transaccion", HttpStatus.BAD_REQUEST);
        }
        TSolicitud savedSolicitud = (TSolicitud)this.solicitudDAO.save((Object)solicitud);
        TSolicitudResponse solicitudResponse = new TSolicitudResponse();
        ResponseEntity firma = this.firmaSeguraServiceAPI.sendToFirmaSegura(referenceTransaction, fingerCode, telefono, city, address, this.env.getProperty("tws.callback.bio-firm"), identificationNumber, validationLinkLifeTime.intValue(), email);
        solicitudResponse.setSolicitud(savedSolicitud);
        solicitudResponse.setValidationLink(((DataFirmaS)firma.getBody()).getValidationLink());
        solicitudResponse.setLinkExpirationDate(((DataFirmaS)firma.getBody()).getLinkExpirationDate());
        solicitudResponse.setRegistrationDate(((DataFirmaS)firma.getBody()).getRegistrationDate());
        solicitudResponse.setTransactionalSignatureRequestId(((DataFirmaS)firma.getBody()).getTransactionalSignatureRequestId());
        this.solicitudResponseDAO.save((Object)solicitudResponse);
        return new ResponseEntity((Object)ApiResponse.ok((int)200, (Object)((DataFirmaS)firma.getBody())), (HttpStatusCode)HttpStatus.OK);
    }

    @Transactional
    public ResponseEntity<ApiResponse<?>> SolicitudBiometriaFirma(String referenceTransaction, String fingerCode, String telefono, String city, String address, String callbackUrl, String identificationNumber, Integer validationLinkLifeTime, String email, String documentos) throws JsonMappingException, JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        TSolicitud solicitud = new TSolicitud(referenceTransaction, fingerCode, telefono, city, address, email, validationLinkLifeTime.intValue(), identificationNumber, callbackUrl);
        if (this.solicitudDAO.existsByReferenceTransaction(referenceTransaction)) {
            throw new CustomException("Ya existe un registro con esta referencia de transacci\u00f3n", HttpStatus.BAD_REQUEST);
        }
        TSolicitud savedSolicitud = (TSolicitud)this.solicitudDAO.save((Object)solicitud);
        List documentosDto = (List)objectMapper.readValue(documentos, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        for (DocumentoDTO docDto : documentosDto) {
            TDocumento documento = new TDocumento(docDto.getCodigoDoc(), docDto.getNombreDoc(), docDto.getPdfBase64(), savedSolicitud);
            TDocumento savedDoc = (TDocumento)this.documentoDAO.save((Object)documento);
            List firmas = docDto.getCoordenadas().stream().map(coord -> {
                TFirmaUbicacion firma = new TFirmaUbicacion();
                firma.setDocumento(savedDoc);
                firma.setPagina(coord.getPagina());
                firma.setPosX(String.valueOf(coord.getPosX()));
                firma.setPosY(String.valueOf(coord.getPosY()));
                firma.setFechaCreacion(LocalDateTime.now());
                return firma;
            }).collect(Collectors.toList());
            this.firmaUbicacionDAO.saveAll(firmas);
        }
        ResponseEntity responseFirma = this.firmaSeguraServiceAPI.sendToFirmaSegura(referenceTransaction, fingerCode, telefono, city, address, this.env.getProperty("tws.callback.bio-firm"), identificationNumber, validationLinkLifeTime.intValue(), email);
        TSolicitudResponse solicitudResponse = new TSolicitudResponse();
        solicitudResponse.setSolicitud(savedSolicitud);
        solicitudResponse.setValidationLink(((DataFirmaS)responseFirma.getBody()).getValidationLink());
        solicitudResponse.setLinkExpirationDate(((DataFirmaS)responseFirma.getBody()).getLinkExpirationDate());
        solicitudResponse.setRegistrationDate(((DataFirmaS)responseFirma.getBody()).getRegistrationDate());
        solicitudResponse.setTransactionalSignatureRequestId(((DataFirmaS)responseFirma.getBody()).getTransactionalSignatureRequestId());
        this.solicitudResponseDAO.save((Object)solicitudResponse);
        return new ResponseEntity((Object)ApiResponse.ok((int)200, (Object)((DataFirmaS)responseFirma.getBody())), (HttpStatusCode)HttpStatus.OK);
    }

    @Generated
    public SolicitudServiceImpl(SolicitudDAO solicitudDAO, SolicitudResponseDAO solicitudResponseDAO, FirmaSeguraServiceAPI firmaSeguraServiceAPI, DocumentoDAO documentoDAO, FirmaUbicacionDAO firmaUbicacionDAO, DecriptUtils decriptUtils, Environment env) {
        this.solicitudDAO = solicitudDAO;
        this.solicitudResponseDAO = solicitudResponseDAO;
        this.firmaSeguraServiceAPI = firmaSeguraServiceAPI;
        this.documentoDAO = documentoDAO;
        this.firmaUbicacionDAO = firmaUbicacionDAO;
        this.decriptUtils = decriptUtils;
        this.env = env;
    }
}

