/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.service.impl;

import com.tws2.firma_s.logic.model.TCallbackBiometria;
import com.tws2.firma_s.logic.model.documento.TDocumento;
import com.tws2.firma_s.logic.model.dto.BackDTO;
import com.tws2.firma_s.logic.model.dto.CallbackDTO;
import com.tws2.firma_s.logic.model.dto.DocumentoEnvioDTO;
import com.tws2.firma_s.logic.model.dto.FrontDTO;
import com.tws2.firma_s.logic.model.dto.ImageDataDTO;
import com.tws2.firma_s.logic.model.dto.IndicatorDTO;
import com.tws2.firma_s.logic.model.dto.MetadataDTO;
import com.tws2.firma_s.logic.model.dto.ProcessedDTO;
import com.tws2.firma_s.logic.repository.CallbackBiometriaDAO;
import com.tws2.firma_s.logic.repository.DocumentoDAO;
import com.tws2.firma_s.logic.service.ReenvioService;
import jakarta.transaction.Transactional;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ReenvioServiceImpl
implements ReenvioService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReenvioServiceImpl.class);
    private final DocumentoDAO documentoDAO;
    private final CallbackBiometriaDAO biometriaDAO;
    private final RestTemplate restTemplate = new RestTemplate();
    private final Environment env;

    @Async
    @Transactional
    public void reenvioBiometriaCallback(String referenceTransaction) {
        if (this.estanTodosFirmados(referenceTransaction)) {
            TCallbackBiometria callback = this.biometriaDAO.findByReferenceTransaccion(referenceTransaction);
            CallbackDTO dto = new CallbackDTO();
            dto.setReferenceTransaction(callback.getSolicitud().getReferenceTransaction());
            dto.setStatus(callback.getData().getCallback().getStatus());
            dto.setResponseDate(callback.getResponseDate());
            List imageDataList = callback.getData().getImageData().stream().map(img -> {
                ImageDataDTO dtoImg = new ImageDataDTO();
                dtoImg.setType(img.getType());
                dtoImg.setImage(img.getImage());
                dtoImg.setConfidence(img.getConfidence().doubleValue());
                dtoImg.setSimilarity(img.getSimilarity().doubleValue());
                dtoImg.setValid(img.getValid().booleanValue());
                return dtoImg;
            }).collect(Collectors.toList());
            dto.setImageData(imageDataList);
            dto.setFrontAttempt(callback.getData().getFrontAttempt());
            dto.setBackAttempt(callback.getData().getBackAttempt());
            dto.setSelfieAttempt(callback.getData().getSelfieAttempt());
            dto.setIp(callback.getData().getIp());
            IndicatorDTO indicator = new IndicatorDTO();
            indicator.setFront(new FrontDTO(callback.getData().getCallback().getIndicator().getFront().getIdentificationNumber(), callback.getData().getCallback().getIndicator().getFront().getMetadata()));
            indicator.setBack(new BackDTO(callback.getData().getCallback().getIndicator().getBack().getFingerCode(), callback.getData().getCallback().getIndicator().getBack().getMetadata()));
            ProcessedDTO processed = new ProcessedDTO(callback.getData().getCallback().getIndicator().getMetadata().getProcessed().getIdentificationNumber(), callback.getData().getCallback().getIndicator().getMetadata().getProcessed().getFullName(), callback.getData().getCallback().getIndicator().getMetadata().getProcessed().getFingerCode(), callback.getData().getCallback().getIndicator().getMetadata().getProcessed().getBirthDate(), callback.getData().getCallback().getIndicator().getMetadata().getProcessed().getBirthPlace(), callback.getData().getCallback().getIndicator().getMetadata().getProcessed().getExpeditionDate(), callback.getData().getCallback().getIndicator().getMetadata().getProcessed().getExpirationDate(), callback.getData().getCallback().getIndicator().getMetadata().getProcessed().getOlderAgeDate(), callback.getData().getCallback().getIndicator().getMetadata().getProcessed().getCurrentAge(), callback.getData().getCallback().getIndicator().getMetadata().getProcessed().getCurrentDate());
            indicator.setMetadata(new MetadataDTO(processed));
            indicator.setConfidence(callback.getData().getCallback().getIndicator().getConfidence());
            dto.setIndicator(indicator);
            this.PostToClient((Object)dto, callback.getSolicitud().getCallbackUrl());
            this.reenvioDocumentos(referenceTransaction, callback.getSolicitud().getCallbackUrl());
        }
    }

    public void reenvioDocumentos(String referenceTransaction, String url) {
        if (this.estanTodosFirmados(referenceTransaction)) {
            List documentos = this.documentoDAO.findAllDocumentsByReferenceTransacciontion(referenceTransaction);
            for (TDocumento doc : documentos) {
                DocumentoEnvioDTO documentoDTO = new DocumentoEnvioDTO();
                documentoDTO.setReferenceTransacction(referenceTransaction);
                documentoDTO.setCodigoDoc(doc.getCodigoDoc());
                documentoDTO.setNombreDoc(doc.getNombreDoc());
                documentoDTO.setPdfBase64Signed(doc.getPdfBase64Signed());
                documentoDTO.setFechaFirmado(doc.getFechaFirmado());
                documentoDTO.setFechaRegistro(doc.getFechaRegistro());
                documentoDTO.setFirmado(doc.isFirmado());
                this.PostToClient((Object)documentoDTO, url);
            }
        }
    }

    public <T> String PostToClient(T dto, String url) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity(dto, (MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)request, String.class, new Object[0]);
        return (String)response.getBody();
    }

    public boolean estanTodosFirmados(String referenceTransaction) {
        long total = this.documentoDAO.contarTotal(referenceTransaction);
        long firmados = this.documentoDAO.contarFirmados(referenceTransaction);
        return total > 0L && total == firmados;
    }

    @Generated
    public ReenvioServiceImpl(DocumentoDAO documentoDAO, CallbackBiometriaDAO biometriaDAO, Environment env) {
        this.documentoDAO = documentoDAO;
        this.biometriaDAO = biometriaDAO;
        this.env = env;
    }
}

