/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.service.impl;

import com.tws2.firma_s.exceptions.CustomException;
import com.tws2.firma_s.logic.model.TCallbackBiometria;
import com.tws2.firma_s.logic.model.TSolicitud;
import com.tws2.firma_s.logic.model.biometria.TImageData;
import com.tws2.firma_s.logic.model.biometria.TIndicadores;
import com.tws2.firma_s.logic.model.biometria.TMetadata;
import com.tws2.firma_s.logic.model.documento.TDocumento;
import com.tws2.firma_s.logic.model.dto.FirmadocumentoDTO;
import com.tws2.firma_s.logic.repository.CallbackBiometriaDAO;
import com.tws2.firma_s.logic.repository.DocumentoDAO;
import com.tws2.firma_s.logic.repository.FirmaUbicacionDAO;
import com.tws2.firma_s.logic.repository.SolicitudDAO;
import com.tws2.firma_s.logic.service.CallbackService;
import com.tws2.firma_s.logic.service.ReenvioService;
import com.tws2.firma_s.logic.service.SignDocumentoService;
import com.tws2.firma_s.utils.ApiResponse;
import com.tws2.firma_s.utils.DecriptUtils;
import jakarta.transaction.Transactional;
import java.time.LocalDateTime;
import java.util.Base64;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class CallbackServiceImpl
implements CallbackService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CallbackServiceImpl.class);
    private final CallbackBiometriaDAO callbackDAO;
    private final SolicitudDAO solicitudDAO;
    private final DocumentoDAO documentoDAO;
    private final FirmaUbicacionDAO firmaDAO;
    private final SignDocumentoService signDocumentService;
    private final DecriptUtils encriptUtils;
    private final ReenvioService reenvioService;

    @Transactional
    public ResponseEntity<ApiResponse<?>> guardarCallbackBiometria(TCallbackBiometria callback) {
        String refTransaction = callback.getReferenceTransaction();
        TSolicitud solicitudOpt = this.solicitudDAO.findByReferenceTransaction(refTransaction);
        if (solicitudOpt == null) {
            throw new CustomException("Error: No se encontr\u00f3 la solicitud con referenceTransaction: " + refTransaction, HttpStatus.BAD_REQUEST);
        }
        callback.setSolicitud(solicitudOpt);
        if (callback.getData() != null) {
            callback.getData().setCallback(callback);
            if (callback.getData().getImageData() != null) {
                for (TImageData image : callback.getData().getImageData()) {
                    image.setDataBiometria(callback.getData());
                }
            }
        }
        if (callback.getErrorMessage() != null) {
            callback.getErrorMessage().setCallback(callback);
        }
        if (callback.getIndicator() != null) {
            TIndicadores indicadores = callback.getIndicator();
            indicadores.setCallback(callback);
            if (indicadores.getFront() != null) {
                indicadores.getFront().setIndicator(indicadores);
            }
            if (indicadores.getBack() != null) {
                indicadores.getBack().setIndicator(indicadores);
            }
            if (indicadores.getMetadata() != null) {
                TMetadata metadata = indicadores.getMetadata();
                metadata.setIndicadores(indicadores);
                if (metadata.getProcessed() != null) {
                    metadata.getProcessed().setMetadata(metadata);
                }
                if (metadata.getResult() != null) {
                    metadata.getResult().setMetadata(metadata);
                }
            }
        }
        callback = this.encriptUtils.encript(callback);
        this.callbackDAO.save((Object)callback);
        log.info("transaccion de referencia:{}:{}", (Object)refTransaction);
        this.firmarDocumentosAsync(callback.getReferenceTransaction());
        return new ResponseEntity((Object)ApiResponse.ok((int)200, (Object)"Informacion Guardada"), (HttpStatusCode)HttpStatus.OK);
    }

    @Async
    public void firmarDocumentosAsync(String referenceTransaction) {
        this.procesarFirmadoYReenvio(referenceTransaction);
    }

    public void procesarFirmadoYReenvio(String referenceTransaction) {
        FirmadocumentoDTO certData = this.solicitudDAO.obtenerCertificadoPorReferencia(referenceTransaction);
        log.info("{}:{}", (Object)certData);
        if (certData == null) {
            throw new CustomException("Certificado no disponible para esta transacci\u00f3n", HttpStatus.BAD_REQUEST);
        }
        TSolicitud solicitud = this.solicitudDAO.findByReferenceTransaction(referenceTransaction);
        if (solicitud == null) {
            throw new CustomException("Solicitud no encontrada", HttpStatus.NOT_FOUND);
        }
        List documentos = this.documentoDAO.findDocumentsBySolicitud(solicitud.getId());
        for (TDocumento doc : documentos) {
            log.info("documento:{}:{}", (Object)doc);
            List coordenadas = this.firmaDAO.findLocationByIdDocumento(doc.getId());
            byte[] certificadoBytes = Base64.getDecoder().decode(certData.getCertificate());
            String pdfFirmado = this.signDocumentService.signDocumento(doc.getPdfBase64(), certificadoBytes, this.encriptUtils.decrypt(certData.getPassword()), coordenadas, certData.getIdentification());
            log.info("documento:{}:{}", (Object)pdfFirmado);
            doc.setPdfBase64(null);
            doc.setPdfBase64Signed(pdfFirmado);
            doc.setFechaFirmado(LocalDateTime.now());
            doc.setFirmado(true);
            this.documentoDAO.save((Object)doc);
        }
        if (!this.estanTodosFirmados(referenceTransaction)) {
            throw new CustomException("Todavia no est\u00e1n firmados todos los documentos", HttpStatus.BAD_REQUEST);
        }
        this.reenvioService.reenvioBiometriaCallback(referenceTransaction);
    }

    public boolean estanTodosFirmados(String referenceTransaction) {
        long total = this.documentoDAO.contarTotal(referenceTransaction);
        long firmados = this.documentoDAO.contarFirmados(referenceTransaction);
        return total > 0L && total == firmados;
    }

    @Generated
    public CallbackServiceImpl(CallbackBiometriaDAO callbackDAO, SolicitudDAO solicitudDAO, DocumentoDAO documentoDAO, FirmaUbicacionDAO firmaDAO, SignDocumentoService signDocumentService, DecriptUtils encriptUtils, ReenvioService reenvioService) {
        this.callbackDAO = callbackDAO;
        this.solicitudDAO = solicitudDAO;
        this.documentoDAO = documentoDAO;
        this.firmaDAO = firmaDAO;
        this.signDocumentService = signDocumentService;
        this.encriptUtils = encriptUtils;
        this.reenvioService = reenvioService;
    }
}

