/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.service.impl;

import com.tws2.firma_s.logic.data.KeycloakResponseToken;
import com.tws2.firma_s.logic.service.AuthService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@Service
public class AuthServiceImpl
implements AuthService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuthServiceImpl.class);
    private final Environment env;
    private final RestTemplate restTemplate;

    public ResponseEntity<?> getTokenWithPasswordGrant(String username, String password) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap form = new LinkedMultiValueMap();
        form.add((Object)"grant_type", (Object)"password");
        form.add((Object)"client_id", (Object)"servicios_enext");
        form.add((Object)"username", (Object)username);
        form.add((Object)"password", (Object)password);
        HttpEntity req = new HttpEntity((Object)form, (MultiValueMap)headers);
        try {
            KeycloakResponseToken body = (KeycloakResponseToken)this.restTemplate.postForObject(this.env.getProperty("token.url"), (Object)req, KeycloakResponseToken.class, new Object[0]);
            return ResponseEntity.ok((Object)body);
        }
        catch (HttpStatusCodeException e) {
            return ResponseEntity.status((HttpStatusCode)e.getStatusCode()).body((Object)e.getResponseBodyAsString());
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)("Error solicitando token: " + e.getMessage()));
        }
    }

    @Generated
    public AuthServiceImpl(Environment env, RestTemplate restTemplate) {
        this.env = env;
        this.restTemplate = restTemplate;
    }
}

