/*
 * Decompiled with CFR 0.152.
 */
package com.tws2.firma_s.logic.restTemplate;

import com.tws2.firma_s.logic.data.DataFirmaS;
import com.tws2.firma_s.logic.restTemplate.service.FirmaSeguraServiceAPI;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class FirmaSeguraServiceAPIImpl
implements FirmaSeguraServiceAPI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FirmaSeguraServiceAPIImpl.class);
    private final RestTemplate restTemplate;
    private final Environment env;

    public ResponseEntity<DataFirmaS> sendToFirmaSegura(String referenceTransaction, String fingerCode, String telefono, String city, String address, String callbackUrl, String identificationNumber, int validationLinkLifeTime, String email) {
        String token = this.env.getProperty("external.token.firmas");
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", "Bearer " + token);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("referenceTransaction", referenceTransaction);
        params.put("fingerCode", fingerCode);
        params.put("cellphoneNumber", telefono);
        params.put("city", city);
        params.put("address", address);
        params.put("callbackUrl", callbackUrl);
        params.put("identificationNumber", identificationNumber);
        params.put("validationLinkLifetime", String.valueOf(validationLinkLifeTime));
        params.put("email", email);
        HttpEntity entity = new HttpEntity(params, (MultiValueMap)headers);
        return this.restTemplate.exchange(this.env.getProperty("external.url.firmasegura") + "/collector/transactional-signature/request", HttpMethod.POST, entity, DataFirmaS.class, new Object[0]);
    }

    @Generated
    public FirmaSeguraServiceAPIImpl(RestTemplate restTemplate, Environment env) {
        this.restTemplate = restTemplate;
        this.env = env;
    }
}

